/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ClusterClientProvider;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestGateway;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class ClusterClientJobClientAdapter<ClusterID>
implements JobClient,
CoordinationRequestGateway {
    private final ClusterClientProvider<ClusterID> clusterClientProvider;
    private final JobID jobID;
    private final ClassLoader classLoader;

    public ClusterClientJobClientAdapter(ClusterClientProvider<ClusterID> clusterClientProvider, JobID jobID, ClassLoader classLoader) {
        this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        this.clusterClientProvider = (ClusterClientProvider)Preconditions.checkNotNull(clusterClientProvider);
        this.classLoader = classLoader;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public CompletableFuture<JobStatus> getJobStatus() {
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.getJobStatus(this.jobID));
    }

    public CompletableFuture<Void> cancel() {
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.cancel(this.jobID).thenApply(ignored -> null));
    }

    public CompletableFuture<String> stopWithSavepoint(boolean advanceToEndOfEventTime, @Nullable String savepointDirectory) {
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.stopWithSavepoint(this.jobID, advanceToEndOfEventTime, savepointDirectory));
    }

    public CompletableFuture<String> triggerSavepoint(@Nullable String savepointDirectory) {
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.triggerSavepoint(this.jobID, savepointDirectory));
    }

    public CompletableFuture<Map<String, Object>> getAccumulators() {
        Preconditions.checkNotNull((Object)this.classLoader);
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.getAccumulators(this.jobID, this.classLoader));
    }

    public CompletableFuture<JobExecutionResult> getJobExecutionResult() {
        Preconditions.checkNotNull((Object)this.classLoader);
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.requestJobResult(this.jobID).thenApply(jobResult -> {
            try {
                return jobResult.toJobExecutionResult(this.classLoader);
            }
            catch (Throwable t) {
                throw new CompletionException(new ProgramInvocationException("Job failed", this.jobID, t));
            }
        }));
    }

    public CompletableFuture<CoordinationResponse> sendCoordinationRequest(OperatorID operatorId, CoordinationRequest request) {
        return ClusterClientJobClientAdapter.bridgeClientRequest(this.clusterClientProvider, clusterClient -> clusterClient.sendCoordinationRequest(this.jobID, operatorId, request));
    }

    private static <T> CompletableFuture<T> bridgeClientRequest(ClusterClientProvider<?> clusterClientProvider, Function<ClusterClient<?>, CompletableFuture<T>> resultRetriever) {
        CompletableFuture<T> resultFuture;
        ClusterClient<?> clusterClient = clusterClientProvider.getClusterClient();
        try {
            resultFuture = resultRetriever.apply(clusterClient);
        }
        catch (Throwable throwable2) {
            IOUtils.closeQuietly(clusterClient::close);
            return FutureUtils.completedExceptionally((Throwable)throwable2);
        }
        return resultFuture.whenCompleteAsync((jobResult, throwable) -> IOUtils.closeQuietly(clusterClient::close));
    }
}

