/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PivotVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;

public class UnPivot {
    private boolean includeNulls = false;
    private boolean includeNullsSpecified = false;
    private List<Column> unpivotClause;
    private List<Column> unpivotForClause;
    private List<SelectExpressionItem> unpivotInClause;
    private Alias alias;

    public void accept(PivotVisitor pivotVisitor) {
        pivotVisitor.visit(this);
    }

    public boolean getIncludeNulls() {
        return this.includeNulls;
    }

    public void setIncludeNulls(boolean includeNulls) {
        this.includeNullsSpecified = true;
        this.includeNulls = includeNulls;
    }

    public boolean getIncludeNullsSpecified() {
        return this.includeNullsSpecified;
    }

    public List<Column> getUnPivotClause() {
        return this.unpivotClause;
    }

    public void setUnPivotClause(List<Column> unpivotClause) {
        this.unpivotClause = unpivotClause;
    }

    public List<Column> getUnPivotForClause() {
        return this.unpivotForClause;
    }

    public void setUnPivotForClause(List<Column> forColumns) {
        this.unpivotForClause = forColumns;
    }

    public List<SelectExpressionItem> getUnPivotInClause() {
        return this.unpivotInClause;
    }

    public void setUnPivotInClause(List<SelectExpressionItem> unpivotInClause) {
        this.unpivotInClause = unpivotInClause;
    }

    public String toString() {
        return "UNPIVOT" + (this.includeNullsSpecified && this.includeNulls ? " INCLUDE NULLS" : "") + (this.includeNullsSpecified && !this.includeNulls ? " EXCLUDE NULLS" : "") + " (" + PlainSelect.getStringList(this.unpivotClause, true, this.unpivotClause != null && this.unpivotClause.size() > 1) + " FOR " + PlainSelect.getStringList(this.unpivotForClause, true, this.unpivotForClause != null && this.unpivotForClause.size() > 1) + " IN " + PlainSelect.getStringList(this.unpivotInClause, true, true) + ")" + (this.alias != null ? this.alias.toString() : "");
    }

    public UnPivot withIncludeNulls(boolean includeNulls) {
        this.setIncludeNulls(includeNulls);
        return this;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }
}

