/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartBackoffTimeStrategy;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class FailureRateRestartBackoffTimeStrategy
implements RestartBackoffTimeStrategy {
    private final long failuresIntervalMS;
    private final long backoffTimeMS;
    private final int maxFailuresPerInterval;
    private final Deque<Long> failureTimestamps;
    private final String strategyString;
    private final Clock clock;

    FailureRateRestartBackoffTimeStrategy(Clock clock, int maxFailuresPerInterval, long failuresIntervalMS, long backoffTimeMS) {
        Preconditions.checkArgument((maxFailuresPerInterval > 0 ? 1 : 0) != 0, (Object)"Maximum number of restart attempts per time unit must be greater than 0.");
        Preconditions.checkArgument((failuresIntervalMS > 0L ? 1 : 0) != 0, (Object)"Failures interval must be greater than 0 ms.");
        Preconditions.checkArgument((backoffTimeMS >= 0L ? 1 : 0) != 0, (Object)"Backoff time must be at least 0 ms.");
        this.failuresIntervalMS = failuresIntervalMS;
        this.backoffTimeMS = backoffTimeMS;
        this.maxFailuresPerInterval = maxFailuresPerInterval;
        this.failureTimestamps = new ArrayDeque<Long>(maxFailuresPerInterval);
        this.strategyString = this.generateStrategyString();
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    @Override
    public boolean canRestart() {
        if (this.isFailureTimestampsQueueFull()) {
            Long now = this.clock.absoluteTimeMillis();
            Long earliestFailure = this.failureTimestamps.peek();
            return now - earliestFailure > this.failuresIntervalMS;
        }
        return true;
    }

    @Override
    public long getBackoffTime() {
        return this.backoffTimeMS;
    }

    @Override
    public void notifyFailure(Throwable cause) {
        if (this.isFailureTimestampsQueueFull()) {
            this.failureTimestamps.remove();
        }
        this.failureTimestamps.add(this.clock.absoluteTimeMillis());
    }

    public String toString() {
        return this.strategyString;
    }

    private boolean isFailureTimestampsQueueFull() {
        return this.failureTimestamps.size() > this.maxFailuresPerInterval;
    }

    private String generateStrategyString() {
        StringBuilder str = new StringBuilder("FailureRateRestartBackoffTimeStrategy(");
        str.append("FailureRateRestartBackoffTimeStrategy(failuresIntervalMS=");
        str.append(this.failuresIntervalMS);
        str.append(",backoffTimeMS=");
        str.append(this.backoffTimeMS);
        str.append(",maxFailuresPerInterval=");
        str.append(this.maxFailuresPerInterval);
        str.append(")");
        return str.toString();
    }

    public static FailureRateRestartBackoffTimeStrategyFactory createFactory(Configuration configuration) {
        int maxFailuresPerInterval = configuration.getInteger(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_MAX_FAILURES_PER_INTERVAL);
        long failuresInterval = ((Duration)configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_FAILURE_RATE_INTERVAL)).toMillis();
        long delay = ((Duration)configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_DELAY)).toMillis();
        return new FailureRateRestartBackoffTimeStrategyFactory(maxFailuresPerInterval, failuresInterval, delay);
    }

    public static class FailureRateRestartBackoffTimeStrategyFactory
    implements RestartBackoffTimeStrategy.Factory {
        private final int maxFailuresPerInterval;
        private final long failuresIntervalMS;
        private final long backoffTimeMS;

        public FailureRateRestartBackoffTimeStrategyFactory(int maxFailuresPerInterval, long failuresIntervalMS, long backoffTimeMS) {
            this.maxFailuresPerInterval = maxFailuresPerInterval;
            this.failuresIntervalMS = failuresIntervalMS;
            this.backoffTimeMS = backoffTimeMS;
        }

        @Override
        public RestartBackoffTimeStrategy create() {
            return new FailureRateRestartBackoffTimeStrategy((Clock)SystemClock.getInstance(), this.maxFailuresPerInterval, this.failuresIntervalMS, this.backoffTimeMS);
        }
    }
}

