/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client.trait;

import java.lang.reflect.Method;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ClusterClientProvider;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.FlinkException;
import org.apache.flink.yarn.YarnClusterClientFactory;
import org.apache.flink.yarn.YarnClusterDescriptor;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.SavepointRequestTrait;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.client.trait.YarnClientTrait;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public abstract class YarnClientTrait$class {
    public static Object org$apache$streampark$flink$client$trait$YarnClientTrait$$executeClientAction(YarnClientTrait $this, SavepointRequestTrait request, Configuration flinkConf, Function2 actionFunc) {
        JobID jobID = $this.getJobID(request.jobId());
        $this.EnhanceFlinkConfiguration(flinkConf).safeSet(YarnConfigOptions.APPLICATION_ID, request.clusterId());
        YarnClusterClientFactory clusterClientFactory = new YarnClusterClientFactory();
        ApplicationId applicationId = clusterClientFactory.getClusterId(flinkConf);
        if (applicationId == null) {
            throw new FlinkException("[StreamPark] getClusterClient error. No cluster id was specified. Please specify a cluster to which you would like to connect.");
        }
        YarnClusterDescriptor clusterDescriptor = clusterClientFactory.createClusterDescriptor(flinkConf);
        ClusterClient clusterClient = clusterDescriptor.retrieve(applicationId).getClusterClient();
        return Try$.MODULE$.apply((Function0)new Serializable($this, actionFunc, jobID, clusterClient){
            public static final long serialVersionUID = 0L;
            private final Function2 actionFunc$1;
            private final JobID jobID$1;
            private final ClusterClient clusterClient$1;

            public final Object apply() {
                return this.actionFunc$1.apply((Object)this.jobID$1, (Object)this.clusterClient$1);
            }
            {
                this.actionFunc$1 = actionFunc$1;
                this.jobID$1 = jobID$1;
                this.clusterClient$1 = clusterClient$1;
            }
        }).recover((PartialFunction)new Serializable($this, request){
            public static final long serialVersionUID = 0L;
            private final SavepointRequestTrait request$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new FlinkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] Do ", " for the job ", " failed. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.getClass().getSimpleName(), this.request$1.jobId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"detail: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.stringifyException(A1)}))).toString());
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.request$1 = request$1;
            }
        }).get();
    }

    public static SavepointResponse doTriggerSavepoint(YarnClientTrait $this, TriggerSavepointRequest request, Configuration flinkConf) {
        return (SavepointResponse)YarnClientTrait$class.org$apache$streampark$flink$client$trait$YarnClientTrait$$executeClientAction($this, (SavepointRequestTrait)request, flinkConf, (Function2)new Serializable($this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClientTrait $outer;
            private final TriggerSavepointRequest request$2;

            public final SavepointResponse apply(JobID jid, ClusterClient<?> client) {
                return new SavepointResponse(this.$outer.org$apache$streampark$flink$client$trait$YarnClientTrait$$super$triggerSavepoint(this.request$2, jid, client));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$2 = request$2;
            }
        });
    }

    public static CancelResponse doCancel(YarnClientTrait $this, CancelRequest cancelRequest, Configuration flinkConf) {
        return (CancelResponse)YarnClientTrait$class.org$apache$streampark$flink$client$trait$YarnClientTrait$$executeClientAction($this, (SavepointRequestTrait)cancelRequest, flinkConf, (Function2)new Serializable($this, cancelRequest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClientTrait $outer;
            private final CancelRequest cancelRequest$1;

            public final CancelResponse apply(JobID jid, ClusterClient<?> client) {
                return new CancelResponse(this.$outer.org$apache$streampark$flink$client$trait$YarnClientTrait$$super$cancelJob(this.cancelRequest$1, jid, client));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cancelRequest$1 = cancelRequest$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Method org$apache$streampark$flink$client$trait$YarnClientTrait$$deployInternalMethod(YarnClientTrait $this) {
        void var2_2;
        Class[] paramClass = (Class[])((Object[])new Class[]{ClusterSpecification.class, String.class, String.class, JobGraph.class, ScalaRunTime$.MODULE$.anyValClass((Object)BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(Predef$.MODULE$.boolean2Boolean(true))), ClassTag$.MODULE$.Boolean())});
        Method deployInternal = YarnClusterDescriptor.class.getDeclaredMethod("deployInternal", paramClass);
        deployInternal.setAccessible(true);
        return var2_2;
    }

    public static ClusterClientProvider deployInternal(YarnClientTrait $this, YarnClusterDescriptor clusterDescriptor, ClusterSpecification clusterSpecification, String applicationName, String yarnClusterEntrypoint, JobGraph jobGraph, Boolean detached) {
        return (ClusterClientProvider)$this.org$apache$streampark$flink$client$trait$YarnClientTrait$$deployInternalMethod().invoke((Object)clusterDescriptor, clusterSpecification, applicationName, yarnClusterEntrypoint, jobGraph, detached);
    }

    public static Tuple2 getSessionClusterDescriptor(YarnClientTrait $this, Configuration flinkConfig) {
        DefaultClusterClientServiceLoader serviceLoader = new DefaultClusterClientServiceLoader();
        ClusterClientFactory clientFactory = serviceLoader.getClusterClientFactory(flinkConfig);
        ApplicationId yarnClusterId = (ApplicationId)clientFactory.getClusterId(flinkConfig);
        Predef$.MODULE$.require(yarnClusterId != null);
        ClusterDescriptor clusterDescriptor = clientFactory.createClusterDescriptor(flinkConfig);
        return new Tuple2((Object)yarnClusterId, (Object)clusterDescriptor);
    }

    public static Tuple2 getSessionClusterDeployDescriptor(YarnClientTrait $this, Configuration flinkConfig) {
        DefaultClusterClientServiceLoader serviceLoader = new DefaultClusterClientServiceLoader();
        ClusterClientFactory clientFactory = serviceLoader.getClusterClientFactory(flinkConfig);
        ClusterSpecification clusterSpecification = clientFactory.getClusterSpecification(flinkConfig);
        ClusterDescriptor clusterDescriptor = clientFactory.createClusterDescriptor(flinkConfig);
        return new Tuple2((Object)clusterSpecification, (Object)clusterDescriptor);
    }

    public static void $init$(YarnClientTrait $this) {
    }
}

