/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.FlinkVersion;
import org.apache.streampark.common.util.ClassLoaderUtils$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.proxy.ChildFirstClassLoader;
import org.apache.streampark.flink.proxy.ClassLoaderObjectInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class FlinkShimsProxy$
implements Logger {
    public static final FlinkShimsProxy$ MODULE$;
    private final Map<String, ClassLoader> SHIMS_CLASS_LOADER_CACHE;
    private final Map<String, ClassLoader> VERIFY_SQL_CLASS_LOADER_CACHE;
    public final Pattern org$apache$streampark$flink$proxy$FlinkShimsProxy$$INCLUDE_PATTERN;
    private String org$apache$streampark$flink$proxy$FlinkShimsProxy$$FLINK_SHIMS_PREFIX;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile boolean bitmap$0;

    static {
        new FlinkShimsProxy$();
    }

    private String org$apache$streampark$flink$proxy$FlinkShimsProxy$$FLINK_SHIMS_PREFIX$lzycompute() {
        FlinkShimsProxy$ flinkShimsProxy$ = this;
        synchronized (flinkShimsProxy$) {
            if (!this.bitmap$0) {
                this.org$apache$streampark$flink$proxy$FlinkShimsProxy$$FLINK_SHIMS_PREFIX = "streampark-flink-shims_flink";
                this.bitmap$0 = true;
            }
            return this.org$apache$streampark$flink$proxy$FlinkShimsProxy$$FLINK_SHIMS_PREFIX;
        }
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String logName() {
        return Logger.class.logName((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.class.logger((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.class.logInfo((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.class.logInfo((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.class.logDebug((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.class.logDebug((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.class.logTrace((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.class.logTrace((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.class.logWarn((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.class.logWarn((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.class.logError((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.class.logError((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.class.isTraceEnabled((Logger)this);
    }

    public Pattern org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkShimsResourcePattern(String flinkLargeVersion) {
        return Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"flink-(.*)-", "(.*).jar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{flinkLargeVersion})), 34);
    }

    public String org$apache$streampark$flink$proxy$FlinkShimsProxy$$FLINK_SHIMS_PREFIX() {
        return this.bitmap$0 ? this.org$apache$streampark$flink$proxy$FlinkShimsProxy$$FLINK_SHIMS_PREFIX : this.org$apache$streampark$flink$proxy$FlinkShimsProxy$$FLINK_SHIMS_PREFIX$lzycompute();
    }

    public <T> T proxy(FlinkVersion flinkVersion, Function1<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getFlinkShimsClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0)new Serializable(func, shimsClassLoader){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;
            private final ClassLoader shimsClassLoader$1;

            public final T apply() {
                return (T)this.func$1.apply((Object)this.shimsClassLoader$1);
            }
            {
                this.func$1 = func$1;
                this.shimsClassLoader$1 = shimsClassLoader$1;
            }
        });
    }

    public <T> T proxy(FlinkVersion flinkVersion, Function<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getFlinkShimsClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0)new Serializable(func, shimsClassLoader){
            public static final long serialVersionUID = 0L;
            private final Function func$2;
            private final ClassLoader shimsClassLoader$2;

            public final T apply() {
                return (T)this.func$2.apply(this.shimsClassLoader$2);
            }
            {
                this.func$2 = func$2;
                this.shimsClassLoader$2 = shimsClassLoader$2;
            }
        });
    }

    public ClassLoader getVerifySqlLibClassLoader(FlinkVersion flinkVersion) {
        this.logInfo((Function0<String>)new Serializable(flinkVersion){
            public static final long serialVersionUID = 0L;
            private final FlinkVersion flinkVersion$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add verify sql lib,flink version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkVersion$2}));
            }
            {
                this.flinkVersion$2 = flinkVersion$2;
            }
        });
        return (ClassLoader)this.VERIFY_SQL_CLASS_LOADER_CACHE.getOrElseUpdate((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{flinkVersion.fullVersion()})), (Function0)new Serializable(flinkVersion){
            public static final long serialVersionUID = 0L;
            private final FlinkVersion flinkVersion$2;

            public final ChildFirstClassLoader apply() {
                Serializable getFlinkTable = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$1) {
                        return x$1.getName().startsWith("flink-table");
                    }
                };
                List<URL> libTableURL = FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkHomeLib(this.flinkVersion$2.flinkHome(), "lib", (Function1<File, Object>)getFlinkTable);
                List<URL> optTableURL = FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkHomeLib(this.flinkVersion$2.flinkHome(), "opt", (Function1<File, Object>)getFlinkTable);
                ListBuffer shimsUrls = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)libTableURL.$plus$plus(optTableURL, List$.MODULE$.canBuildFrom()));
                FlinkShimsProxy$.MODULE$.addShimsUrls(this.flinkVersion$2, (Function1<File, BoxedUnit>)new Serializable(this, shimsUrls){
                    public static final long serialVersionUID = 0L;
                    private final ListBuffer shimsUrls$1;

                    public final void apply(File file) {
                        if (file.getName().startsWith("streampark-flink-shims")) {
                            this.shimsUrls$1.$plus$eq((Object)file.toURI().toURL());
                        }
                    }
                    {
                        this.shimsUrls$1 = shimsUrls$1;
                    }
                });
                return new ChildFirstClassLoader((URL[])shimsUrls.toArray(ClassTag$.MODULE$.apply(URL.class)), Thread.currentThread().getContextClassLoader(), FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkShimsResourcePattern(this.flinkVersion$2.majorVersion()));
            }
            {
                this.flinkVersion$2 = flinkVersion$2;
            }
        });
    }

    public void addShimsUrls(FlinkVersion flinkVersion, Function1<File, BoxedUnit> addShimUrl) {
        String appHome = System.getProperty(ConfigConst$.MODULE$.KEY_APP_HOME());
        Predef$.MODULE$.require(appHome != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return String.format("%s is not found on System env.", ConfigConst$.MODULE$.KEY_APP_HOME());
            }
        });
        File libPath = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/lib"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appHome})));
        Predef$.MODULE$.require(libPath.exists());
        String majorVersion = flinkVersion.majorVersion();
        String scalaVersion = flinkVersion.scalaVersion();
        Predef$.MODULE$.refArrayOps((Object[])libPath.listFiles()).foreach((Function1)new Serializable(addShimUrl, majorVersion, scalaVersion){
            public static final long serialVersionUID = 0L;
            private final Function1 addShimUrl$1;
            private final String majorVersion$1;
            private final String scalaVersion$1;

            public final void apply(File jar) {
                String jarName = jar.getName();
                if (jarName.endsWith(".jar")) {
                    if (jarName.startsWith(FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$FLINK_SHIMS_PREFIX())) {
                        String prefixVer = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$FLINK_SHIMS_PREFIX(), this.majorVersion$1, this.scalaVersion$1}));
                        if (jarName.startsWith(prefixVer)) {
                            this.addShimUrl$1.apply((Object)jar);
                            FlinkShimsProxy$.MODULE$.logInfo((Function0<String>)new Serializable(this, jarName){
                                public static final long serialVersionUID = 0L;
                                private final String jarName$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include flink shims jar lib: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jarName$1}));
                                }
                                {
                                    this.jarName$1 = jarName$1;
                                }
                            });
                        }
                    } else if (FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$INCLUDE_PATTERN.matcher(jarName).matches()) {
                        this.addShimUrl$1.apply((Object)jar);
                        FlinkShimsProxy$.MODULE$.logInfo((Function0<String>)new Serializable(this, jarName){
                            public static final long serialVersionUID = 0L;
                            private final String jarName$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include jar lib: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jarName$1}));
                            }
                            {
                                this.jarName$1 = jarName$1;
                            }
                        });
                    } else if (jarName.matches(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^streampark-.*_", ".*$"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.scalaVersion$1})))) {
                        this.addShimUrl$1.apply((Object)jar);
                        FlinkShimsProxy$.MODULE$.logInfo((Function0<String>)new Serializable(this, jarName){
                            public static final long serialVersionUID = 0L;
                            private final String jarName$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include streampark lib: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jarName$1}));
                            }
                            {
                                this.jarName$1 = jarName$1;
                            }
                        });
                    }
                }
            }
            {
                this.addShimUrl$1 = addShimUrl$1;
                this.majorVersion$1 = majorVersion$1;
                this.scalaVersion$1 = scalaVersion$1;
            }
        });
    }

    public <T> T proxyVerifySql(FlinkVersion flinkVersion, Function<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getVerifySqlLibClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0)new Serializable(func, shimsClassLoader){
            public static final long serialVersionUID = 0L;
            private final Function func$3;
            private final ClassLoader shimsClassLoader$3;

            public final T apply() {
                return (T)this.func$3.apply(this.shimsClassLoader$3);
            }
            {
                this.func$3 = func$3;
                this.shimsClassLoader$3 = shimsClassLoader$3;
            }
        });
    }

    private ClassLoader getFlinkShimsClassLoader(FlinkVersion flinkVersion) {
        this.logInfo((Function0<String>)new Serializable(flinkVersion){
            public static final long serialVersionUID = 0L;
            private final FlinkVersion flinkVersion$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add flink shims urls classloader,flink version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkVersion$1}));
            }
            {
                this.flinkVersion$1 = flinkVersion$1;
            }
        });
        return (ClassLoader)this.SHIMS_CLASS_LOADER_CACHE.getOrElseUpdate((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{flinkVersion.fullVersion()})), (Function0)new Serializable(flinkVersion){
            public static final long serialVersionUID = 0L;
            private final FlinkVersion flinkVersion$1;

            public final ChildFirstClassLoader apply() {
                List<URL> libURL = FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkHomeLib(this.flinkVersion$1.flinkHome(), "lib", (Function1<File, Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$2) {
                        return !x$2.getName().startsWith("log4j");
                    }
                });
                ListBuffer shimsUrls = (ListBuffer)ListBuffer$.MODULE$.apply(libURL);
                FlinkShimsProxy$.MODULE$.addShimsUrls(this.flinkVersion$1, (Function1<File, BoxedUnit>)new Serializable(this, shimsUrls){
                    public static final long serialVersionUID = 0L;
                    private final ListBuffer shimsUrls$2;

                    public final void apply(File file) {
                        if (file != null) {
                            this.shimsUrls$2.$plus$eq((Object)file.toURI().toURL());
                        }
                    }
                    {
                        this.shimsUrls$2 = shimsUrls$2;
                    }
                });
                return new ChildFirstClassLoader((URL[])shimsUrls.toArray(ClassTag$.MODULE$.apply(URL.class)), Thread.currentThread().getContextClassLoader(), FlinkShimsProxy$.MODULE$.org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkShimsResourcePattern(this.flinkVersion$1.majorVersion()));
            }
            {
                this.flinkVersion$1 = flinkVersion$1;
            }
        });
    }

    public List<URL> org$apache$streampark$flink$proxy$FlinkShimsProxy$$getFlinkHomeLib(String flinkHome, String childDir, Function1<File, Object> filterFun) {
        File file = new File(flinkHome, childDir);
        Predef$.MODULE$.require(file.isDirectory(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLINK_HOME ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
            }
            {
                this.file$1 = file$1;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).filter(filterFun)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URL apply(File x$3) {
                return x$3.toURI().toURL();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)))).toList();
    }

    public <T> T getObject(ClassLoader loader, Object obj) throws Exception {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        Object result = Utils$.MODULE$.using((AutoCloseable)new ObjectOutputStream(arrayOutputStream), (Function1)new Serializable(loader, obj, arrayOutputStream){
            public static final long serialVersionUID = 0L;
            private final ClassLoader loader$1;
            private final Object obj$1;
            private final ByteArrayOutputStream arrayOutputStream$1;

            public final Object apply(ObjectOutputStream objectOutputStream) {
                objectOutputStream.writeObject(this.obj$1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.arrayOutputStream$1.toByteArray());
                return Utils$.MODULE$.using((AutoCloseable)new ClassLoaderObjectInputStream(this.loader$1, byteArrayInputStream), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ClassLoaderObjectInputStream x$4) {
                        return x$4.readObject();
                    }
                }, (Function1)Predef$.MODULE$.$conforms());
            }
            {
                this.loader$1 = loader$1;
                this.obj$1 = obj$1;
                this.arrayOutputStream$1 = arrayOutputStream$1;
            }
        }, (Function1)Predef$.MODULE$.$conforms());
        return (T)result;
    }

    private FlinkShimsProxy$() {
        MODULE$ = this;
        Logger.class.$init$((Logger)this);
        this.SHIMS_CLASS_LOADER_CACHE = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.VERIFY_SQL_CLASS_LOADER_CACHE = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.org$apache$streampark$flink$proxy$FlinkShimsProxy$$INCLUDE_PATTERN = Pattern.compile("(streampark-shaded-jackson-)(.*).jar", 34);
    }
}

