/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.v2;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.plugin.bootstrap.IBootstrapLog;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.BootstrapInterRuntimeAssist;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.OverrideCallable;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstanceMethodsAroundInterceptorV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.agent.core.so11y.bootstrap.BootstrapPluginSo11y;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.Morph;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.This;

public class InstanceMethodInterV2WithOverrideArgsTemplate {
    private static final String INTERCEPTOR_TYPE = "inst";
    private static String PLUGIN_NAME;
    private static String TARGET_INTERCEPTOR;
    private static InstanceMethodsAroundInterceptorV2 INTERCEPTOR;
    private static IBootstrapLog LOGGER;
    private static BootstrapPluginSo11y PLUGIN_SO11Y;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public static Object intercept(@This Object obj, @AllArguments Object[] allArguments, @Morph OverrideCallable zuper, @Origin Method method) throws Throwable {
        EnhancedInstance targetObject = (EnhancedInstance)obj;
        InstanceMethodInterV2WithOverrideArgsTemplate.prepare();
        long interceptorTimeCost = 0L;
        long startTimeOfMethodBeforeInter = System.nanoTime();
        MethodInvocationContext context = new MethodInvocationContext();
        try {
            if (INTERCEPTOR != null) {
                INTERCEPTOR.beforeMethod(targetObject, method, allArguments, method.getParameterTypes(), context);
            }
        }
        catch (Throwable t) {
            if (LOGGER != null) {
                LOGGER.error(t, "class[{}] before method[{}] intercept failure", obj.getClass(), method.getName());
            }
            PLUGIN_SO11Y.error(PLUGIN_NAME, INTERCEPTOR_TYPE);
        }
        interceptorTimeCost += System.nanoTime() - startTimeOfMethodBeforeInter;
        Object ret = null;
        try {
            ret = !context.isContinue() ? context._ret() : zuper.call(allArguments);
        }
        catch (Throwable t) {
            try {
                long startTimeOfMethodHandleExceptionInter = System.nanoTime();
                try {
                    if (INTERCEPTOR != null) {
                        INTERCEPTOR.handleMethodException(targetObject, method, allArguments, method.getParameterTypes(), t, context);
                    }
                }
                catch (Throwable t2) {
                    if (LOGGER != null) {
                        LOGGER.error(t2, "class[{}] handle method[{}] exception failure", obj.getClass(), method.getName());
                    }
                    PLUGIN_SO11Y.error(PLUGIN_NAME, INTERCEPTOR_TYPE);
                }
                interceptorTimeCost += System.nanoTime() - startTimeOfMethodHandleExceptionInter;
                throw t;
            }
            catch (Throwable throwable) {
                long startTimeOfMethodAfterInter2 = System.nanoTime();
                try {
                    if (INTERCEPTOR != null) {
                        ret = INTERCEPTOR.afterMethod(targetObject, method, allArguments, method.getParameterTypes(), ret, context);
                    }
                }
                catch (Throwable t2) {
                    if (LOGGER != null) {
                        LOGGER.error(t2, "class[{}] after method[{}] intercept failure", obj.getClass(), method.getName());
                    }
                    PLUGIN_SO11Y.error(PLUGIN_NAME, INTERCEPTOR_TYPE);
                }
                interceptorTimeCost += System.nanoTime() - startTimeOfMethodAfterInter2;
                throw throwable;
            }
        }
        long startTimeOfMethodAfterInter = System.nanoTime();
        try {
            if (INTERCEPTOR != null) {
                ret = INTERCEPTOR.afterMethod(targetObject, method, allArguments, method.getParameterTypes(), ret, context);
            }
        }
        catch (Throwable t) {
            if (LOGGER != null) {
                LOGGER.error(t, "class[{}] after method[{}] intercept failure", obj.getClass(), method.getName());
            }
            PLUGIN_SO11Y.error(PLUGIN_NAME, INTERCEPTOR_TYPE);
        }
        PLUGIN_SO11Y.duration(interceptorTimeCost += System.nanoTime() - startTimeOfMethodAfterInter);
        return ret;
    }

    private static void prepare() {
        if (INTERCEPTOR == null) {
            ClassLoader loader = BootstrapInterRuntimeAssist.getAgentClassLoader();
            if (loader != null) {
                IBootstrapLog logger = BootstrapInterRuntimeAssist.getLogger(loader, TARGET_INTERCEPTOR);
                if (logger != null) {
                    LOGGER = logger;
                    PLUGIN_SO11Y = BootstrapInterRuntimeAssist.getSO11Y(loader);
                    INTERCEPTOR = (InstanceMethodsAroundInterceptorV2)BootstrapInterRuntimeAssist.createInterceptor(loader, TARGET_INTERCEPTOR, LOGGER);
                }
            } else {
                LOGGER.error("Runtime ClassLoader not found when create {}." + TARGET_INTERCEPTOR);
            }
        }
    }
}

