/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.hikaricp;

import com.zaxxer.hikari.HikariConfigMXBean;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.skywalking.apm.agent.core.meter.Gauge;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLParser;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class PoolingSealInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String METER_NAME = "datasource";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        String tagValue;
        HikariDataSource hikariDataSource = (HikariDataSource)objInst;
        if (hikariDataSource.getJdbcUrl() != null) {
            ConnectionInfo connectionInfo = URLParser.parser((String)hikariDataSource.getJdbcUrl());
            tagValue = connectionInfo.getDatabaseName() + "_" + connectionInfo.getDatabasePeer();
        } else {
            tagValue = hikariDataSource.getPoolName();
        }
        Map<String, Function<HikariPoolMXBean, Supplier<Double>>> poolMetricMap = this.getPoolMetrics();
        Map<String, Function<HikariConfigMXBean, Supplier<Double>>> metricConfigMap = this.getConfigMetrics();
        poolMetricMap.forEach((key, value) -> ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, (Supplier)((Supplier)value.apply(hikariDataSource.getHikariPoolMXBean()))).tag("name", tagValue)).tag("status", key)).build());
        metricConfigMap.forEach((key, value) -> ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, (Supplier)((Supplier)value.apply(hikariDataSource))).tag("name", tagValue)).tag("status", key)).build());
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    private Map<String, Function<HikariPoolMXBean, Supplier<Double>>> getPoolMetrics() {
        HashMap<String, Function<HikariPoolMXBean, Supplier<Double>>> poolMetricMap = new HashMap<String, Function<HikariPoolMXBean, Supplier<Double>>>();
        poolMetricMap.put("activeConnections", hikariPoolMXBean -> () -> hikariPoolMXBean.getActiveConnections());
        poolMetricMap.put("totalConnections", hikariPoolMXBean -> () -> hikariPoolMXBean.getTotalConnections());
        poolMetricMap.put("idleConnections", hikariPoolMXBean -> () -> hikariPoolMXBean.getIdleConnections());
        poolMetricMap.put("threadsAwaitingConnection", hikariPoolMXBean -> () -> hikariPoolMXBean.getThreadsAwaitingConnection());
        return poolMetricMap;
    }

    private Map<String, Function<HikariConfigMXBean, Supplier<Double>>> getConfigMetrics() {
        HashMap<String, Function<HikariConfigMXBean, Supplier<Double>>> metricConfigMap = new HashMap<String, Function<HikariConfigMXBean, Supplier<Double>>>();
        metricConfigMap.put("connectionTimeout", hikariConfigMXBean -> () -> hikariConfigMXBean.getConnectionTimeout());
        metricConfigMap.put("validationTimeout", hikariConfigMXBean -> () -> hikariConfigMXBean.getValidationTimeout());
        metricConfigMap.put("idleTimeout", hikariConfigMXBean -> () -> hikariConfigMXBean.getIdleTimeout());
        metricConfigMap.put("leakDetectionThreshold", hikariConfigMXBean -> () -> hikariConfigMXBean.getLeakDetectionThreshold());
        metricConfigMap.put("minimumIdle", hikariConfigMXBean -> () -> hikariConfigMXBean.getMinimumIdle());
        metricConfigMap.put("maximumPoolSize", hikariConfigMXBean -> () -> hikariConfigMXBean.getMaximumPoolSize());
        return metricConfigMap;
    }
}

