/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractSingleCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.VerticalDatum;

@XmlType(name="VerticalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="VerticalCRS")
public class DefaultVerticalCRS
extends AbstractSingleCRS<VerticalDatum>
implements VerticalCRS {
    private static final long serialVersionUID = 5807645386129942811L;

    public DefaultVerticalCRS(Map<String, ?> properties, VerticalDatum datum, DefaultDatumEnsemble<VerticalDatum> ensemble, VerticalCS cs) {
        super(properties, VerticalDatum.class, datum, ensemble, (CoordinateSystem)cs);
        DefaultVerticalCRS.checkDimension(1, 1, (CoordinateSystem)cs);
    }

    private DefaultVerticalCRS(DefaultVerticalCRS original, AbstractCS cs) {
        super(original, null, cs);
    }

    protected DefaultVerticalCRS(VerticalCRS crs) {
        super((SingleCRS)crs);
    }

    public static DefaultVerticalCRS castOrCopy(VerticalCRS object) {
        return object == null || object instanceof DefaultVerticalCRS ? (DefaultVerticalCRS)object : new DefaultVerticalCRS(object);
    }

    @Override
    public Class<? extends VerticalCRS> getInterface() {
        return VerticalCRS.class;
    }

    @Override
    @XmlElement(name="verticalDatum", required=true)
    public VerticalDatum getDatum() {
        return (VerticalDatum)super.getDatum();
    }

    @Override
    public DefaultDatumEnsemble<VerticalDatum> getDatumEnsemble() {
        return super.getDatumEnsemble();
    }

    @XmlElement(name="verticalCS", required=true)
    public VerticalCS getCoordinateSystem() {
        return (VerticalCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultVerticalCRS forConvention(AxesConvention convention) {
        return (DefaultVerticalCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(AbstractCS cs) {
        return new DefaultVerticalCRS(this, cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return formatter.getConvention().majorVersion() == 1 ? "Vert_CS" : (DefaultVerticalCRS.isBaseCRS(formatter) ? "BaseVertCRS" : formatter.shortOrLong("VertCRS", "VerticalCRS"));
    }

    @Override
    final void formatDatum(Formatter formatter) {
        DefaultVerticalCRS.formatDatum(formatter, this, this.getDatum(), DefaultVerticalDatum::castOrCopy, DatumOrEnsemble::asDatum);
    }

    private DefaultVerticalCRS() {
    }

    private void setDatum(VerticalDatum value) {
        this.setDatum("verticalDatum", value);
    }

    private void setCoordinateSystem(VerticalCS cs) {
        this.setCoordinateSystem("verticalCS", (CoordinateSystem)cs);
    }
}

