/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.util.internal.shared.Strings;

abstract class ValuesAtPointIterator
implements Spliterator<double[]> {
    private static final int X_DIMENSION = 0;
    private static final int Y_DIMENSION = 1;
    private static final long MAXIMUM_SLICE_SIZE_MASK = -32768L;
    static final double DOMAIN_MINIMUM = -9.223372036854778E18;
    static final double DOMAIN_MAXIMUM = 9.223372036854778E18;
    protected final long[] nearestXY;
    protected int indexOfXY;
    protected final int limitOfXY;
    protected final IntFunction<PointOutsideCoverageException> ifOutside;

    protected ValuesAtPointIterator(long[] nearestXY, int limitOfXY, IntFunction<PointOutsideCoverageException> ifOutside) {
        this.nearestXY = nearestXY;
        this.limitOfXY = limitOfXY;
        this.ifOutside = ifOutside;
    }

    static ValuesAtPointIterator create(GridCoverage coverage, double[] gridCoords, int numPoints, IntFunction<PointOutsideCoverageException> ifOutside) {
        return Slices.create(coverage, gridCoords, 0, numPoints, ifOutside).shortcut();
    }

    @Override
    public final long estimateSize() {
        return (this.limitOfXY - this.indexOfXY) / 2;
    }

    @Override
    public final long getExactSizeIfKnown() {
        return this.estimateSize();
    }

    @Override
    public final int characteristics() {
        return this.ifOutside == null ? 16464 : 16720;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"estimateSize", this.estimateSize(), "nullIfOutside", this.ifOutside == null});
    }

    private static final class Slices
    extends Group {
        private final GridCoverage coverage;
        private final GridExtent[] imageExtents;

        private Slices(Slices parent, int stopAt) {
            super(parent, stopAt);
            this.coverage = parent.coverage;
            this.imageExtents = parent.imageExtents;
        }

        private Slices(GridCoverage coverage, long[] nearestXY, int limitOfXY, int[] firstGridCoordOfChildren, int upperChildIndex, GridExtent[] imageExtents, IntFunction<PointOutsideCoverageException> ifOutside) {
            super(nearestXY, limitOfXY, firstGridCoordOfChildren, upperChildIndex, ifOutside);
            this.coverage = coverage;
            this.imageExtents = imageExtents;
            this.current = this.nextChild();
        }

        static Slices create(GridCoverage coverage, double[] gridCoords, int gridCoordsOffset, int numPoints, IntFunction<PointOutsideCoverageException> ifOutside) {
            int dimension = coverage.gridGeometry.getDimension();
            long[] extentLow = new long[dimension];
            long[] extentHigh = new long[dimension];
            long[] nearestXY = new long[numPoints * 2];
            GridExtent[] imageExtents = new GridExtent[1];
            int[] imageFirstCoords = new int[1];
            int imageCount = 0;
            int indexOfXY = 0;
            int limitOfXY = 0;
            while (--numPoints >= 0) {
                long upperY;
                long upperX;
                boolean wasOutside = false;
                for (int i = 0; i < dimension; ++i) {
                    double c = gridCoords[gridCoordsOffset + i];
                    wasOutside |= !(c >= -9.223372036854778E18) || !(c <= 9.223372036854778E18);
                    extentLow[i] = Math.round(c);
                }
                if (wasOutside && ifOutside != null) {
                    throw ifOutside.apply(indexOfXY / 2);
                }
                int n = limitOfXY++;
                long lowerX = upperX = extentLow[0];
                nearestXY[n] = upperX;
                int n2 = limitOfXY++;
                long lowerY = upperY = extentLow[1];
                nearestXY[n2] = upperY;
                gridCoordsOffset += dimension;
                block2: while (numPoints != 0) {
                    long ymax;
                    boolean isValid = true;
                    for (int i = 2; i < dimension; ++i) {
                        double c = gridCoords[gridCoordsOffset + i];
                        isValid &= c >= -9.223372036854778E18 && c <= 9.223372036854778E18;
                        if (Math.round(c) != extentLow[i]) break block2;
                    }
                    double cx = gridCoords[gridCoordsOffset + 0];
                    double cy = gridCoords[gridCoordsOffset + 1];
                    if ((isValid &= cx >= -9.223372036854778E18 && cx <= 9.223372036854778E18 && cy >= -9.223372036854778E18 && cy <= 9.223372036854778E18) == wasOutside) break;
                    long x = Math.round(cx);
                    long y = Math.round(cy);
                    long xmin = Math.min(x, lowerX);
                    long ymin = Math.min(y, lowerY);
                    long xmax = Math.max(x, upperX);
                    if (((xmax - xmin | (ymax = Math.max(y, upperY)) - ymin) & 0xFFFFFFFFFFFF8000L) != 0L) break;
                    lowerX = xmin;
                    lowerY = ymin;
                    upperX = xmax;
                    upperY = ymax;
                    nearestXY[limitOfXY++] = x;
                    nearestXY[limitOfXY++] = y;
                    gridCoordsOffset += dimension;
                    --numPoints;
                }
                if (imageCount >= imageExtents.length) {
                    imageExtents = Arrays.copyOf(imageExtents, imageExtents.length * 2);
                    imageFirstCoords = Arrays.copyOf(imageFirstCoords, imageFirstCoords.length * 2);
                }
                if (wasOutside) {
                    imageFirstCoords[imageCount++] = indexOfXY;
                    indexOfXY = limitOfXY;
                    continue;
                }
                System.arraycopy(extentLow, 0, extentHigh, 0, extentHigh.length);
                extentLow[0] = lowerX;
                extentLow[1] = lowerY;
                extentHigh[0] = upperX;
                extentHigh[1] = upperY;
                imageExtents[imageCount] = new GridExtent(null, extentLow, extentHigh, true);
                imageFirstCoords[imageCount++] = indexOfXY;
                while (indexOfXY < limitOfXY) {
                    int n3 = indexOfXY++;
                    nearestXY[n3] = nearestXY[n3] - lowerX;
                    int n4 = indexOfXY++;
                    nearestXY[n4] = nearestXY[n4] - lowerY;
                }
            }
            return new Slices(coverage, nearestXY, limitOfXY, imageFirstCoords, imageCount, imageExtents, ifOutside);
        }

        @Override
        final ValuesAtPointIterator createChild(int childIndex, int stopAtXY) {
            block3: {
                GridExtent extent = this.imageExtents[childIndex];
                if (extent != null) {
                    try {
                        return Image.create(this, stopAtXY, this.coverage.render(extent)).shortcut();
                    }
                    catch (DisjointExtentException cause) {
                        if (this.ifOutside == null) break block3;
                        PointOutsideCoverageException e = (PointOutsideCoverageException)this.ifOutside.apply(this.indexOfXY / 2);
                        e.initCause(cause);
                        throw e;
                    }
                }
            }
            return new Null(this.indexOfXY, stopAtXY);
        }

        @Override
        final Group createPrefix(int stopAtXY) {
            return new Slices(this, stopAtXY);
        }
    }

    private static final class Null
    extends ValuesAtPointIterator {
        Null(int indexOfXY, int limitOfXY) {
            super(null, limitOfXY, null);
            this.indexOfXY = indexOfXY;
        }

        @Override
        public Spliterator<double[]> trySplit() {
            return null;
        }

        @Override
        public boolean tryAdvance(Consumer<? super double[]> action) {
            if (this.indexOfXY < this.limitOfXY) {
                this.indexOfXY += 2;
                action.accept(null);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super double[]> action) {
            while (this.indexOfXY < this.limitOfXY) {
                this.indexOfXY += 2;
                action.accept(null);
            }
        }
    }

    private static final class Tile
    extends ValuesAtPointIterator {
        private final Raster tile;
        private double[] samples;

        Tile(ValuesAtPointIterator parent, int indexOfXY, int limitOfXY, Raster tile) {
            super(parent.nearestXY, limitOfXY, null);
            this.indexOfXY = indexOfXY;
            this.tile = tile;
        }

        @Override
        public Spliterator<double[]> trySplit() {
            int start = this.indexOfXY;
            int half = (this.limitOfXY - start) / 2 & 0xFFFFFFFE;
            if (half >= 10) {
                return new Tile(this, start, this.indexOfXY += half, this.tile);
            }
            return null;
        }

        @Override
        public boolean tryAdvance(Consumer<? super double[]> action) {
            if (this.indexOfXY < this.limitOfXY) {
                int x = Math.toIntExact(this.nearestXY[this.indexOfXY++]);
                int y = Math.toIntExact(this.nearestXY[this.indexOfXY++]);
                this.samples = this.tile.getPixel(x, y, this.samples);
                action.accept((double[])this.samples);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super double[]> action) {
            while (this.indexOfXY < this.limitOfXY) {
                int x = Math.toIntExact(this.nearestXY[this.indexOfXY++]);
                int y = Math.toIntExact(this.nearestXY[this.indexOfXY++]);
                this.samples = this.tile.getPixel(x, y, this.samples);
                action.accept((double[])this.samples);
            }
        }
    }

    private static final class Image
    extends Group {
        private final RenderedImage image;
        private final int[] tileIndices;
        private final BitSet tileIsAbsent;

        private Image(Image parent, int stopAt) {
            super(parent, stopAt);
            this.image = parent.image;
            this.tileIndices = parent.tileIndices;
            this.tileIsAbsent = parent.tileIsAbsent;
        }

        private Image(RenderedImage image, long[] nearestXY, int limitOfXY, int[] firstGridCoordOfChildren, int upperChildIndex, int[] tileIndices, BitSet tileIsAbsent, IntFunction<PointOutsideCoverageException> ifOutside) {
            super(nearestXY, limitOfXY, firstGridCoordOfChildren, upperChildIndex, ifOutside);
            this.image = image;
            this.tileIndices = tileIndices;
            this.tileIsAbsent = tileIsAbsent;
            this.current = this.nextChild();
        }

        static Image create(ValuesAtPointIterator parent, int limitOfXY, RenderedImage image) {
            long xmin = image.getMinX();
            long ymin = image.getMinY();
            long xmax = (long)image.getWidth() + xmin;
            long ymax = (long)image.getHeight() + ymin;
            long tileWidth = image.getTileWidth();
            long tileHeight = image.getTileHeight();
            long tileGridXOffset = image.getTileGridXOffset();
            long tileGridYOffset = image.getTileGridYOffset();
            int[] tileIndices = new int[2];
            int[] tileFirstCoords = new int[1];
            BitSet tileIsAbsent = new BitSet();
            long[] nearestXY = parent.nearestXY;
            int indexOfXY = parent.indexOfXY;
            int tileCount = 0;
            while (indexOfXY < limitOfXY) {
                block7: {
                    if (tileCount >= tileFirstCoords.length) {
                        tileFirstCoords = Arrays.copyOf(tileFirstCoords, tileFirstCoords.length * 2);
                        tileIndices = Arrays.copyOf(tileIndices, tileIndices.length * 2);
                    }
                    tileFirstCoords[tileCount] = indexOfXY;
                    boolean wasOutside = false;
                    do {
                        long x = nearestXY[indexOfXY++];
                        long y = nearestXY[indexOfXY++];
                        if (x >= xmin && x < xmax && y >= ymin && y < ymax) {
                            if (wasOutside) {
                                indexOfXY -= 2;
                                break;
                            }
                            long tileX = Math.floorDiv(x - tileGridXOffset, tileWidth);
                            long tileY = Math.floorDiv(y - tileGridYOffset, tileHeight);
                            long tileXMin = Math.max(xmin, tileX * tileWidth + tileGridXOffset);
                            long tileYMin = Math.max(ymin, tileY * tileHeight + tileGridYOffset);
                            long tileXMax = Math.min(xmax, (tileX + 1L) * tileWidth + tileGridXOffset);
                            long tileYMax = Math.min(ymax, (tileY + 1L) * tileHeight + tileGridYOffset);
                            while (indexOfXY < limitOfXY) {
                                x = nearestXY[indexOfXY++];
                                y = nearestXY[indexOfXY++];
                                if (x >= tileXMin && x < tileXMax && y >= tileYMin && y < tileYMax) continue;
                                indexOfXY -= 2;
                                break;
                            }
                            int i = tileCount * 2;
                            tileIndices[i] = Math.toIntExact(tileX);
                            tileIndices[i + 1] = Math.toIntExact(tileY);
                            break block7;
                        }
                        if (parent.ifOutside != null) {
                            throw parent.ifOutside.apply(indexOfXY / 2);
                        }
                        wasOutside = true;
                    } while (indexOfXY < limitOfXY);
                    tileIsAbsent.set(tileCount);
                }
                ++tileCount;
            }
            return new Image(image, nearestXY, limitOfXY, tileFirstCoords, tileCount, tileIndices, tileIsAbsent, parent.ifOutside);
        }

        @Override
        final ValuesAtPointIterator createChild(int i, int stopAtXY) {
            if (this.tileIsAbsent.get(i)) {
                return new Null(this.indexOfXY, stopAtXY);
            }
            int tileX = this.tileIndices[i *= 2];
            int tileY = this.tileIndices[i + 1];
            return new Tile(this, this.indexOfXY, stopAtXY, this.image.getTile(tileX, tileY));
        }

        @Override
        final Group createPrefix(int stopAtXY) {
            return new Image(this, stopAtXY);
        }
    }

    private static abstract class Group
    extends ValuesAtPointIterator {
        private final int[] firstGridCoordOfChildren;
        private int nextChildIndex;
        private final int upperChildIndex;
        protected ValuesAtPointIterator current;

        protected Group(Group parent, int upperChildIndex) {
            super(parent.nearestXY, parent.firstGridCoordOfChildren[upperChildIndex], parent.ifOutside);
            this.indexOfXY = parent.indexOfXY;
            this.firstGridCoordOfChildren = parent.firstGridCoordOfChildren;
            this.current = parent.current;
            this.nextChildIndex = parent.nextChildIndex;
            this.upperChildIndex = upperChildIndex;
        }

        protected Group(long[] nearestXY, int limitOfXY, int[] firstGridCoordOfChildren, int upperChildIndex, IntFunction<PointOutsideCoverageException> ifOutside) {
            super(nearestXY, limitOfXY, ifOutside);
            this.firstGridCoordOfChildren = firstGridCoordOfChildren;
            this.upperChildIndex = upperChildIndex;
        }

        protected final ValuesAtPointIterator shortcut() {
            return this.nextChildIndex >= this.upperChildIndex ? this.current : this;
        }

        protected final ValuesAtPointIterator nextChild() {
            int childIndex;
            if ((childIndex = this.nextChildIndex++) < this.upperChildIndex) {
                this.indexOfXY = this.firstGridCoordOfChildren[childIndex];
                int stopAtXY = this.nextChildIndex < this.upperChildIndex ? this.firstGridCoordOfChildren[this.nextChildIndex] : this.limitOfXY;
                return this.createChild(childIndex, stopAtXY);
            }
            return null;
        }

        abstract ValuesAtPointIterator createChild(int var1, int var2);

        abstract Group createPrefix(int var1);

        @Override
        public final Spliterator<double[]> trySplit() {
            if (this.current == null) {
                return null;
            }
            int i = this.nextChildIndex + (this.upperChildIndex - this.nextChildIndex) / 2;
            if ((i = Arrays.binarySearch(this.firstGridCoordOfChildren, this.nextChildIndex, this.upperChildIndex, i)) < 0) {
                i ^= 0xFFFFFFFF;
            }
            if (i > this.nextChildIndex && i < this.upperChildIndex) {
                Group prefix = this.createPrefix(i);
                this.nextChildIndex = prefix.upperChildIndex;
                this.indexOfXY = prefix.limitOfXY;
                this.current = this.nextChild();
                return prefix;
            }
            return this.current.trySplit();
        }

        @Override
        public final boolean tryAdvance(Consumer<? super double[]> action) {
            while (this.current != null) {
                if (this.current.tryAdvance(action)) {
                    return true;
                }
                this.current = this.nextChild();
            }
            return false;
        }

        @Override
        public final void forEachRemaining(Consumer<? super double[]> action) {
            while (this.current != null) {
                this.current.forEachRemaining(action);
                this.current = this.nextChild();
            }
        }
    }
}

