/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.style.se1.SelectedChannel;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.util.resources.Errors;

@XmlType(name="ChannelSelectionType", propOrder={"red", "green", "blue", "gray"})
@XmlRootElement(name="ChannelSelection")
public class ChannelSelection<R>
extends StyleElement<R> {
    @XmlElement(name="RedChannel")
    protected SelectedChannel<R> red;
    @XmlElement(name="GreenChannel")
    protected SelectedChannel<R> green;
    @XmlElement(name="BlueChannel")
    protected SelectedChannel<R> blue;
    @XmlElement(name="GrayChannel")
    protected SelectedChannel<R> gray;

    private ChannelSelection() {
    }

    public ChannelSelection(StyleFactory<R> factory) {
        super(factory);
    }

    public ChannelSelection(ChannelSelection<R> source) {
        super(source);
        this.red = source.red;
        this.green = source.green;
        this.blue = source.blue;
        this.gray = source.gray;
    }

    public SelectedChannel<R>[] getChannels() {
        if (this.red != null || this.green != null || this.blue != null) {
            return new SelectedChannel[]{this.red, this.green, this.blue};
        }
        if (this.gray != null) {
            return new SelectedChannel[]{this.gray};
        }
        return null;
    }

    @SafeVarargs
    public final void setChannels(SelectedChannel<R> ... values) {
        this.red = null;
        this.green = null;
        this.blue = null;
        this.gray = null;
        if (values != null) {
            switch (values.length) {
                case 0: {
                    break;
                }
                case 1: {
                    this.gray = values[0];
                    break;
                }
                case 3: {
                    this.red = values[0];
                    this.green = values[1];
                    this.blue = values[2];
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Errors.format((short)164, (Object)3, (Object)values.length));
                }
            }
        }
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.red, this.green, this.blue, this.gray};
    }

    @Override
    public ChannelSelection<R> clone() {
        ChannelSelection clone = (ChannelSelection)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.red != null) {
            this.red = this.red.clone();
        }
        if (this.green != null) {
            this.green = this.green.clone();
        }
        if (this.blue != null) {
            this.blue = this.blue.clone();
        }
        if (this.gray != null) {
            this.gray = this.gray.clone();
        }
    }
}

