/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.internal.shared.AttributeConvention;
import org.apache.sis.gui.dataset.ExpandableList;
import org.apache.sis.gui.dataset.FeatureList;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.IdentityValueFactory;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.logging.Logging;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@DefaultProperty(value="features")
public class FeatureTable
extends TableView<AbstractFeature> {
    final Locale textLocale;
    private DefaultFeatureType featureType;
    public final ObjectProperty<FeatureSet> featuresProperty = new SimpleObjectProperty((Object)this, "features");
    private boolean isSharingList;

    public FeatureTable() {
        super((ObservableList)new FeatureList());
        this.textLocale = Locale.getDefault(Locale.Category.DISPLAY);
        this.initialize();
    }

    public FeatureTable(final FeatureTable other) {
        super((ObservableList)other.getFeatureList());
        other.isSharingList = true;
        this.isSharingList = true;
        this.textLocale = other.textLocale;
        this.featureType = other.featureType;
        this.setFeatures(other.getFeatures());
        this.initialize();
        if (this.featureType != null) {
            this.createColumns();
        } else if (this.getFeatures() != null) {
            other.getColumns().addListener(new InvalidationListener(){
                final /* synthetic */ FeatureTable this$0;
                {
                    this.this$0 = this$0;
                }

                public void invalidated(Observable list) {
                    list.removeListener((InvalidationListener)this);
                    if (other.getFeatures() == this.this$0.getFeatures()) {
                        this.this$0.featureType = other.featureType;
                        if (this.this$0.featureType != null) {
                            this.this$0.createColumns();
                        }
                    }
                }
            });
        }
    }

    private void initialize() {
        this.featuresProperty.addListener((p, o, n) -> this.startFeaturesLoading((FeatureSet)n));
        this.setColumnResizePolicy(CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.setTableMenuButtonVisible(true);
    }

    final FeatureList getFeatureList() {
        ObservableList items = this.getItems();
        if (items instanceof FeatureList) {
            return (FeatureList)items;
        }
        return (FeatureList)((ExpandableList)items).getSource();
    }

    private ExpandableList getExpandableList() {
        ObservableList items = this.getItems();
        if (items instanceof ExpandableList) {
            return (ExpandableList)items;
        }
        return new ExpandableList((FeatureList)items);
    }

    public final FeatureSet getFeatures() {
        return (FeatureSet)this.featuresProperty.get();
    }

    public final void setFeatures(FeatureSet features) {
        this.featuresProperty.set((Object)features);
    }

    private void startFeaturesLoading(FeatureSet features) {
        FeatureList items;
        if (this.isSharingList) {
            items = new FeatureList();
            this.isSharingList = false;
            this.setItems((ObservableList)items);
        } else {
            items = this.getFeatureList();
            items.interrupt();
        }
        if (!items.startFeaturesLoading(this, features)) {
            this.featureType = null;
            this.getColumns().clear();
            this.setPlaceholder(null);
        }
    }

    final void setFeatureType(DefaultFeatureType type) {
        this.setPlaceholder(null);
        this.getItems().clear();
        boolean update = type != null && !type.equals((Object)this.featureType);
        this.featureType = type;
        if (update) {
            this.createColumns();
        }
    }

    private void createColumns() {
        Collection properties = this.featureType.getProperties(true);
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>(properties.size());
        ArrayList<String> multiValued = new ArrayList<String>(columns.size());
        for (AbstractIdentifiedType pt : properties) {
            GenericName qualifiedName = pt.getName();
            String name = qualifiedName.toString();
            String title = this.string(pt.getDesignation().orElse(null));
            if (title == null && (title = this.string(qualifiedName.toInternationalString())) == null) {
                title = name;
            }
            boolean isMultiValued = false;
            if (pt instanceof DefaultAttributeType) {
                boolean bl = isMultiValued = ((DefaultAttributeType)pt).getMaximumOccurs() > 1;
            }
            if (isMultiValued) {
                multiValued.add(name);
            }
            TableColumn column = new TableColumn(title);
            column.setCellValueFactory((Callback)new ValueGetter(name));
            column.setCellFactory(isMultiValued ? ElementCell::new : ValueCell::new);
            if (AttributeConvention.contains((GenericName)qualifiedName)) {
                column.setVisible(false);
            }
            columns.add(column);
        }
        if (multiValued.isEmpty()) {
            this.setItems((ObservableList)this.getFeatureList());
        } else {
            ExpandableList list = this.getExpandableList();
            list.setMultivaluedColumns(multiValued);
            TableColumn column = new TableColumn("\u25a4");
            column.setCellValueFactory(IdentityValueFactory.instance());
            column.setCellFactory((Callback)list);
            column.setReorderable(false);
            column.setSortable(false);
            column.setResizable(false);
            column.setMinWidth(20.0);
            column.setMaxWidth(20.0);
            columns.add(0, column);
            this.setItems((ObservableList)list);
        }
        this.getColumns().setAll(columns);
    }

    private String string(InternationalString i18n) {
        return i18n != null ? Strings.trimOrNull((String)i18n.toString(this.textLocale)) : null;
    }

    public void interrupt() {
        this.getFeatureList().interrupt();
    }

    final void setException(Throwable exception) {
        this.getItems().clear();
        Region trace = new ExceptionReporter(exception).getView();
        StackPane.setAlignment((Node)trace, (Pos)Pos.TOP_LEFT);
        this.setPlaceholder((Node)trace);
    }

    static void unexpectedException(String method, Throwable exception) {
        Logging.unexpectedException((Logger)LogHandler.LOGGER, FeatureTable.class, (String)method, (Throwable)exception);
    }

    static void recoverableException(String method, Exception exception) {
        Logging.recoverableException((Logger)LogHandler.LOGGER, FeatureTable.class, (String)method, (Throwable)exception);
    }

    private static final class ValueGetter
    implements Callback<TableColumn.CellDataFeatures<AbstractFeature, Object>, ObservableValue<Object>> {
        private final String name;

        ValueGetter(String name) {
            this.name = name;
        }

        public ObservableValue<Object> call(TableColumn.CellDataFeatures<AbstractFeature, Object> cell) {
            Object value = null;
            AbstractFeature feature = (AbstractFeature)cell.getValue();
            if (feature != null) {
                value = feature.getPropertyValue(this.name);
            }
            return new ReadOnlyObjectWrapper(value);
        }
    }

    private static final class ElementCell
    extends ValueCell {
        ElementCell(TableColumn<AbstractFeature, Object> column) {
            super(column);
        }

        @Override
        protected void updateItem(Object value, boolean empty) {
            if (value instanceof List) {
                List c = (List)value;
                value = c.isEmpty() ? null : c.get(0);
            } else if (value instanceof Iterable) {
                Iterator c = ((Iterable)value).iterator();
                value = c.hasNext() ? c.next() : null;
            }
            super.updateItem(value, empty);
        }
    }

    private static class ValueCell
    extends TableCell<AbstractFeature, Object> {
        ValueCell(TableColumn<AbstractFeature, Object> column) {
        }

        protected void updateItem(Object value, boolean empty) {
            if (value == this.getItem()) {
                return;
            }
            super.updateItem(value, empty);
            String text = null;
            if (value != null) {
                text = value.toString();
            }
            this.setText(text);
        }
    }
}

