/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import org.apache.sis.coverage.grid.DerivedGridCoverage;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;

final class TranslatedGridCoverage
extends DerivedGridCoverage {
    private final long[] translation;

    private TranslatedGridCoverage(GridCoverage source, GridGeometry domain, long[] translation) {
        super(source, domain);
        this.translation = translation;
    }

    static GridCoverage create(GridCoverage source, GridGeometry domain, long[] translation, boolean allowSourceReplacement) {
        if (allowSourceReplacement) {
            while (source instanceof TranslatedGridCoverage) {
                TranslatedGridCoverage tc = (TranslatedGridCoverage)source;
                long[] shifted = (long[])tc.translation.clone();
                long tm = 0L;
                int i = Math.min(shifted.length, translation.length);
                while (--i >= 0) {
                    shifted[i] = Math.addExact(shifted[i], translation[i]);
                    tm |= translation[i];
                }
                if (tm == 0L) {
                    return tc;
                }
                translation = shifted;
                source = tc.source;
            }
        }
        GridGeometry gridGeometry = source.getGridGeometry();
        if (domain == null) {
            domain = gridGeometry.shiftGrid(translation);
        } else if (!domain.getExtent().isSameSize(gridGeometry.extent)) {
            return null;
        }
        if (domain.equals(gridGeometry)) {
            return source;
        }
        return new TranslatedGridCoverage(source, domain, translation);
    }

    @Override
    protected final GridCoverage createConvertedValues(boolean converted) {
        GridCoverage cs = this.source.forConvertedValues(converted);
        return cs == this.source ? this : new TranslatedGridCoverage(cs, this.gridGeometry, this.translation);
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) {
        if (sliceExtent == null) {
            sliceExtent = this.gridGeometry.extent;
        }
        if (sliceExtent != null) {
            sliceExtent = sliceExtent.translate(this.translation);
        }
        return this.source.render(sliceExtent);
    }
}

