/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class NetworkUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private static boolean isLinuxPlatform = false;
    private static boolean isWindowsPlatform = false;

    public static boolean isWindowsPlatform() {
        return isWindowsPlatform;
    }

    public static Selector openSelector() throws IOException {
        Selector result = null;
        if (NetworkUtil.isLinuxPlatform()) {
            try {
                Class<?> providerClazz = Class.forName("sun.nio.ch.EPollSelectorProvider");
                try {
                    Method method = providerClazz.getMethod("provider", new Class[0]);
                    SelectorProvider selectorProvider = (SelectorProvider)method.invoke(null, new Object[0]);
                    if (selectorProvider != null) {
                        result = selectorProvider.openSelector();
                    }
                }
                catch (Exception e) {
                    log.warn("Open ePoll Selector for linux platform exception", (Throwable)e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = Selector.open();
        }
        return result;
    }

    public static boolean isLinuxPlatform() {
        return isLinuxPlatform;
    }

    public static List<InetAddress> getLocalInetAddressList() throws SocketException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        ArrayList<InetAddress> inetAddressList = new ArrayList<InetAddress>();
        while (enumeration.hasMoreElements()) {
            NetworkInterface nif = enumeration.nextElement();
            if (NetworkUtil.isBridge(nif) || nif.isVirtual() || nif.isPointToPoint() || !nif.isUp()) continue;
            InetAddressValidator validator = InetAddressValidator.getInstance();
            Enumeration<InetAddress> en = nif.getInetAddresses();
            while (en.hasMoreElements()) {
                byte[] ipByte;
                InetAddress address = en.nextElement();
                if (address instanceof Inet4Address) {
                    ipByte = address.getAddress();
                    if (ipByte.length != 4 || !validator.isValidInet4Address(UtilAll.ipToIPv4Str(ipByte))) continue;
                    inetAddressList.add(address);
                    continue;
                }
                if (!(address instanceof Inet6Address) || (ipByte = address.getAddress()).length != 16 || !validator.isValidInet6Address(UtilAll.ipToIPv6Str(ipByte))) continue;
                inetAddressList.add(address);
            }
        }
        return inetAddressList;
    }

    public static InetAddress getLocalInetAddress() {
        try {
            ArrayList<InetAddress> ipv4Result = new ArrayList<InetAddress>();
            ArrayList<InetAddress> ipv6Result = new ArrayList<InetAddress>();
            List<InetAddress> localInetAddressList = NetworkUtil.getLocalInetAddressList();
            for (InetAddress inetAddress : localInetAddressList) {
                if (inetAddress.isLoopbackAddress()) continue;
                if (inetAddress instanceof Inet6Address) {
                    ipv6Result.add(inetAddress);
                    continue;
                }
                ipv4Result.add(inetAddress);
            }
            if (!ipv4Result.isEmpty()) {
                for (InetAddress ip : ipv4Result) {
                    if (UtilAll.isInternalIP(ip.getAddress())) continue;
                    return ip;
                }
                return (InetAddress)ipv4Result.get(ipv4Result.size() - 1);
            }
            if (!ipv6Result.isEmpty()) {
                for (InetAddress ip : ipv6Result) {
                    if (UtilAll.isInternalV6IP(ip)) continue;
                    return ip;
                }
                return (InetAddress)ipv6Result.get(0);
            }
            return InetAddress.getLocalHost();
        }
        catch (Exception e) {
            log.error("Failed to obtain local address", (Throwable)e);
            return null;
        }
    }

    public static String getLocalAddress() {
        InetAddress localHost = NetworkUtil.getLocalInetAddress();
        return NetworkUtil.normalizeHostAddress(localHost);
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    public static String denormalizeHostAddress(String bracketedAddress) {
        if (bracketedAddress == null) {
            return null;
        }
        if (bracketedAddress.startsWith("[") && bracketedAddress.endsWith("]")) {
            return bracketedAddress.substring(1, bracketedAddress.length() - 1);
        }
        return bracketedAddress;
    }

    public static SocketAddress string2SocketAddress(String addr) {
        int split = addr.lastIndexOf(":");
        String host = addr.substring(0, split);
        String port = addr.substring(split + 1);
        return new InetSocketAddress(host, Integer.parseInt(port));
    }

    public static String socketAddress2String(SocketAddress addr) {
        StringBuilder sb = new StringBuilder();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)addr;
        sb.append(inetSocketAddress.getAddress().getHostAddress());
        sb.append(":");
        sb.append(inetSocketAddress.getPort());
        return sb.toString();
    }

    public static String convert2IpString(String addr) {
        return NetworkUtil.socketAddress2String(NetworkUtil.string2SocketAddress(addr));
    }

    private static boolean isBridge(NetworkInterface networkInterface) {
        try {
            if (NetworkUtil.isLinuxPlatform()) {
                String interfaceName = networkInterface.getName();
                File file = new File("/sys/class/net/" + interfaceName + "/bridge");
                return file.exists();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static boolean validCommonInet6Address(String ipOrCidr) {
        InetAddressValidator validator;
        String ipWithoutBracketed = NetworkUtil.denormalizeHostAddress(ipOrCidr);
        return ipWithoutBracketed != null && ipWithoutBracketed.length() != 0 && (validator = InetAddressValidator.getInstance()).isValidInet6Address(ipWithoutBracketed.split("%")[0]);
    }

    static {
        if (OS_NAME != null && OS_NAME.toLowerCase().contains("linux")) {
            isLinuxPlatform = true;
        }
        if (OS_NAME != null && OS_NAME.toLowerCase().contains("windows")) {
            isWindowsPlatform = true;
        }
    }
}

