/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.ConsoleUtil;
import org.apache.hadoop.crypto.key.RangerHSM;
import org.apache.hadoop.crypto.key.RangerKMSDB;
import org.apache.hadoop.crypto.key.RangerKeyStoreProvider;
import org.apache.hadoop.crypto.key.RangerMasterKey;
import org.apache.ranger.kms.dao.DaoManager;

public class DB2HSMMKUtil {
    private static final String ENCRYPTION_KEY = "ranger.db.encrypt.key.password";
    private static final String PARTITION_PASSWORD = "ranger.ks.hsm.partition.password";
    private static final String PARTITION_NAME = "ranger.ks.hsm.partition.name";
    private static final String HSM_TYPE = "ranger.ks.hsm.type";

    public static void showUsage() {
        System.err.println("USAGE: java " + DB2HSMMKUtil.class.getName() + " <HSMType> <partitionName>");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Invalid number of parameters found.");
            DB2HSMMKUtil.showUsage();
            System.exit(1);
        } else {
            boolean result;
            String partitionName;
            String hsmType = args[0];
            if (hsmType == null || hsmType.trim().isEmpty()) {
                System.err.println("HSM Type does not exists.");
                DB2HSMMKUtil.showUsage();
                System.exit(1);
            }
            if ((partitionName = args[1]) == null || partitionName.trim().isEmpty()) {
                System.err.println("Partition name does not exists.");
                DB2HSMMKUtil.showUsage();
                System.exit(1);
            }
            if (result = new DB2HSMMKUtil().doExportMKToHSM(hsmType, partitionName)) {
                System.out.println("Master Key from Ranger KMS DB has been successfully imported into HSM.");
            } else {
                System.out.println("Import of Master Key from DB has been unsuccessful.");
            }
            System.exit(0);
        }
    }

    private boolean doExportMKToHSM(String hsmType, String partitionName) {
        boolean bl;
        char[] partitionPassword = null;
        try {
            partitionPassword = ConsoleUtil.getPasswordFromConsole("Enter Password for the Partition " + partitionName + " : ");
            Configuration conf = RangerKeyStoreProvider.getDBKSConf();
            conf.set(HSM_TYPE, hsmType);
            conf.set(PARTITION_NAME, partitionName);
            conf.set(PARTITION_PASSWORD, String.valueOf(partitionPassword));
            RangerKMSDB rangerkmsDb = new RangerKMSDB(conf);
            DaoManager daoManager = rangerkmsDb.getDaoManager();
            String password = conf.get(ENCRYPTION_KEY);
            RangerMasterKey rangerMasterKey = new RangerMasterKey(daoManager);
            String mkey = rangerMasterKey.getMasterKey(password);
            byte[] key = Base64.decode(mkey);
            RangerHSM rangerHSM = new RangerHSM(conf);
            bl = rangerHSM.setMasterKey(password, key);
        }
        catch (Throwable t) {
            try {
                throw new RuntimeException("Unable to import Master key from Ranger DB to HSM ", t);
            }
            catch (Throwable throwable) {
                Arrays.fill(partitionPassword, ' ');
                throw throwable;
            }
        }
        Arrays.fill(partitionPassword, ' ');
        return bl;
    }
}

