/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kafka.authorizer;

import java.util.Collection;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerKafkaAuditHandler
extends RangerDefaultAuditHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RangerKafkaAuditHandler.class);
    private AuthzAuditEvent auditEvent = null;

    public void processResult(RangerAccessResult result) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("==> RangerKafkaAuditHandler.processResult()");
        }
        if (!this.isAuditingNeeded(result)) {
            return;
        }
        this.auditEvent = super.getAuthzEvents(result);
        if (LOG.isTraceEnabled()) {
            LOG.trace("<== RangerKafkaAuditHandler.processResult()");
        }
    }

    public void processResults(Collection<RangerAccessResult> results) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("==> RangerKafkaAuditHandler.processResults(" + results + ")");
        }
        if (results != null) {
            for (RangerAccessResult res : results) {
                this.processResult(res);
                this.flushAudit();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("<== RangerKafkaAuditHandler.processResults(" + results + ")");
        }
    }

    private boolean isAuditingNeeded(RangerAccessResult result) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("==> RangerKafkaAuditHandler.isAuditingNeeded()");
        }
        boolean ret = true;
        boolean isAllowed = result.getIsAllowed();
        RangerAccessRequest request = result.getAccessRequest();
        RangerAccessResourceImpl resource = (RangerAccessResourceImpl)request.getResource();
        String resourceName = (String)resource.getValue("cluster");
        if (resourceName != null && request.getAccessType().equalsIgnoreCase("create") && !isAllowed) {
            ret = false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("RangerKafkaAuditHandler: isAuditingNeeded()");
            LOG.trace("request:" + request);
            LOG.trace("resource:" + resource);
            LOG.trace("resourceName:" + resourceName);
            LOG.trace("request.getAccessType():" + request.getAccessType());
            LOG.trace("isAllowed:" + isAllowed);
            LOG.trace("ret=" + ret);
            LOG.trace("<== RangerKafkaAuditHandler.isAuditingNeeded() = " + ret + " for result=" + result);
        }
        return ret;
    }

    public void flushAudit() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("==> RangerKafkaAuditHandler.flushAudit(AuditEvent: " + this.auditEvent + ")");
        }
        if (this.auditEvent != null) {
            super.logAuthzAudit(this.auditEvent);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("<== RangerKafkaAuditHandler.flushAudit()");
        }
    }
}

