/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.sink.tagadmin;

import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.tagsync.model.TagSink;
import org.apache.ranger.tagsync.process.TagSyncConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagAdminRESTSink
implements TagSink,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TagAdminRESTSink.class);
    private static final String REST_PREFIX = "/service";
    private static final String MODULE_PREFIX = "/tags";
    private static final String REST_URL_IMPORT_SERVICETAGS_RESOURCE = "/service/tags/importservicetags/";
    private long rangerAdminConnectionCheckInterval;
    private Cookie sessionId = null;
    private boolean isValidRangerCookie = false;
    List<NewCookie> cookieList = new ArrayList<NewCookie>();
    private boolean isRangerCookieEnabled;
    private String rangerAdminCookieName;
    private RangerRESTClient tagRESTClient = null;
    private boolean isKerberized;
    private BlockingQueue<UploadWorkItem> uploadWorkItems;
    private Thread myThread = null;

    @Override
    public boolean initialize(Properties properties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TagAdminRESTSink.initialize()");
        }
        boolean ret = false;
        String restUrl = TagSyncConfig.getTagAdminRESTUrl(properties);
        String sslConfigFile = TagSyncConfig.getTagAdminRESTSslConfigFile(properties);
        String userName = TagSyncConfig.getTagAdminUserName(properties);
        String password = TagSyncConfig.getTagAdminPassword(properties);
        this.rangerAdminConnectionCheckInterval = TagSyncConfig.getTagAdminConnectionCheckInterval(properties);
        this.isKerberized = TagSyncConfig.getTagsyncKerberosIdentity(properties) != null;
        this.isRangerCookieEnabled = TagSyncConfig.isTagSyncRangerCookieEnabled(properties);
        this.rangerAdminCookieName = TagSyncConfig.getRangerAdminCookieName(properties);
        this.sessionId = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("restUrl=" + restUrl);
            LOG.debug("sslConfigFile=" + sslConfigFile);
            LOG.debug("userName=" + userName);
            LOG.debug("rangerAdminConnectionCheckInterval=" + this.rangerAdminConnectionCheckInterval);
            LOG.debug("isKerberized=" + this.isKerberized);
        }
        if (StringUtils.isNotBlank((String)restUrl)) {
            this.tagRESTClient = new RangerRESTClient(restUrl, sslConfigFile, (Configuration)TagSyncConfig.getInstance());
            if (!this.isKerberized) {
                this.tagRESTClient.setBasicAuthInfo(userName, password);
            }
            this.tagRESTClient.getClient();
            this.uploadWorkItems = new LinkedBlockingQueue<UploadWorkItem>();
            ret = true;
        } else {
            LOG.error("No value specified for property 'ranger.tagsync.tagadmin.rest.url'!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TagAdminRESTSink.initialize(), result=" + ret);
        }
        return ret;
    }

    @Override
    public ServiceTags upload(ServiceTags toUpload) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> upload() ");
        }
        UploadWorkItem uploadWorkItem = new UploadWorkItem(toUpload);
        this.uploadWorkItems.put(uploadWorkItem);
        ServiceTags ret = uploadWorkItem.waitForUpload();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== upload()");
        }
        return ret;
    }

    private ServiceTags doUpload(ServiceTags serviceTags) throws Exception {
        if (this.isKerberized) {
            try {
                UserGroupInformation userGroupInformation = UserGroupInformation.getLoginUser();
                if (userGroupInformation != null) {
                    try {
                        userGroupInformation.checkTGTAndReloginFromKeytab();
                    }
                    catch (IOException ioe) {
                        LOG.error("Error renewing TGT and relogin", (Throwable)ioe);
                        userGroupInformation = null;
                    }
                }
                if (userGroupInformation != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Using Principal = " + userGroupInformation.getUserName());
                    }
                    return (ServiceTags)userGroupInformation.doAs(() -> {
                        try {
                            return this.uploadServiceTags(serviceTags);
                        }
                        catch (Exception e) {
                            LOG.error("Upload of service-tags failed with message ", (Throwable)e);
                            return null;
                        }
                    });
                }
                LOG.error("Failed to get UserGroupInformation.getLoginUser()");
                return null;
            }
            catch (Exception e) {
                LOG.error("Upload of service-tags failed with message ", (Throwable)e);
                return null;
            }
        }
        return this.uploadServiceTags(serviceTags);
    }

    private ServiceTags uploadServiceTags(ServiceTags serviceTags) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> doUpload()");
        }
        ClientResponse response = null;
        response = this.isRangerCookieEnabled ? this.uploadServiceTagsUsingCookie(serviceTags) : this.tagRESTClient.put(REST_URL_IMPORT_SERVICETAGS_RESOURCE, null, (Object)serviceTags);
        if (response == null || response.getStatus() != 204) {
            RESTResponse resp = RESTResponse.fromClientResponse((ClientResponse)response);
            LOG.error("Upload of service-tags failed with message " + resp.getMessage());
            if (response == null || resp.getHttpStatusCode() != 400) {
                throw new Exception("Upload of service-tags failed with response: " + response);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== doUpload()");
        }
        return serviceTags;
    }

    private ClientResponse uploadServiceTagsUsingCookie(ServiceTags serviceTags) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> uploadServiceTagCache()");
        }
        ClientResponse clientResponse = null;
        clientResponse = this.sessionId != null && this.isValidRangerCookie ? this.tryWithCookie(serviceTags) : this.tryWithCred(serviceTags);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== uploadServiceTagCache()");
        }
        return clientResponse;
    }

    private ClientResponse tryWithCred(ServiceTags serviceTags) {
        ClientResponse clientResponsebyCred;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> tryWithCred");
        }
        if ((clientResponsebyCred = this.uploadTagsWithCred(serviceTags)) != null && clientResponsebyCred.getStatus() != 204 && clientResponsebyCred.getStatus() != 400 && clientResponsebyCred.getStatus() != 200) {
            this.sessionId = null;
            clientResponsebyCred = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== tryWithCred");
        }
        return clientResponsebyCred;
    }

    private ClientResponse tryWithCookie(ServiceTags serviceTags) {
        ClientResponse clientResponsebySessionId = this.uploadTagsWithCookie(serviceTags);
        if (clientResponsebySessionId != null && clientResponsebySessionId.getStatus() != 204 && clientResponsebySessionId.getStatus() != 400 && clientResponsebySessionId.getStatus() != 200) {
            this.sessionId = null;
            this.isValidRangerCookie = false;
            clientResponsebySessionId = null;
        }
        return clientResponsebySessionId;
    }

    private synchronized ClientResponse uploadTagsWithCred(ServiceTags serviceTags) {
        if (this.sessionId == null) {
            this.tagRESTClient.resetClient();
            ClientResponse response = null;
            try {
                response = this.tagRESTClient.put(REST_URL_IMPORT_SERVICETAGS_RESOURCE, null, (Object)serviceTags);
            }
            catch (Exception e) {
                LOG.error("Failed to get response, Error is : " + e.getMessage());
            }
            if (response != null) {
                if (!response.toString().contains(REST_URL_IMPORT_SERVICETAGS_RESOURCE)) {
                    response.setStatus(404);
                } else if (response.getStatus() == 401) {
                    LOG.warn("Credentials response from ranger is 401.");
                } else if (response.getStatus() == 200 || response.getStatus() == 204) {
                    this.cookieList = response.getCookies();
                    for (NewCookie cookie : this.cookieList) {
                        if (cookie.getName().equalsIgnoreCase(this.rangerAdminCookieName)) {
                            this.sessionId = cookie.toCookie();
                            this.isValidRangerCookie = true;
                            break;
                        }
                        this.isValidRangerCookie = false;
                    }
                }
            }
            return response;
        }
        ClientResponse clientResponsebySessionId = this.uploadTagsWithCookie(serviceTags);
        if (!clientResponsebySessionId.toString().contains(REST_URL_IMPORT_SERVICETAGS_RESOURCE)) {
            clientResponsebySessionId.setStatus(404);
        }
        return clientResponsebySessionId;
    }

    private ClientResponse uploadTagsWithCookie(ServiceTags serviceTags) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> uploadTagsWithCookie");
        }
        ClientResponse response = null;
        try {
            response = this.tagRESTClient.put(REST_URL_IMPORT_SERVICETAGS_RESOURCE, (Object)serviceTags, this.sessionId);
        }
        catch (Exception e) {
            LOG.error("Failed to get response, Error is : " + e.getMessage());
        }
        if (response != null) {
            if (!response.toString().contains(REST_URL_IMPORT_SERVICETAGS_RESOURCE)) {
                response.setStatus(404);
                this.sessionId = null;
                this.isValidRangerCookie = false;
            } else if (response.getStatus() == 401) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            } else if (response.getStatus() == 204 || response.getStatus() == 200) {
                List respCookieList = response.getCookies();
                for (NewCookie respCookie : respCookieList) {
                    if (!respCookie.getName().equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                    if (!this.sessionId.getValue().equalsIgnoreCase(respCookie.toCookie().getValue())) {
                        this.sessionId = respCookie.toCookie();
                    }
                    this.isValidRangerCookie = true;
                    break;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== uploadTagsWithCookie");
        }
        return response;
    }

    @Override
    public boolean start() {
        this.myThread = new Thread(this);
        this.myThread.setDaemon(true);
        this.myThread.start();
        return true;
    }

    @Override
    public void stop() {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.myThread.interrupt();
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TagAdminRESTSink.run()");
        }
        while (true) {
            if (!TagSyncConfig.isTagSyncServiceActive()) {
                continue;
            }
            try {
                boolean doRetry;
                UploadWorkItem uploadWorkItem = this.uploadWorkItems.take();
                ServiceTags toUpload = uploadWorkItem.getServiceTags();
                do {
                    doRetry = false;
                    try {
                        ServiceTags uploaded = this.doUpload(toUpload);
                        if (uploaded == null) {
                            doRetry = true;
                            Thread.sleep(this.rangerAdminConnectionCheckInterval);
                            continue;
                        }
                        uploadWorkItem.uploadCompleted(uploaded);
                    }
                    catch (InterruptedException interrupted) {
                        LOG.error("Caught exception..: ", (Throwable)interrupted);
                        return;
                    }
                    catch (Exception exception) {
                        doRetry = true;
                        Thread.sleep(this.rangerAdminConnectionCheckInterval);
                    }
                } while (doRetry);
            }
            catch (InterruptedException exception) {
                LOG.error("Interrupted..: ", (Throwable)exception);
                return;
            }
        }
    }

    static class UploadWorkItem {
        private ServiceTags serviceTags;
        private BlockingQueue<ServiceTags> uploadedServiceTags;

        ServiceTags getServiceTags() {
            return this.serviceTags;
        }

        ServiceTags waitForUpload() throws InterruptedException {
            return this.uploadedServiceTags.take();
        }

        void uploadCompleted(ServiceTags uploaded) throws InterruptedException {
            this.uploadedServiceTags.put(uploaded);
        }

        UploadWorkItem(ServiceTags serviceTags) {
            this.setServiceTags(serviceTags);
            this.uploadedServiceTags = new ArrayBlockingQueue<ServiceTags>(1);
        }

        void setServiceTags(ServiceTags serviceTags) {
            this.serviceTags = serviceTags;
        }
    }
}

