/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.nonpersistent;

import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.service.AbstractReplicator;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.OpSendMsgStats;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.policies.data.stats.NonPersistentReplicatorStatsImpl;
import org.apache.pulsar.common.stats.Rate;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonPersistentReplicator
extends AbstractReplicator
implements Replicator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NonPersistentReplicator.class);
    private final Rate msgOut = new Rate();
    private final Rate msgDrop = new Rate();
    private final NonPersistentReplicatorStatsImpl stats = new NonPersistentReplicatorStatsImpl();

    public NonPersistentReplicator(NonPersistentTopic topic, String localCluster, String remoteCluster, BrokerService brokerService, PulsarClientImpl replicationClient) throws PulsarServerException {
        super(localCluster, topic, remoteCluster, topic.getName(), topic.getReplicatorPrefix(), brokerService, replicationClient);
        this.producerBuilder.maxPendingMessages(1000);
        this.producerBuilder.blockIfQueueFull(false);
        this.startProducer();
    }

    @Override
    protected String getProducerName() {
        return NonPersistentReplicator.getReplicatorName(this.replicatorPrefix, this.localCluster) + "-->" + this.remoteCluster;
    }

    @Override
    protected void setProducerAndTriggerReadEntries(Producer<byte[]> producer) {
        this.producer = (ProducerImpl)producer;
        if (!STATE_UPDATER.compareAndSet(this, AbstractReplicator.State.Starting, AbstractReplicator.State.Started)) {
            log.info("[{}] Replicator was stopped while creating the producer. Closing it. Replicator state: {}", (Object)this.replicatorId, STATE_UPDATER.get(this));
            this.doCloseProducerAsync(producer, () -> {});
            return;
        }
        log.info("[{}] Created replicator producer", (Object)this.replicatorId);
        this.backOff.reset();
    }

    public void sendMessage(Entry entry) {
        if (STATE_UPDATER.get(this) == AbstractReplicator.State.Started && this.isWritable()) {
            MessageImpl msg;
            int length = entry.getLength();
            ByteBuf headersAndPayload = entry.getDataBuffer();
            try {
                msg = MessageImpl.deserializeSkipBrokerEntryMetaData((ByteBuf)headersAndPayload);
            }
            catch (Throwable t) {
                log.error("[{}] Failed to deserialize message at {} (buffer size: {}): {}", new Object[]{this.replicatorId, entry.getPosition(), length, t.getMessage(), t});
                entry.release();
                return;
            }
            if (msg.isReplicated()) {
                entry.release();
                msg.recycle();
                return;
            }
            if (msg.hasReplicateTo() && !msg.getReplicateTo().contains(this.remoteCluster)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Skipping message at {} / msg-id: {}: replicateTo {}", new Object[]{this.replicatorId, entry.getPosition(), msg.getMessageId(), msg.getReplicateTo()});
                }
                entry.release();
                msg.recycle();
                return;
            }
            this.msgOut.recordEvent((long)headersAndPayload.readableBytes());
            this.stats.incrementMsgOutCounter();
            this.stats.incrementBytesOutCounter((long)headersAndPayload.readableBytes());
            msg.setReplicatedFrom(this.localCluster);
            headersAndPayload.retain();
            this.producer.sendAsync((Message)msg, (SendCallback)ProducerSendCallback.create(this, entry, msg));
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}] dropping message because replicator producer is not started/writable", (Object)this.replicatorId);
            }
            this.msgDrop.recordEvent();
            this.stats.incrementMsgDropCount();
            entry.release();
        }
    }

    @Override
    public void updateRates() {
        this.msgOut.calculateRate();
        this.msgDrop.calculateRate();
        this.stats.msgRateOut = this.msgOut.getRate();
        this.stats.msgThroughputOut = this.msgOut.getValueRate();
        this.stats.msgDropRate = this.msgDrop.getRate();
    }

    public NonPersistentReplicatorStatsImpl computeStats() {
        ProducerImpl producer = this.producer;
        this.stats.connected = this.isConnected();
        this.stats.replicationDelayInSeconds = TimeUnit.MILLISECONDS.toSeconds(this.getReplicationDelayMs());
        if (producer != null) {
            this.stats.outboundConnection = producer.getConnectionId();
            this.stats.outboundConnectedSince = producer.getConnectedSince();
        } else {
            this.stats.outboundConnection = null;
            this.stats.outboundConnectedSince = null;
        }
        return this.stats;
    }

    public NonPersistentReplicatorStatsImpl getStats() {
        return this.stats;
    }

    @Override
    protected Position getReplicatorReadPosition() {
        return null;
    }

    @Override
    public long getNumberOfEntriesInBacklog() {
        return 0L;
    }

    @Override
    protected void disableReplicatorRead() {
    }

    @Override
    protected void beforeTerminate() {
    }

    private static final class ProducerSendCallback
    implements SendCallback {
        private NonPersistentReplicator replicator;
        private Entry entry;
        private MessageImpl msg;
        private final Recycler.Handle<ProducerSendCallback> recyclerHandle;
        private static final Recycler<ProducerSendCallback> RECYCLER = new Recycler<ProducerSendCallback>(){

            protected ProducerSendCallback newObject(Recycler.Handle<ProducerSendCallback> handle) {
                return new ProducerSendCallback(handle);
            }
        };

        public void sendComplete(Throwable exception, OpSendMsgStats opSendMsgStats) {
            if (exception != null) {
                Throwable actEx = FutureUtil.unwrapCompletionException((Throwable)exception);
                if (actEx instanceof PulsarClientException.ProducerQueueIsFullError) {
                    log.warn("[{}] Discard to replicate non-persistent messages to the remote cluster because the producer pending queue is full", (Object)this.replicator.replicatorId);
                } else {
                    log.error("[{}] Error producing on remote broker", (Object)this.replicator.replicatorId, (Object)exception);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("[{}] Message persisted on remote broker", (Object)this.replicator.replicatorId);
            }
            this.entry.release();
            this.recycle();
        }

        private ProducerSendCallback(Recycler.Handle<ProducerSendCallback> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        static ProducerSendCallback create(NonPersistentReplicator replicator, Entry entry, MessageImpl msg) {
            ProducerSendCallback sendCallback = (ProducerSendCallback)RECYCLER.get();
            sendCallback.replicator = replicator;
            sendCallback.entry = entry;
            sendCallback.msg = msg;
            return sendCallback;
        }

        private void recycle() {
            this.replicator = null;
            this.entry = null;
            if (this.msg != null) {
                this.msg.recycle();
                this.msg = null;
            }
            this.recyclerHandle.recycle((Object)this);
        }

        public void addCallback(MessageImpl<?> msg, SendCallback scb) {
        }

        public SendCallback getNextSendCallback() {
            return null;
        }

        public MessageImpl<?> getNextMessage() {
            return null;
        }

        public CompletableFuture<MessageId> getFuture() {
            return CompletableFuture.completedFuture(null);
        }
    }
}

