/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.s3express;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.IdentityProperty;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeParams;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeProvider;

@SdkInternalApi
public final class S3ExpressAuthSchemeProvider
implements S3AuthSchemeProvider {
    public static final IdentityProperty<String> BUCKET = IdentityProperty.create(String.class, (String)"Bucket");
    private final S3AuthSchemeProvider delegate;

    private S3ExpressAuthSchemeProvider(S3AuthSchemeProvider delegate) {
        this.delegate = delegate;
    }

    public static S3ExpressAuthSchemeProvider create(S3AuthSchemeProvider delegate) {
        return new S3ExpressAuthSchemeProvider(delegate);
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(S3AuthSchemeParams authSchemeParams) {
        List<AuthSchemeOption> options = this.delegate.resolveAuthScheme(authSchemeParams);
        ArrayList<AuthSchemeOption> result = new ArrayList<AuthSchemeOption>(options.size());
        for (AuthSchemeOption option : options) {
            result.add((AuthSchemeOption)((AuthSchemeOption.Builder)option.toBuilder()).putIdentityProperty(BUCKET, (Object)authSchemeParams.bucket()).build());
        }
        return result;
    }

    public S3AuthSchemeProvider delegate() {
        return this.delegate;
    }
}

