/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public final class NamedLockKey {
    private final String name;
    private final Collection<String> resources;

    private NamedLockKey(String name, Collection<String> resources) {
        this.name = Objects.requireNonNull(name, "name");
        this.resources = Collections.unmodifiableCollection(Objects.requireNonNull(resources, "resources"));
    }

    public String name() {
        return this.name;
    }

    public Collection<String> resources() {
        return this.resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedLockKey that = (NamedLockKey)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", resources=" + this.resources + '}';
    }

    public static NamedLockKey of(String name, String ... resources) {
        return NamedLockKey.of(name, Arrays.asList(resources));
    }

    public static NamedLockKey of(String name, Collection<String> resources) {
        return new NamedLockKey(name, resources);
    }
}

