/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.api.Node;
import org.apache.maven.api.NodeVisitor;
import org.apache.maven.impl.WrapperNode;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public abstract class AbstractNode
implements Node {
    abstract DependencyNode getDependencyNode();

    public boolean accept(NodeVisitor visitor) {
        block1: {
            Node child;
            if (!visitor.enter((Node)this)) break block1;
            Iterator iterator = this.getChildren().iterator();
            while (iterator.hasNext() && (child = (Node)iterator.next()).accept(visitor)) {
            }
        }
        return visitor.leave((Node)this);
    }

    public Node filter(Predicate<Node> filter) {
        List children = this.getChildren().stream().filter(filter).map(n -> n.filter(filter)).collect(Collectors.toList());
        return new WrapperNode(this, Collections.unmodifiableList(children));
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        DependencyNode node = this.getDependencyNode();
        Artifact artifact = node.getArtifact();
        sb.append(artifact);
        Dependency dependency = node.getDependency();
        if (dependency != null) {
            sb.append(":").append(dependency.getScope());
        }
        return sb.toString();
    }

    public String toString() {
        return this.getDependencyNode().toString();
    }
}

