/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.metadata;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Snapshot
implements Serializable {
    final String timestamp;
    final int buildNumber;
    final boolean localCopy;

    protected Snapshot(Builder builder) {
        String string = builder.timestamp != null ? builder.timestamp : (this.timestamp = builder.base != null ? builder.base.timestamp : null);
        int n = builder.buildNumber != null ? builder.buildNumber : (this.buildNumber = builder.base != null ? builder.base.buildNumber : 0);
        this.localCopy = builder.localCopy != null ? builder.localCopy : (builder.base != null ? builder.base.localCopy : false);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public boolean isLocalCopy() {
        return this.localCopy;
    }

    @Nonnull
    public Builder with() {
        return Snapshot.newBuilder(this);
    }

    @Nonnull
    public Snapshot withTimestamp(String timestamp) {
        return Snapshot.newBuilder(this, true).timestamp(timestamp).build();
    }

    @Nonnull
    public Snapshot withBuildNumber(int buildNumber) {
        return Snapshot.newBuilder(this, true).buildNumber(buildNumber).build();
    }

    @Nonnull
    public Snapshot withLocalCopy(boolean localCopy) {
        return Snapshot.newBuilder(this, true).localCopy(localCopy).build();
    }

    @Nonnull
    public static Snapshot newInstance() {
        return Snapshot.newInstance(true);
    }

    @Nonnull
    public static Snapshot newInstance(boolean withDefaults) {
        return Snapshot.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Snapshot.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Snapshot from) {
        return Snapshot.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Snapshot from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Snapshot base;
        String timestamp;
        Integer buildNumber;
        Boolean localCopy;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.buildNumber = 0;
                this.localCopy = false;
            }
        }

        protected Builder(Snapshot base, boolean forceCopy) {
            if (forceCopy) {
                this.timestamp = base.timestamp;
                this.buildNumber = base.buildNumber;
                this.localCopy = base.localCopy;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Nonnull
        public Builder buildNumber(int buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        @Nonnull
        public Builder localCopy(boolean localCopy) {
            this.localCopy = localCopy;
            return this;
        }

        @Nonnull
        public Snapshot build() {
            if (!(this.base == null || this.timestamp != null && this.timestamp != this.base.timestamp || this.buildNumber != null && this.buildNumber != this.base.buildNumber || this.localCopy != null && this.localCopy != this.base.localCopy)) {
                return this.base;
            }
            return new Snapshot(this);
        }
    }
}

