/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.menubar;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.apache.lucene.luke.app.DirectoryHandler;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.util.IndexUtils;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util.SuppressForbidden;

public final class OpenIndexDialogFactory
implements DialogOpener.DialogFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static OpenIndexDialogFactory instance;
    private final Preferences prefs;
    private final DirectoryHandler directoryHandler;
    private final IndexHandler indexHandler;
    private final JComboBox<String> idxPathCombo = new JComboBox();
    private final JButton browseBtn = new JButton();
    private final JCheckBox readOnlyCB = new JCheckBox();
    private final JComboBox<String> dirImplCombo = new JComboBox();
    private final JCheckBox noReaderCB = new JCheckBox();
    private final JCheckBox useCompoundCB = new JCheckBox();
    private final JRadioButton keepLastCommitRB = new JRadioButton();
    private final JRadioButton keepAllCommitsRB = new JRadioButton();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private JDialog dialog;

    public static synchronized OpenIndexDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new OpenIndexDialogFactory();
        }
        return instance;
    }

    private OpenIndexDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.directoryHandler = DirectoryHandler.getInstance();
        this.indexHandler = IndexHandler.getInstance();
        this.initialize();
    }

    private void initialize() {
        this.idxPathCombo.setPreferredSize(new Dimension(360, 40));
        this.browseBtn.setText(FontUtils.elegantIconHtml("&#x6e;", MessageUtils.getLocalizedMessage("button.browse")));
        this.browseBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        this.browseBtn.setPreferredSize(new Dimension(120, 40));
        this.browseBtn.addActionListener(this.listeners::browseDirectory);
        this.readOnlyCB.setText(MessageUtils.getLocalizedMessage("openindex.checkbox.readonly"));
        this.readOnlyCB.setSelected(this.prefs.isReadOnly());
        this.readOnlyCB.addActionListener(this.listeners::toggleReadOnly);
        this.readOnlyCB.setOpaque(false);
        ExecutorService executorService = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("load-directory-types"));
        executorService.execute(() -> {
            for (String clazzName : IndexUtils.supportedDirectoryImpls()) {
                this.dirImplCombo.addItem(clazzName);
            }
        });
        executorService.shutdown();
        this.dirImplCombo.setPreferredSize(new Dimension(350, 30));
        this.dirImplCombo.setSelectedItem(this.prefs.getDirImpl());
        this.noReaderCB.setText(MessageUtils.getLocalizedMessage("openindex.checkbox.no_reader"));
        this.noReaderCB.setSelected(this.prefs.isNoReader());
        this.noReaderCB.setOpaque(false);
        this.useCompoundCB.setText(MessageUtils.getLocalizedMessage("openindex.checkbox.use_compound"));
        this.useCompoundCB.setSelected(this.prefs.isUseCompound());
        this.useCompoundCB.setOpaque(false);
        this.keepLastCommitRB.setText(MessageUtils.getLocalizedMessage("openindex.radio.keep_only_last_commit"));
        this.keepLastCommitRB.setSelected(!this.prefs.isKeepAllCommits());
        this.keepLastCommitRB.setOpaque(false);
        this.keepAllCommitsRB.setText(MessageUtils.getLocalizedMessage("openindex.radio.keep_all_commits"));
        this.keepAllCommitsRB.setSelected(this.prefs.isKeepAllCommits());
        this.keepAllCommitsRB.setOpaque(false);
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.basicSettings());
        panel.add(new JSeparator(0));
        panel.add(this.expertSettings());
        panel.add(new JSeparator(0));
        panel.add(this.buttons());
        return panel;
    }

    private JPanel basicSettings() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setOpaque(false);
        JPanel idxPath = new JPanel(new FlowLayout(3));
        idxPath.setOpaque(false);
        idxPath.add(new JLabel(MessageUtils.getLocalizedMessage("openindex.label.index_path")));
        this.idxPathCombo.removeAllItems();
        for (String path : this.prefs.getHistory()) {
            this.idxPathCombo.addItem(path);
        }
        idxPath.add(this.idxPathCombo);
        idxPath.add(this.browseBtn);
        panel.add(idxPath);
        JPanel readOnly = new JPanel(new FlowLayout(3));
        readOnly.setOpaque(false);
        readOnly.add(this.readOnlyCB);
        JLabel roIconLB = new JLabel(FontUtils.elegantIconHtml("&#xe06c;"));
        readOnly.add(roIconLB);
        panel.add(readOnly);
        return panel;
    }

    private JPanel expertSettings() {
        JPanel panel = new JPanel(new GridLayout(6, 1));
        panel.setOpaque(false);
        JPanel header = new JPanel(new FlowLayout(3));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("openindex.label.expert")));
        panel.add(header);
        JPanel dirImpl = new JPanel(new FlowLayout(3));
        dirImpl.setOpaque(false);
        dirImpl.add(new JLabel(MessageUtils.getLocalizedMessage("openindex.label.dir_impl")));
        dirImpl.add(this.dirImplCombo);
        panel.add(dirImpl);
        JPanel noReader = new JPanel(new FlowLayout(3));
        noReader.setOpaque(false);
        noReader.add(this.noReaderCB);
        JLabel noReaderIcon = new JLabel(FontUtils.elegantIconHtml("&#xe077;"));
        noReader.add(noReaderIcon);
        panel.add(noReader);
        JPanel iwConfig = new JPanel(new FlowLayout(3));
        iwConfig.setOpaque(false);
        iwConfig.add(new JLabel(MessageUtils.getLocalizedMessage("openindex.label.iw_config")));
        panel.add(iwConfig);
        JPanel compound = new JPanel(new FlowLayout(3));
        compound.setOpaque(false);
        compound.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        compound.add(this.useCompoundCB);
        panel.add(compound);
        JPanel keepCommits = new JPanel(new FlowLayout(3));
        keepCommits.setOpaque(false);
        keepCommits.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        keepCommits.add(this.keepLastCommitRB);
        keepCommits.add(this.keepAllCommitsRB);
        ButtonGroup group = new ButtonGroup();
        group.add(this.keepLastCommitRB);
        group.add(this.keepAllCommitsRB);
        panel.add(keepCommits);
        return panel;
    }

    private JPanel buttons() {
        JPanel panel = new JPanel(new FlowLayout(4));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 10, 20));
        JButton okBtn = new JButton(MessageUtils.getLocalizedMessage("button.ok"));
        okBtn.addActionListener(this.listeners::openIndexOrDirectory);
        panel.add(okBtn);
        JButton cancelBtn = new JButton(MessageUtils.getLocalizedMessage("button.cancel"));
        cancelBtn.addActionListener(e -> this.dialog.dispose());
        panel.add(cancelBtn);
        return panel;
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        @SuppressForbidden(reason="FileChooser#getSelectedFile() returns java.io.File")
        void browseDirectory(ActionEvent e) {
            File currentDir = this.getLastOpenedDirectory();
            JFileChooser fc = currentDir == null ? new JFileChooser() : new JFileChooser(currentDir);
            fc.setFileSelectionMode(1);
            fc.setFileHidingEnabled(false);
            int retVal = fc.showOpenDialog(OpenIndexDialogFactory.this.dialog);
            if (retVal == 0) {
                File dir = fc.getSelectedFile();
                OpenIndexDialogFactory.this.idxPathCombo.insertItemAt(dir.getAbsolutePath(), 0);
                OpenIndexDialogFactory.this.idxPathCombo.setSelectedIndex(0);
            }
        }

        @SuppressForbidden(reason="JFileChooser constructor takes java.io.File")
        private File getLastOpenedDirectory() {
            Path path;
            List<String> history = OpenIndexDialogFactory.this.prefs.getHistory();
            if (!history.isEmpty() && Files.exists(path = Paths.get(history.get(0), new String[0]), new LinkOption[0])) {
                return path.getParent().toAbsolutePath().toFile();
            }
            return null;
        }

        void toggleReadOnly(ActionEvent e) {
            this.setWriterConfigEnabled(!this.isReadOnly());
        }

        private void setWriterConfigEnabled(boolean enable) {
            OpenIndexDialogFactory.this.useCompoundCB.setEnabled(enable);
            OpenIndexDialogFactory.this.keepLastCommitRB.setEnabled(enable);
            OpenIndexDialogFactory.this.keepAllCommitsRB.setEnabled(enable);
        }

        void openIndexOrDirectory(ActionEvent e) {
            try {
                if (OpenIndexDialogFactory.this.directoryHandler.directoryOpened()) {
                    OpenIndexDialogFactory.this.directoryHandler.close();
                }
                if (OpenIndexDialogFactory.this.indexHandler.indexOpened()) {
                    OpenIndexDialogFactory.this.indexHandler.close();
                }
                String selectedPath = (String)OpenIndexDialogFactory.this.idxPathCombo.getSelectedItem();
                String dirImplClazz = (String)OpenIndexDialogFactory.this.dirImplCombo.getSelectedItem();
                if (selectedPath == null || selectedPath.length() == 0) {
                    String message = MessageUtils.getLocalizedMessage("openindex.message.index_path_not_selected");
                    JOptionPane.showMessageDialog(OpenIndexDialogFactory.this.dialog, message, "Empty index path", 0);
                } else if (this.isNoReader()) {
                    OpenIndexDialogFactory.this.directoryHandler.open(selectedPath, dirImplClazz);
                    this.addHistory(selectedPath);
                } else {
                    OpenIndexDialogFactory.this.indexHandler.open(selectedPath, dirImplClazz, this.isReadOnly(), this.useCompound(), this.keepAllCommits());
                    this.addHistory(selectedPath);
                }
                OpenIndexDialogFactory.this.prefs.setIndexOpenerPrefs(this.isReadOnly(), dirImplClazz, this.isNoReader(), this.useCompound(), this.keepAllCommits());
                this.closeDialog();
            }
            catch (LukeException ex) {
                String message = ex.getMessage() + System.lineSeparator() + "See Logs tab for more details.";
                JOptionPane.showMessageDialog(OpenIndexDialogFactory.this.dialog, message, "Invalid index path", 0);
            }
            catch (Throwable cause) {
                JOptionPane.showMessageDialog(OpenIndexDialogFactory.this.dialog, MessageUtils.getLocalizedMessage("message.error.unknown"), "Unknown Error", 0);
                log.log(Level.SEVERE, "Error opening index or directory", cause);
            }
        }

        private boolean isNoReader() {
            return OpenIndexDialogFactory.this.noReaderCB.isSelected();
        }

        private boolean isReadOnly() {
            return OpenIndexDialogFactory.this.readOnlyCB.isSelected();
        }

        private boolean useCompound() {
            return OpenIndexDialogFactory.this.useCompoundCB.isSelected();
        }

        private boolean keepAllCommits() {
            return OpenIndexDialogFactory.this.keepAllCommitsRB.isSelected();
        }

        private void closeDialog() {
            OpenIndexDialogFactory.this.dialog.dispose();
        }

        private void addHistory(String indexPath) throws IOException {
            OpenIndexDialogFactory.this.prefs.addHistory(indexPath);
        }
    }
}

