/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.jndi;

import java.io.IOException;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsResponse;
import org.ldaptive.LdapException;
import org.ldaptive.control.RequestControl;
import org.ldaptive.provider.jndi.JndiConnection;
import org.ldaptive.provider.jndi.JndiProviderConfig;

public class JndiStartTLSConnection
extends JndiConnection {
    private StartTlsResponse startTlsResponse;
    private boolean stopTLSOnClose;

    public JndiStartTLSConnection(LdapContext lc, JndiProviderConfig pc) {
        super(lc, pc);
    }

    public JndiStartTLSConnection(LdapContext lc, JndiProviderConfig pc, StartTlsResponse tlsResponse) {
        super(lc, pc);
        this.startTlsResponse = tlsResponse;
    }

    public boolean getStopTLSOnClose() {
        return this.stopTLSOnClose;
    }

    public void setStopTLSOnClose(boolean b) {
        this.logger.trace("setting stopTLSOnClose: {}", (Object)b);
        this.stopTLSOnClose = b;
    }

    public StartTlsResponse getStartTlsResponse() {
        return this.startTlsResponse;
    }

    public void setStartTlsResponse(StartTlsResponse str) {
        this.startTlsResponse = str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(RequestControl[] controls) throws LdapException {
        try {
            if (this.stopTLSOnClose && this.startTlsResponse != null) {
                this.startTlsResponse.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Error stopping TLS", (Throwable)e);
        }
        finally {
            this.startTlsResponse = null;
            super.close(controls);
        }
    }
}

