/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.i18n.messages.loggers.log4j;

import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.MessageLogger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;

public class Log4jMessageLogger
implements MessageLogger {
    private static String CLASS_NAME = Log4jMessageLogger.class.getName();
    private Logger logger;

    Log4jMessageLogger(Logger logger) {
        this.logger = logger;
    }

    public final boolean isLoggable(MessageLevel level) {
        return this.logger.isEnabled(Log4jMessageLogger.toLevel(level));
    }

    public final void log(StackTraceElement caller, MessageLevel messageLevel, String messageId, String messageText, Throwable thrown) {
        this.logger.logMessage(Log4jMessageLogger.toLevel(messageLevel), null, CLASS_NAME, caller, (Message)new SimpleMessage(messageText), thrown);
    }

    private static Level toLevel(MessageLevel level) {
        switch (level) {
            case FATAL: {
                return Level.FATAL;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case WARN: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        return Level.OFF;
    }
}

