/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.securequery;

import org.apache.commons.codec.binary.Base64;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.securequery.SecureQueryEncryptDescriptor;
import org.apache.knox.gateway.securequery.SecureQueryMessages;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.services.security.impl.ConfigurableEncryptor;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class SecureQueryEncryptProcessor
implements UrlRewriteStepProcessor<SecureQueryEncryptDescriptor> {
    private static SecureQueryMessages log = (SecureQueryMessages)MessagesFactory.get(SecureQueryMessages.class);
    private static final String ENCRYPTED_PARAMETER_NAME = "_";
    private ConfigurableEncryptor encryptor;

    public String getType() {
        return "encrypt-query";
    }

    public void initialize(UrlRewriteEnvironment environment, SecureQueryEncryptDescriptor descriptor) throws Exception {
        this.encryptor = new ConfigurableEncryptor("encryptQueryString");
        this.encryptor.init((GatewayConfig)environment.getAttribute("org.apache.knox.gateway.config"));
    }

    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        String str;
        Template url = context.getCurrentUrl();
        String path = str = url.toString();
        String query = null;
        int index = str.indexOf(63);
        if (index >= 0) {
            path = str.substring(0, index);
            if (index < str.length()) {
                query = str.substring(index + 1);
            }
        }
        if (query != null) {
            query = this.encode(query);
            url = Parser.parseLiteral((String)(path + "?" + ENCRYPTED_PARAMETER_NAME + "=" + query));
            context.setCurrentUrl(url);
        }
        return UrlRewriteStepStatus.SUCCESS;
    }

    public void destroy() {
    }

    private String encode(String string) throws Exception {
        try {
            EncryptionResult result = this.encryptor.encrypt(string);
            return Base64.encodeBase64URLSafeString((byte[])result.toByteAray());
        }
        catch (Exception e) {
            log.unableToEncryptValue(e);
            throw e;
        }
    }
}

