/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.util;

import com.thetransactioncompany.util.PropertyParseException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class PropertyRetriever {
    private final Properties props = new Properties();
    private final boolean enableSysPropOverride;

    public PropertyRetriever(Properties props) {
        this(props, false);
    }

    public PropertyRetriever(Properties props, boolean enableSysPropOverride) {
        this.props.putAll((Map<?, ?>)props);
        this.enableSysPropOverride = enableSysPropOverride;
        if (enableSysPropOverride) {
            this.props.putAll((Map<?, ?>)System.getProperties());
        }
    }

    public boolean systemPropertyOverrideIsEnabled() {
        return this.enableSysPropOverride;
    }

    public boolean getBoolean(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new PropertyParseException("Invalid boolean property", key, value);
    }

    public boolean getOptBoolean(String key, boolean def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return def;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new PropertyParseException("Invalid boolean property", key, value);
    }

    public int getInt(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid int property", key, value);
        }
    }

    public int getOptInt(String key, int def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid int property", key);
        }
    }

    public long getLong(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid long property", key, value);
        }
    }

    public long getOptLong(String key, long def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid long property", key, value);
        }
    }

    public float getFloat(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid float property", key, value);
        }
    }

    public float getOptFloat(String key, float def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return def;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid float property", key, value);
        }
    }

    public double getDouble(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid double property", key, value);
        }
    }

    public double getOptDouble(String key, double def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return def;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyParseException("Invalid double property", key, value);
        }
    }

    public String getString(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        return value;
    }

    public String getOptString(String key, String def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return def;
        }
        return value;
    }

    public String getEnumString(String key, String[] enums) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        for (String en : enums) {
            if (!en.equalsIgnoreCase(value)) continue;
            return value;
        }
        throw new PropertyParseException("Invalid enum string property", key, value);
    }

    public String getOptEnumString(String key, String[] enums, String def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return def;
        }
        for (String en : enums) {
            if (!en.equalsIgnoreCase(value)) continue;
            return value;
        }
        throw new PropertyParseException("Invalid enum string property", key, value);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClass) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            if (!en.toString().equalsIgnoreCase(value)) continue;
            return (T)en;
        }
        throw new PropertyParseException("Invalid enum property", key, value);
    }

    public <T extends Enum<T>> T getOptEnum(String key, Class<T> enumClass, T def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return def;
        }
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            if (!en.toString().equalsIgnoreCase(value)) continue;
            return (T)en;
        }
        throw new PropertyParseException("Invalid enum property", key, value);
    }

    public URI getURI(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new PropertyParseException("Invalid URI property: " + e.getMessage(), key, value);
        }
    }

    public URI getOptURI(String key, URI def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return def;
        }
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new PropertyParseException("Invalid URI property: " + e.getMessage(), key, value);
        }
    }

    public URL getURL(String key) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new PropertyParseException("Missing property", key);
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new PropertyParseException("Invalid URL property: " + e.getMessage(), key, value);
        }
    }

    public URL getOptURL(String key, URL def) throws PropertyParseException {
        String value = this.props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return def;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new PropertyParseException("Invalid URL property: " + e.getMessage(), key, value);
        }
    }
}

