/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiRangerReplicationHdfsToAdlsArgs;
import com.cloudera.api.swagger.model.ApiRangerReplicationHdfsToGcsArgs;
import com.cloudera.api.swagger.model.ApiRangerReplicationHdfsToS3Args;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(description="Arguments for TRANSFORMING Ranger services and policies, executed after EXPORT (see ApiRangerReplicationExportArgs). <p> Note that if replication is from <b>on-prem to cloud</b>, and it contains a <b>Ranger service with type HDFS</b>, then depending on the cloud provider, one of the following must be provided: #getHdfsToAdlsArgs(), #getHdfsToS3Args(), #getHdfsToGcsArgs(). <b>Otherwise, providing this information is not required!</b>")
public class ApiRangerReplicationTransformArgs {
    @SerializedName(value="rangerServiceNamesMapping")
    private Map<String, String> rangerServiceNamesMapping = null;
    @SerializedName(value="rangerUsersMapping")
    private Map<String, String> rangerUsersMapping = null;
    @SerializedName(value="rangerResourcesMapping")
    private Map<String, String> rangerResourcesMapping = null;
    @SerializedName(value="hiveUrlsMapping")
    private Map<String, String> hiveUrlsMapping = null;
    @SerializedName(value="hdfsToAdlsArgs")
    private ApiRangerReplicationHdfsToAdlsArgs hdfsToAdlsArgs = null;
    @SerializedName(value="hdfsToS3Args")
    private ApiRangerReplicationHdfsToS3Args hdfsToS3Args = null;
    @SerializedName(value="hdfsToGcsArgs")
    private ApiRangerReplicationHdfsToGcsArgs hdfsToGcsArgs = null;

    public ApiRangerReplicationTransformArgs rangerServiceNamesMapping(Map<String, String> rangerServiceNamesMapping) {
        this.rangerServiceNamesMapping = rangerServiceNamesMapping;
        return this;
    }

    public ApiRangerReplicationTransformArgs putRangerServiceNamesMappingItem(String key, String rangerServiceNamesMappingItem) {
        if (this.rangerServiceNamesMapping == null) {
            this.rangerServiceNamesMapping = new HashMap<String, String>();
        }
        this.rangerServiceNamesMapping.put(key, rangerServiceNamesMappingItem);
        return this;
    }

    @Schema(description="A mapping between source to destination ranger services. <p> Note that if a mapping is not given for a service then it will stay the same on the destination. <p> Example: {\"cm_hdfs\":\"dr_hdfs\", \"cm_hive\":\"dr_hive\"} <br> Default: empty or null, every service name will stay the same on the destination")
    public Map<String, String> getRangerServiceNamesMapping() {
        return this.rangerServiceNamesMapping;
    }

    public void setRangerServiceNamesMapping(Map<String, String> rangerServiceNamesMapping) {
        this.rangerServiceNamesMapping = rangerServiceNamesMapping;
    }

    public ApiRangerReplicationTransformArgs rangerUsersMapping(Map<String, String> rangerUsersMapping) {
        this.rangerUsersMapping = rangerUsersMapping;
        return this;
    }

    public ApiRangerReplicationTransformArgs putRangerUsersMappingItem(String key, String rangerUsersMappingItem) {
        if (this.rangerUsersMapping == null) {
            this.rangerUsersMapping = new HashMap<String, String>();
        }
        this.rangerUsersMapping.put(key, rangerUsersMappingItem);
        return this;
    }

    @Schema(description="A mapping between source to destination ranger usernames. <p> Note that if a mapping is not given for a username then it will stay the same on the destination. <p> Example: {\"testuser1\":\"testuser1@host.com\", \"testuser2\":\"testuser2@host.com\" }<br> Default: empty or null, every username will stay the same on the destination")
    public Map<String, String> getRangerUsersMapping() {
        return this.rangerUsersMapping;
    }

    public void setRangerUsersMapping(Map<String, String> rangerUsersMapping) {
        this.rangerUsersMapping = rangerUsersMapping;
    }

    public ApiRangerReplicationTransformArgs rangerResourcesMapping(Map<String, String> rangerResourcesMapping) {
        this.rangerResourcesMapping = rangerResourcesMapping;
        return this;
    }

    public ApiRangerReplicationTransformArgs putRangerResourcesMappingItem(String key, String rangerResourcesMappingItem) {
        if (this.rangerResourcesMapping == null) {
            this.rangerResourcesMapping = new HashMap<String, String>();
        }
        this.rangerResourcesMapping.put(key, rangerResourcesMappingItem);
        return this;
    }

    @Schema(description="A mapping between source to destination ranger resources. <p> If a mapping is not given for a resource then it will stay the same on the destination. <p> <b>Example</b>: <br> {\"/srcdir1/srcfile1\": \"/destdir1/destfile1\", \"src_url.com\": \"dest_url.com\", \"source_db\": \"dest_db\", \"source_table\":\"dest_table\"} } <br> Default: empty or null, every resource will remain the same on destination <p> If replication contains <b>HDFS Ranger service type</b> and replication is done from on-prem to cloud, then for transforming HDFS Ranger service policies to Cloud policies <b>NO resource mapping is needed</b>. Instead, provide one of the following: #getHdfsToAdlsArgs(), #getHdfsToS3Args(), #getHdfsToGcsArgs() <p> <b>HIVE prefixed based resource URL replacement is supported</b>, but it should be provided in a <b>different mapping</b>, for more info see #getHiveUrlsMapping().")
    public Map<String, String> getRangerResourcesMapping() {
        return this.rangerResourcesMapping;
    }

    public void setRangerResourcesMapping(Map<String, String> rangerResourcesMapping) {
        this.rangerResourcesMapping = rangerResourcesMapping;
    }

    public ApiRangerReplicationTransformArgs hiveUrlsMapping(Map<String, String> hiveUrlsMapping) {
        this.hiveUrlsMapping = hiveUrlsMapping;
        return this;
    }

    public ApiRangerReplicationTransformArgs putHiveUrlsMappingItem(String key, String hiveUrlsMappingItem) {
        if (this.hiveUrlsMapping == null) {
            this.hiveUrlsMapping = new HashMap<String, String>();
        }
        this.hiveUrlsMapping.put(key, hiveUrlsMappingItem);
        return this;
    }

    @Schema(description="Used for <b>HIVE prefixed based resource URL replacement</b>. <p> <b>For instance</b>, if Hive resource URLs on <b>source</b> are: <ul> <li>hdfs://namenodehost:8020/user/hive/warehouse/table1</li> <li>hdfs://namenodehost:8020/user/hive/warehouse/table2</li> </ul> and <b>destination is Amazon S3</b>, and the resource mapping contains the following entry: <br> \"hdfs://namenodehost:8020/user/hive/warehouse\": \"s3a://bucket\" <br> then after transformation hive urls will be: <ul> <li>s3a://bucket/table1</li> <li>s3a://bucket/table2</li> </ul> Default: empty or null, every HIVE URL will remain the same on destination.")
    public Map<String, String> getHiveUrlsMapping() {
        return this.hiveUrlsMapping;
    }

    public void setHiveUrlsMapping(Map<String, String> hiveUrlsMapping) {
        this.hiveUrlsMapping = hiveUrlsMapping;
    }

    public ApiRangerReplicationTransformArgs hdfsToAdlsArgs(ApiRangerReplicationHdfsToAdlsArgs hdfsToAdlsArgs) {
        this.hdfsToAdlsArgs = hdfsToAdlsArgs;
        return this;
    }

    @Schema(description="")
    public ApiRangerReplicationHdfsToAdlsArgs getHdfsToAdlsArgs() {
        return this.hdfsToAdlsArgs;
    }

    public void setHdfsToAdlsArgs(ApiRangerReplicationHdfsToAdlsArgs hdfsToAdlsArgs) {
        this.hdfsToAdlsArgs = hdfsToAdlsArgs;
    }

    public ApiRangerReplicationTransformArgs hdfsToS3Args(ApiRangerReplicationHdfsToS3Args hdfsToS3Args) {
        this.hdfsToS3Args = hdfsToS3Args;
        return this;
    }

    @Schema(description="")
    public ApiRangerReplicationHdfsToS3Args getHdfsToS3Args() {
        return this.hdfsToS3Args;
    }

    public void setHdfsToS3Args(ApiRangerReplicationHdfsToS3Args hdfsToS3Args) {
        this.hdfsToS3Args = hdfsToS3Args;
    }

    public ApiRangerReplicationTransformArgs hdfsToGcsArgs(ApiRangerReplicationHdfsToGcsArgs hdfsToGcsArgs) {
        this.hdfsToGcsArgs = hdfsToGcsArgs;
        return this;
    }

    @Schema(description="")
    public ApiRangerReplicationHdfsToGcsArgs getHdfsToGcsArgs() {
        return this.hdfsToGcsArgs;
    }

    public void setHdfsToGcsArgs(ApiRangerReplicationHdfsToGcsArgs hdfsToGcsArgs) {
        this.hdfsToGcsArgs = hdfsToGcsArgs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRangerReplicationTransformArgs apiRangerReplicationTransformArgs = (ApiRangerReplicationTransformArgs)o;
        return Objects.equals(this.rangerServiceNamesMapping, apiRangerReplicationTransformArgs.rangerServiceNamesMapping) && Objects.equals(this.rangerUsersMapping, apiRangerReplicationTransformArgs.rangerUsersMapping) && Objects.equals(this.rangerResourcesMapping, apiRangerReplicationTransformArgs.rangerResourcesMapping) && Objects.equals(this.hiveUrlsMapping, apiRangerReplicationTransformArgs.hiveUrlsMapping) && Objects.equals(this.hdfsToAdlsArgs, apiRangerReplicationTransformArgs.hdfsToAdlsArgs) && Objects.equals(this.hdfsToS3Args, apiRangerReplicationTransformArgs.hdfsToS3Args) && Objects.equals(this.hdfsToGcsArgs, apiRangerReplicationTransformArgs.hdfsToGcsArgs);
    }

    public int hashCode() {
        return Objects.hash(this.rangerServiceNamesMapping, this.rangerUsersMapping, this.rangerResourcesMapping, this.hiveUrlsMapping, this.hdfsToAdlsArgs, this.hdfsToS3Args, this.hdfsToGcsArgs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRangerReplicationTransformArgs {\n");
        sb.append("    rangerServiceNamesMapping: ").append(this.toIndentedString(this.rangerServiceNamesMapping)).append("\n");
        sb.append("    rangerUsersMapping: ").append(this.toIndentedString(this.rangerUsersMapping)).append("\n");
        sb.append("    rangerResourcesMapping: ").append(this.toIndentedString(this.rangerResourcesMapping)).append("\n");
        sb.append("    hiveUrlsMapping: ").append(this.toIndentedString(this.hiveUrlsMapping)).append("\n");
        sb.append("    hdfsToAdlsArgs: ").append(this.toIndentedString(this.hdfsToAdlsArgs)).append("\n");
        sb.append("    hdfsToS3Args: ").append(this.toIndentedString(this.hdfsToS3Args)).append("\n");
        sb.append("    hdfsToGcsArgs: ").append(this.toIndentedString(this.hdfsToGcsArgs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

