/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.karaf.cellar.core;

/**
 * Configurations constants.
 */
public class Configurations {

    public static final String DEFAULT_GROUP_NAME = "default";
    public static final String GROUP = "org.apache.karaf.cellar.groups";
    public static final String GROUPS_KEY = "groups";
    public static final String NODE = "org.apache.karaf.cellar.node";
    public static final String PRODUCER = "producer";
    public static final String CONSUMER = "consumer";
    public static final String HANDLER = "handler";
    public static final String LISTENER = "listener";
    public static final String SEPARATOR = ".";
    public static final String DELIMETER = ",";
    public static final String SYNC = "sync";
    public static final String PARENT = "parent";
    public static final String WHITELIST = "whitelist";
    public static final String BLACKLIST = "blacklist";

}
