/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.zip.ZipOutputStream;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.inventory.ZipAttachmentProvider;
import org.apache.felix.inventory.impl.InventoryPrinterDescription;
import org.apache.felix.inventory.impl.InventoryPrinterHandler;
import org.apache.felix.inventory.impl.InventoryPrinterManagerImpl;
import org.apache.felix.inventory.impl.WebConsolePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class InventoryPrinterAdapter
implements InventoryPrinterHandler,
Comparable {
    public static final Comparator RANKING_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((InventoryPrinterAdapter)o1).description.compareTo(((InventoryPrinterAdapter)o2).description);
        }
    };
    private final InventoryPrinter printer;
    private final InventoryPrinterDescription description;
    private ServiceRegistration registration;

    public InventoryPrinterAdapter(InventoryPrinterDescription description, InventoryPrinter printer) {
        this.description = description;
        this.printer = printer;
    }

    public void registerConsole(BundleContext context, final InventoryPrinterManagerImpl manager) {
        Object value;
        if (!(this.registration != null || (value = this.description.getServiceReference().getProperty("felix.inventory.printer.webconsole")) != null && "false".equalsIgnoreCase(value.toString()))) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("felix.webconsole.label", "status-" + this.description.getName());
            ((Dictionary)props).put("felix.webconsole.title", this.description.getTitle());
            ((Dictionary)props).put("felix.webconsole.category", "Status");
            this.registration = context.registerService("javax.servlet.Servlet", (Object)new ServiceFactory(){

                public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                }

                public Object getService(Bundle bundle, ServiceRegistration registration) {
                    return new WebConsolePlugin(manager, InventoryPrinterAdapter.this.description.getName());
                }
            }, props);
        }
    }

    public void unregisterConsole() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    public String getTitle() {
        return this.description.getTitle();
    }

    public String getName() {
        return this.description.getName();
    }

    public Format[] getFormats() {
        return this.description.getFormats();
    }

    public void addAttachments(ZipOutputStream zos, String namePrefix) throws IOException {
        if (this.printer instanceof ZipAttachmentProvider) {
            ((ZipAttachmentProvider)((Object)this.printer)).addAttachments(zos, namePrefix);
        }
    }

    public boolean supports(Format format) {
        for (int i = 0; i < this.description.getFormats().length; ++i) {
            if (this.description.getFormats()[i] != format) continue;
            return true;
        }
        return false;
    }

    public void print(PrintWriter printWriter, Format format, boolean isZip) {
        if (this.supports(format)) {
            this.printer.print(printWriter, format, isZip);
        }
    }

    public InventoryPrinterDescription getDescription() {
        return this.description;
    }

    public int compareTo(Object spa) {
        return this.description.getSortKey().compareTo(((InventoryPrinterAdapter)spa).description.getSortKey());
    }

    public int hashCode() {
        return this.description.getSortKey().hashCode();
    }

    public boolean equals(Object spa) {
        return this.description.getSortKey().equals(((InventoryPrinterAdapter)spa).description.getSortKey());
    }

    public String toString() {
        return this.printer.getClass() + "(" + super.toString() + ")";
    }
}

