/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiNamingHelper;
import org.apache.camel.impl.engine.DefaultManagementNameStrategy;
import org.apache.camel.util.StringHelper;
import org.osgi.framework.BundleContext;

public class OsgiManagementNameStrategy
extends DefaultManagementNameStrategy {
    private static final AtomicInteger CONTEXT_COUNTER = new AtomicInteger(0);
    private final BundleContext bundleContext;

    public OsgiManagementNameStrategy(CamelContext camelContext, BundleContext bundleContext) {
        super(camelContext, "#symbolicName#-#name#", "#symbolicName#-#name#-#counter#");
        this.bundleContext = bundleContext;
    }

    protected String customResolveManagementName(String pattern, String answer) {
        String bundleId = "" + this.bundleContext.getBundle().getBundleId();
        String symbolicName = this.bundleContext.getBundle().getSymbolicName();
        if (symbolicName == null) {
            symbolicName = "";
        }
        String version = this.bundleContext.getBundle().getVersion().toString();
        answer = StringHelper.replaceAll((String)answer, (String)"#bundleId#", (String)bundleId);
        answer = StringHelper.replaceAll((String)answer, (String)"#symbolicName#", (String)symbolicName);
        answer = StringHelper.replaceAll((String)answer, (String)"#version#", (String)version);
        answer = OsgiNamingHelper.findFreeCamelContextName(this.bundleContext, answer, "camel.context.managementname", CONTEXT_COUNTER, true);
        return answer;
    }
}

