/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MapAccessor {
    private final Map<String, Object> map;

    public MapAccessor(Map<String, Object> map) {
        this.map = Objects.requireNonNull(map, "map");
    }

    public String getString(String key) {
        String[] path = new String[]{key};
        return this.getObject(path, String.class);
    }

    public String getString(String[] path) {
        return this.getObject(path, String.class);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String[] path = new String[]{key};
        return this.getBoolean(path, defaultValue);
    }

    public boolean getBoolean(String[] path, boolean defaultValue) {
        Boolean value = this.getObject(path, Boolean.class);
        return value == null ? defaultValue : value;
    }

    public Boolean getBoolean(String key) {
        String[] path = new String[]{key};
        return this.getObject(path, Boolean.class);
    }

    public Boolean getBoolean(String[] path) {
        return this.getObject(path, Boolean.class);
    }

    public Integer getInteger(String key) {
        String[] path = new String[]{key};
        return this.getInteger(path);
    }

    public Integer getInteger(String[] path) {
        return this.getObject(path, Integer.class);
    }

    public boolean exists(String key) {
        String[] path = new String[]{key};
        return this.exists(path);
    }

    public boolean exists(String[] path) {
        Object value = this.getObject(path);
        return value != null;
    }

    public <E> List<E> getList(String key, Class<E> clazz) {
        String[] path = new String[]{key};
        return this.getList(path, clazz);
    }

    public <E> List<E> getList(String[] path, Class<E> clazz) {
        Object value = this.getObject(path);
        if (value == null) {
            return null;
        }
        if (!(value instanceof List)) {
            String message = String.format("was expecting a List<%s> at path %s: %s (of type %s)", clazz, Arrays.asList(path), value, value.getClass().getCanonicalName());
            throw new IllegalArgumentException(message);
        }
        List items = (List)value;
        for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
            Object item = items.get(itemIndex);
            if (clazz.isInstance(item)) continue;
            String message = String.format("was expecting a List<%s> item at path %s and index %d: %s (of type %s)", clazz, Arrays.asList(path), itemIndex, item, item != null ? item.getClass().getCanonicalName() : null);
            throw new IllegalArgumentException(message);
        }
        List typedItems = items;
        return typedItems;
    }

    public Object getObject(String key) {
        String[] path = new String[]{key};
        return this.getObject(path, Object.class);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        String[] path = new String[]{key};
        return this.getObject(path, clazz);
    }

    public Object getObject(String[] path) {
        return this.getObject(path, Object.class);
    }

    public <T> T getObject(String[] path, Class<T> clazz) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(clazz, "clazz");
        if (path.length == 0) {
            throw new IllegalArgumentException("empty path");
        }
        Object parent = this.map;
        for (String key : path) {
            if (!(parent instanceof Map)) {
                return null;
            }
            Map<String, Object> parentMap = parent;
            parent = parentMap.get(key);
        }
        if (parent != null && !clazz.isInstance(parent)) {
            String message = String.format("was expecting %s at path %s: %s (of type %s)", clazz.getSimpleName(), Arrays.asList(path), parent, parent.getClass().getCanonicalName());
            throw new IllegalArgumentException(message);
        }
        Map<String, Object> typedValue = parent;
        return (T)typedValue;
    }

    public boolean equals(Object instance) {
        if (this == instance) {
            return true;
        }
        if (!(instance instanceof MapAccessor)) {
            return false;
        }
        MapAccessor that = (MapAccessor)instance;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return 31 + Objects.hashCode(this.map);
    }

    public String toString() {
        return this.map.toString();
    }
}

