/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signatures;

import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.Signatures;
import aQute.bnd.signatures.SimpleClassTypeSignature;
import aQute.bnd.signatures.ThrowsSignature;
import aQute.bnd.signatures.TypeArgument;
import aQute.lib.stringrover.StringRover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class ClassTypeSignature
implements ReferenceTypeSignature,
ThrowsSignature {
    public static final ClassTypeSignature OBJECT = new ClassTypeSignature("java/lang/Object", "java/lang/", new SimpleClassTypeSignature("Object", TypeArgument.EMPTY), SimpleClassTypeSignature.EMPTY);
    static final ClassTypeSignature[] EMPTY = new ClassTypeSignature[0];
    public final String packageSpecifier;
    public final SimpleClassTypeSignature classType;
    public final SimpleClassTypeSignature[] innerTypes;
    public final String binary;

    public ClassTypeSignature(String binary, String packageSpecifier, SimpleClassTypeSignature classType, SimpleClassTypeSignature[] innerTypes) {
        this.binary = binary;
        this.packageSpecifier = packageSpecifier;
        this.classType = classType;
        this.innerTypes = innerTypes;
    }

    public int hashCode() {
        int result = 31 + this.packageSpecifier.hashCode();
        result = result * 31 + this.classType.hashCode();
        result = result * 31 + Arrays.hashCode(this.innerTypes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassTypeSignature)) {
            return false;
        }
        ClassTypeSignature other = (ClassTypeSignature)obj;
        return Objects.equals(this.packageSpecifier, other.packageSpecifier) && Objects.equals(this.classType, other.classType) && Arrays.equals(this.innerTypes, other.innerTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('L').append(this.packageSpecifier).append(this.classType);
        for (SimpleClassTypeSignature t : this.innerTypes) {
            sb.append('.').append(t);
        }
        return sb.append(';').toString();
    }

    static ClassTypeSignature parseClassTypeSignature(StringRover signature) {
        ClassTypeSignature result;
        StringBuilder binary = new StringBuilder();
        assert (signature.charAt(0) == 'L');
        signature.increment();
        int offset = 0;
        int slash = -1;
        char c = signature.charAt(offset);
        while (c != '.' && c != ';' && c != '<') {
            if (c == '/') {
                slash = offset;
            }
            c = signature.charAt(++offset);
        }
        String packageSpecifier = Signatures.intern(signature.substring(0, slash + 1));
        binary.append(packageSpecifier);
        SimpleClassTypeSignature classType = SimpleClassTypeSignature.parseSimpleClassTypeSignature(signature.increment(slash + 1));
        binary.append(classType.identifier);
        if (signature.charAt(0) == '.') {
            ArrayList<SimpleClassTypeSignature> list = new ArrayList<SimpleClassTypeSignature>();
            do {
                SimpleClassTypeSignature item = SimpleClassTypeSignature.parseSimpleClassTypeSignature(signature.increment());
                list.add(item);
                binary.append('$').append(item.identifier);
            } while (signature.charAt(0) == '.');
            result = new ClassTypeSignature(Signatures.intern(binary.toString()), packageSpecifier, classType, list.toArray(SimpleClassTypeSignature.EMPTY));
        } else {
            result = new ClassTypeSignature(Signatures.intern(binary.toString()), packageSpecifier, classType, SimpleClassTypeSignature.EMPTY);
        }
        assert (signature.charAt(0) == ';');
        signature.increment();
        return result;
    }
}

