/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.jline.terminal.Attributes;
import org.jline.terminal.spi.Pty;
import org.jline.utils.NonBlockingInputStream;

public abstract class AbstractPty
implements Pty {
    private Attributes current;

    @Override
    public void setAttr(Attributes attr) throws IOException {
        this.current = new Attributes(attr);
        this.doSetAttr(attr);
    }

    @Override
    public InputStream getSlaveInput() throws IOException {
        InputStream si = this.doGetSlaveInput();
        if (Boolean.parseBoolean(System.getProperty("org.jline.terminal.pty.nonBlockingReads", "true"))) {
            return new PtyInputStream(si);
        }
        return si;
    }

    protected abstract void doSetAttr(Attributes var1) throws IOException;

    protected abstract InputStream doGetSlaveInput() throws IOException;

    protected void checkInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    class PtyInputStream
    extends NonBlockingInputStream {
        final InputStream in;
        int c = 0;

        PtyInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read(long timeout, boolean isPeek) throws IOException {
            long cur;
            AbstractPty.this.checkInterrupted();
            if (this.c != 0) {
                int r = this.c;
                if (!isPeek) {
                    this.c = 0;
                }
                return r;
            }
            this.setNonBlocking();
            long start = System.currentTimeMillis();
            do {
                int r;
                if ((r = this.in.read()) >= 0) {
                    if (isPeek) {
                        this.c = r;
                    }
                    return r;
                }
                AbstractPty.this.checkInterrupted();
                cur = System.currentTimeMillis();
            } while (timeout <= 0L || cur - start <= timeout);
            return -2;
        }

        @Override
        public int readBuffered(byte[] b) throws IOException {
            return this.in.read(b);
        }

        private void setNonBlocking() {
            if (AbstractPty.this.current == null || AbstractPty.this.current.getControlChar(Attributes.ControlChar.VMIN) != 0 || AbstractPty.this.current.getControlChar(Attributes.ControlChar.VTIME) != 1) {
                try {
                    Attributes attr = AbstractPty.this.getAttr();
                    attr.setControlChar(Attributes.ControlChar.VMIN, 0);
                    attr.setControlChar(Attributes.ControlChar.VTIME, 1);
                    AbstractPty.this.setAttr(attr);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }
    }
}

