/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.region.BundleIdToRegionMapping;
import org.eclipse.equinox.region.Region;
import org.osgi.framework.BundleException;

public final class StandardBundleIdToRegionMapping
implements BundleIdToRegionMapping {
    private final Object monitor = new Object();
    private final Map<Long, Region> bundleToRegion = new HashMap<Long, Region>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associateBundleWithRegion(long bundleId, Region region) throws BundleException {
        Object object = this.monitor;
        synchronized (object) {
            Region r = this.bundleToRegion.get(bundleId);
            if (r != null && r != region) {
                throw new BundleException("Bundle '" + bundleId + "' is already associated with region '" + r + "'", 2);
            }
            this.bundleToRegion.put(bundleId, region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dissociateBundleFromRegion(long bundleId, Region region) {
        Object object = this.monitor;
        synchronized (object) {
            this.bundleToRegion.remove(bundleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBundleAssociatedWithRegion(long bundleId, Region region) {
        Object object = this.monitor;
        synchronized (object) {
            return this.bundleToRegion.get(bundleId) == region;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getBundleIds(Region region) {
        HashSet<Long> bundleIds = new HashSet<Long>();
        Object object = this.monitor;
        synchronized (object) {
            for (Map.Entry<Long, Region> entry : this.bundleToRegion.entrySet()) {
                if (entry.getValue() != region) continue;
                bundleIds.add(entry.getKey());
            }
        }
        return Collections.unmodifiableSet(bundleIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.monitor;
        synchronized (object) {
            this.bundleToRegion.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getRegion(long bundleId) {
        Object object = this.monitor;
        synchronized (object) {
            return this.bundleToRegion.get(bundleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dissociateRegion(Region region) {
        Object object = this.monitor;
        synchronized (object) {
            Iterator<Map.Entry<Long, Region>> iterator = this.bundleToRegion.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, Region> entry = iterator.next();
                if (entry.getValue() != region) continue;
                iterator.remove();
            }
        }
    }
}

