/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.util.jaas.JaasHelper;

@Command(scope="jaas", name="sudo", description="Execute a command as another user")
@Service
public class SudoCommand
implements Action {
    @Option(name="--realm")
    String realm = "karaf";
    @Option(name="--user")
    String user = "karaf";
    @Argument(multiValued=true)
    List<String> command;
    @Reference
    Session session;

    public Object execute() throws Exception {
        Subject subject = new Subject();
        LoginContext loginContext = new LoginContext(this.realm, subject, callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.user);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    String password = this.session.readLine("Password: ", Character.valueOf('*'));
                    ((PasswordCallback)callback).setPassword(password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        });
        loginContext.login();
        StringBuilder sb = new StringBuilder();
        for (String s : this.command) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(s);
        }
        JaasHelper.doAs(subject, () -> this.session.execute((CharSequence)sb));
        loginContext.logout();
        return null;
    }
}

