/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal.config;

import java.io.File;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ops4j.pax.url.mvn.internal.config.MavenConfiguration;
import org.ops4j.pax.url.mvn.internal.config.MavenRepositoryURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.maven.settings.Mirror;
import shaded.org.apache.maven.settings.Profile;
import shaded.org.apache.maven.settings.Repository;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuilder;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import shaded.org.apache.maven.settings.building.SettingsBuildingException;
import shaded.org.apache.maven.settings.building.SettingsBuildingResult;
import shaded.org.ops4j.lang.NullArgumentException;
import shaded.org.ops4j.util.property.PropertyResolver;

public class MavenConfigurationImpl
implements MavenConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenConfigurationImpl.class);
    private static final String REPOSITORIES_APPEND_SIGN = "+";
    private static final String REPOSITORIES_SEPARATOR = ",";
    private static final String REPOSITORIES_SEPARATOR_SPLIT = "\\s*,\\s*";
    private static final String DEFAULT_TIMEOUT = "5000";
    private final String m_pid;
    private final PropertyResolver m_propertyResolver;
    private Settings settings;
    private final Map<String, Object> m_properties = new ConcurrentHashMap<String, Object>();
    private static final Object NULL_VALUE = new Object();

    public MavenConfigurationImpl(PropertyResolver propertyResolver, String pid) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        this.m_pid = pid == null ? "" : pid + ".";
        this.m_propertyResolver = propertyResolver;
        this.settings = this.buildSettings(this.getLocalRepoPath(propertyResolver), this.getSettingsFileUrl(), this.useFallbackRepositories());
    }

    @Override
    public PropertyResolver getPropertyResolver() {
        return this.m_propertyResolver;
    }

    public boolean isValid() {
        return this.m_propertyResolver.get(this.m_pid + "requireConfigAdminConfig") == null;
    }

    @Override
    public boolean isOffline() {
        if (!this.contains(this.m_pid + "offline")) {
            return this.set(this.m_pid + "offline", Boolean.valueOf(this.m_propertyResolver.get(this.m_pid + "offline")));
        }
        return (Boolean)this.get(this.m_pid + "offline");
    }

    @Override
    public Boolean getCertificateCheck() {
        if (!this.contains(this.m_pid + "certificateCheck")) {
            return this.set(this.m_pid + "certificateCheck", Boolean.valueOf(this.m_propertyResolver.get(this.m_pid + "certificateCheck")));
        }
        return (Boolean)this.get(this.m_pid + "certificateCheck");
    }

    @Override
    public URL getSettingsFileUrl() {
        block10: {
            if (!this.contains(this.m_pid + "settings")) {
                String spec = this.m_propertyResolver.get(this.m_pid + "settings");
                if (spec == null) {
                    spec = this.safeGetFile(System.getProperty("user.home") + "/.m2/settings.xml");
                }
                if (spec == null) {
                    spec = this.safeGetFile(System.getProperty("maven.home") + "/conf/settings.xml");
                }
                if (spec == null) {
                    spec = this.safeGetFile(System.getenv("M2_HOME") + "/conf/settings.xml");
                }
                if (spec != null) {
                    try {
                        return this.set(this.m_pid + "settings", new URL(spec));
                    }
                    catch (MalformedURLException e) {
                        File file = new File(spec);
                        if (file.exists()) {
                            try {
                                return this.set(this.m_pid + "settings", file.toURI().toURL());
                            }
                            catch (MalformedURLException malformedURLException) {
                                break block10;
                            }
                        }
                        LOGGER.warn("Settings file [" + spec + "] cannot be used and will be skipped (malformed url or file does not exist)");
                        this.set(this.m_pid + "settings", null);
                    }
                }
            }
        }
        return (URL)this.get(this.m_pid + "settings");
    }

    private String safeGetFile(String path) {
        File file;
        if (path != null && (file = new File(path)).exists() && file.canRead() && file.isFile()) {
            try {
                return file.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public List<MavenRepositoryURL> getDefaultRepositories() throws MalformedURLException {
        if (!this.contains(this.m_pid + "defaultRepositories")) {
            String defaultRepositoriesProp = this.m_propertyResolver.get(this.m_pid + "defaultRepositories");
            ArrayList<MavenRepositoryURL> defaultRepositoriesProperty = new ArrayList<MavenRepositoryURL>();
            if (defaultRepositoriesProp != null && defaultRepositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = defaultRepositoriesProp.split(REPOSITORIES_SEPARATOR_SPLIT)) {
                    defaultRepositoriesProperty.add(new MavenRepositoryURL(repositoryURL.trim()));
                }
            }
            LOGGER.trace("Using default repositories [" + defaultRepositoriesProperty + "]");
            return this.set(this.m_pid + "defaultRepositories", defaultRepositoriesProperty);
        }
        return (List)this.get(this.m_pid + "defaultRepositories");
    }

    @Override
    public List<MavenRepositoryURL> getRepositories() throws MalformedURLException {
        if (!this.contains(this.m_pid + "repositories")) {
            MavenRepositoryURL localRepository;
            String repositoriesProp = this.m_propertyResolver.get(this.m_pid + "repositories");
            if ((repositoriesProp == null || repositoriesProp.startsWith(REPOSITORIES_APPEND_SIGN)) && this.settings != null) {
                String init = repositoriesProp == null ? "" : repositoriesProp.substring(1);
                StringBuilder builder = new StringBuilder(init);
                Map<String, Profile> profiles = this.settings.getProfilesAsMap();
                for (String activeProfile : this.getActiveProfiles(true)) {
                    Profile profile = profiles.get(activeProfile);
                    if (profile == null) continue;
                    for (Repository repo : profile.getRepositories()) {
                        if (builder.length() > 0) {
                            builder.append(REPOSITORIES_SEPARATOR);
                        }
                        builder.append(repo.getUrl());
                        builder.append("@");
                        builder.append("id");
                        builder.append("=");
                        builder.append(repo.getId());
                        if (repo.getReleases() != null) {
                            if (!repo.getReleases().isEnabled()) {
                                builder.append("@");
                                builder.append("noreleases");
                            }
                            this.addPolicy(builder, repo.getReleases().getUpdatePolicy(), "releasesUpdate");
                            this.addPolicy(builder, repo.getReleases().getChecksumPolicy(), "releasesChecksum");
                        }
                        if (repo.getSnapshots() == null) continue;
                        if (repo.getSnapshots().isEnabled()) {
                            builder.append("@");
                            builder.append("snapshots");
                        }
                        this.addPolicy(builder, repo.getSnapshots().getUpdatePolicy(), "snapshotsUpdate");
                        this.addPolicy(builder, repo.getSnapshots().getChecksumPolicy(), "snapshotsChecksum");
                    }
                }
                repositoriesProp = builder.toString();
            }
            ArrayList<MavenRepositoryURL> repositoriesProperty = new ArrayList<MavenRepositoryURL>();
            if (this.m_propertyResolver.get(this.m_pid + "defaultLocalRepoAsRemote") != null && (localRepository = this.getDefaultLocalRepository()) != null) {
                repositoriesProperty.add(localRepository);
            }
            if (repositoriesProp != null && repositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = repositoriesProp.split(REPOSITORIES_SEPARATOR_SPLIT)) {
                    if ("".equals(repositoryURL.trim())) continue;
                    repositoriesProperty.add(new MavenRepositoryURL(repositoryURL.trim()));
                }
            }
            LOGGER.trace("Using remote repositories [" + repositoriesProperty + "]");
            return this.set(this.m_pid + "repositories", repositoriesProperty);
        }
        return (List)this.get(this.m_pid + "repositories");
    }

    private Collection<String> getActiveProfiles(boolean alsoActiveByDefault) {
        LinkedHashSet<String> profileNames = new LinkedHashSet<String>(this.settings.getActiveProfiles());
        if (alsoActiveByDefault) {
            for (Profile profile : this.settings.getProfiles()) {
                if (profile.getActivation() == null || !profile.getActivation().isActiveByDefault()) continue;
                profileNames.add(profile.getId());
            }
        }
        return profileNames;
    }

    private void addPolicy(StringBuilder builder, String policy, String option) {
        if (policy != null && !policy.isEmpty()) {
            builder.append("@");
            builder.append(option);
            builder.append("=");
            builder.append(policy);
        }
    }

    @Override
    public String getGlobalUpdatePolicy() {
        String propertyName = this.m_pid + "globalUpdatePolicy";
        if (this.contains(propertyName)) {
            return (String)this.get(propertyName);
        }
        String propertyValue = this.m_propertyResolver.get(propertyName);
        if (propertyValue != null) {
            this.set(propertyName, propertyValue);
            return propertyValue;
        }
        return null;
    }

    @Override
    public String getGlobalChecksumPolicy() {
        String propertyName = this.m_pid + "globalChecksumPolicy";
        if (this.contains(propertyName)) {
            return (String)this.get(propertyName);
        }
        String propertyValue = this.m_propertyResolver.get(propertyName);
        if (propertyValue != null) {
            this.set(propertyName, propertyValue);
            return propertyValue;
        }
        return null;
    }

    @Override
    public MavenRepositoryURL getLocalRepository() {
        if (!this.contains(this.m_pid + "localRepository")) {
            String spec = this.m_propertyResolver.get(this.m_pid + "localRepository");
            if (spec == null && this.settings != null) {
                spec = this.settings.getLocalRepository();
            }
            if (spec == null && (spec = System.getProperty("maven.repo.local")) != null && !new File(spec).isDirectory()) {
                LOGGER.warn("Can't use maven.repo.local=" + spec + ". Location invalid.");
                spec = null;
            }
            if (spec == null) {
                spec = System.getProperty("user.home") + "/.m2/repository";
            }
            if (!spec.toLowerCase().contains("@snapshots")) {
                spec = spec + "@snapshots";
            }
            spec = spec + "@id=local";
            try {
                return this.set(this.m_pid + "localRepository", new MavenRepositoryURL(spec));
            }
            catch (MalformedURLException e) {
                try {
                    return this.set(this.m_pid + "localRepository", new MavenRepositoryURL(new File(spec).toURI().toASCIIString()));
                }
                catch (MalformedURLException ignore) {
                    LOGGER.warn("Local repository [" + spec + "] cannot be used and will be skipped");
                    return this.set(this.m_pid + "localRepository", null);
                }
            }
        }
        return (MavenRepositoryURL)this.get(this.m_pid + "localRepository");
    }

    public MavenRepositoryURL getDefaultLocalRepository() {
        if (this.settings != null) {
            String spec = this.settings.getLocalRepository();
            if (spec == null) {
                spec = System.getProperty("user.home") + "/.m2/repository";
            }
            if (!spec.toLowerCase().contains("@snapshots")) {
                spec = spec + "@snapshots";
            }
            spec = spec + "@id=defaultlocal";
            try {
                return new MavenRepositoryURL(spec);
            }
            catch (MalformedURLException e) {
                try {
                    return new MavenRepositoryURL(new File(spec).toURI().toASCIIString());
                }
                catch (MalformedURLException ignore) {
                    LOGGER.warn("Local repository [" + spec + "] cannot be used and will be skipped");
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public Integer getTimeout() {
        if (!this.contains(this.m_pid + "timeout")) {
            String timeout = this.m_propertyResolver.get(this.m_pid + "timeout");
            return this.set(this.m_pid + "timeout", Integer.valueOf(timeout == null ? DEFAULT_TIMEOUT : timeout));
        }
        return (Integer)this.get(this.m_pid + "timeout");
    }

    @Override
    public Boolean useFallbackRepositories() {
        if (!this.contains(this.m_pid + "useFallbackRepositories")) {
            String useFallbackRepoProp = this.m_propertyResolver.get(this.m_pid + "useFallbackRepositories");
            return this.set(this.m_pid + "useFallbackRepositories", Boolean.valueOf(useFallbackRepoProp == null ? "true" : useFallbackRepoProp));
        }
        return (Boolean)this.get(this.m_pid + "useFallbackRepositories");
    }

    @Override
    @Deprecated
    public void enableProxy(URL url) {
        String protocol = url.getProtocol();
        Map<String, String> proxyDetails = this.getProxySettings(url.getProtocol()).get(protocol);
        if (proxyDetails != null) {
            LOGGER.trace("Enabling proxy [" + proxyDetails + "]");
            final String user = proxyDetails.get("user");
            final String pass = proxyDetails.get("pass");
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pass.toCharArray());
                }
            });
            System.setProperty(protocol + ".proxyHost", proxyDetails.get("host"));
            System.setProperty(protocol + ".proxyPort", proxyDetails.get("port"));
            System.setProperty(protocol + ".nonProxyHosts", proxyDetails.get("nonProxyHosts"));
            this.set(this.m_pid + "proxySupport", protocol);
        }
    }

    private boolean isProtocolSupportEnabled(String ... protocols) {
        String proxySupport = this.m_propertyResolver.get(this.m_pid + "proxySupport");
        if (proxySupport == null) {
            return true;
        }
        if ("true".equalsIgnoreCase(proxySupport)) {
            return true;
        }
        if ("false".equalsIgnoreCase(proxySupport)) {
            return false;
        }
        if (protocols.length == 0) {
            return true;
        }
        for (String protocol : protocols) {
            if (!proxySupport.contains(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Map<String, String>> getProxySettings(String ... protocols) {
        HashMap<String, Map<String, String>> pr = new HashMap<String, Map<String, String>>();
        if (this.isProtocolSupportEnabled(protocols)) {
            this.parseSystemWideProxySettings(pr);
            this.parseProxiesFromProperty(this.m_propertyResolver.get(this.m_pid + "proxies"), pr);
        }
        return pr;
    }

    private void parseSystemWideProxySettings(Map<String, Map<String, String>> pr) {
        String httpHost = this.m_propertyResolver.get("http.proxyHost");
        String httpPort = this.m_propertyResolver.get("http.proxyPort");
        String httpnonProxyHosts = this.m_propertyResolver.get("http.nonProxyHosts");
        if (httpHost != null) {
            this.parseProxiesFromProperty("http:host=" + httpHost + ",port=" + httpPort + ",nonProxyHosts=" + httpnonProxyHosts, pr);
        }
    }

    private void parseProxiesFromProperty(String proxySettings, Map<String, Map<String, String>> pr) {
        try {
            if (proxySettings != null) {
                String[] protocols;
                for (String protocolSection : protocols = proxySettings.split(";")) {
                    String[] section = protocolSection.split(":");
                    String protocolName = section[0];
                    HashMap<String, String> keyvalue = new HashMap<String, String>();
                    keyvalue.put("protocol", protocolName);
                    keyvalue.put("nonProxyHosts", "");
                    keyvalue.put("host", "localhost");
                    keyvalue.put("port", "80");
                    for (String keyvalueList : section[1].split(REPOSITORIES_SEPARATOR)) {
                        String[] kv = keyvalueList.split("=");
                        String key = kv[0];
                        String value = kv[1];
                        keyvalue.put(key, value);
                    }
                    pr.put(protocolName, keyvalue);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Proxy setting is set to " + proxySettings + ". But it should have this format: <protocol>:<key>=<value>,<key=value>;protocol:<key>=<value>,..");
        }
    }

    private String getLocalRepoPath(PropertyResolver props) {
        return props.get("org.ops4j.pax.url.mvn.localRepository");
    }

    private Settings buildSettings(String localRepoPath, URL settingsPath, boolean useFallbackRepositories) {
        String mirror;
        Settings settings;
        if (settingsPath == null) {
            settings = new Settings();
        } else {
            DefaultSettingsBuilderFactory factory = new DefaultSettingsBuilderFactory();
            DefaultSettingsBuilder builder = factory.newInstance();
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            try {
                if (settingsPath.toURI().isOpaque()) {
                    request.setUserSettingsFile(new File(settingsPath.getPath()));
                } else {
                    request.setUserSettingsFile(new File(settingsPath.toURI()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            try {
                SettingsBuildingResult result = builder.build(request);
                settings = result.getEffectiveSettings();
            }
            catch (SettingsBuildingException exc) {
                throw new AssertionError("cannot build settings", exc);
            }
        }
        if (useFallbackRepositories) {
            Profile fallbackProfile = new Profile();
            Repository central = new Repository();
            central.setId("central");
            central.setUrl("https://repo1.maven.org/maven2");
            fallbackProfile.setId("fallback");
            fallbackProfile.setRepositories(Arrays.asList(central));
            settings.addProfile(fallbackProfile);
            settings.addActiveProfile("fallback");
        }
        if (localRepoPath != null) {
            settings.setLocalRepository(localRepoPath);
        }
        if ((mirror = System.getenv("MAVEN_MIRROR_URL")) == null || mirror.trim().equals("")) {
            mirror = System.getProperty("mavenMirrorUrl", "");
        }
        if (mirror != null && !mirror.trim().equals("")) {
            String[] mirrorData = mirror.split("::");
            String id = "mirror";
            String url = null;
            if (mirrorData.length > 1) {
                id = mirrorData[0];
                url = mirrorData[1];
            } else {
                url = mirrorData[0];
            }
            Mirror m = new Mirror();
            m.setId(id);
            m.setUrl(url);
            m.setLayout("default");
            m.setMirrorOf("*");
            settings.setMirrors(Collections.singletonList(m));
            LOGGER.debug("Setting global Maven mirror to " + url);
        }
        return settings;
    }

    @Override
    public Map<String, Map<String, String>> getMirrors() {
        return Collections.emptyMap();
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public String getSecuritySettings() {
        String key = this.m_pid + "security";
        if (!this.contains(key)) {
            String spec = this.m_propertyResolver.get(key);
            if (spec == null) {
                spec = new File(System.getProperty("user.home"), ".m2/settings-security.xml").getPath();
            }
            return this.set(key, spec);
        }
        return (String)this.get(key);
    }

    @Override
    public <T> T getProperty(String name, T defaultValue, Class<T> clazz) {
        if (!this.contains(this.m_pid + name)) {
            String value = this.m_propertyResolver.get(this.m_pid + name);
            return this.set(this.m_pid + name, value == null ? defaultValue : this.convert(value, clazz));
        }
        return this.get(this.m_pid + name);
    }

    @Override
    public String getPid() {
        return this.m_pid;
    }

    private <T> T convert(String value, Class<T> clazz) {
        if (String.class == clazz) {
            return (T)value;
        }
        if (Integer.class == clazz) {
            return (T)Integer.valueOf(value);
        }
        if (Long.class == clazz) {
            return (T)Long.valueOf(value);
        }
        if (Boolean.class == clazz) {
            return (T)Boolean.valueOf("true".equals(value));
        }
        throw new IllegalArgumentException("Can't convert \"" + value + "\" to " + clazz + ".");
    }

    public boolean contains(String propertyName) {
        return this.m_properties.containsKey(propertyName);
    }

    public <T> T set(String propertyName, T propertyValue) {
        this.m_properties.put(propertyName, propertyValue != null ? propertyValue : NULL_VALUE);
        return propertyValue;
    }

    public <T> T get(String propertyName) {
        Object v = this.m_properties.get(propertyName);
        return (T)(v != NULL_VALUE ? v : null);
    }
}

