/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.BrokerFeatures;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId;
import kafka.server.MetadataCache;
import kafka.server.ZkCachedControllerId;
import kafka.server.metadata.FeatureCacheUpdateException;
import kafka.server.metadata.MetadataSnapshot;
import kafka.server.metadata.ZkFinalizedFeatureCache;
import kafka.server.metadata.ZkMetadataCache$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011=q!\u0002!B\u0011\u0003Ae!\u0002&B\u0011\u0003Y\u0005\"\u0002*\u0002\t\u0003\u0019\u0006\"\u0002+\u0002\t\u0003)\u0006bBA\u0018\u0003\u0011\u0005\u0011\u0011\u0007\u0005\n\u0003C\n\u0011\u0013!C\u0001\u0003G2QAS!\u0001\u0003\u007fB!\"a'\u0007\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\tiJ\u0002B\u0001B\u0003%\u0011q\u0014\u0005\u000b\u0003W3!\u0011!Q\u0001\n\u00055\u0006BCAZ\r\t\u0005\t\u0015!\u0003\u0002h!1!K\u0002C\u0001\u0003kC\u0011\"!1\u0007\u0005\u0004%I!a1\t\u0011\u0005Ug\u0001)A\u0005\u0003\u000bD\u0011\"a6\u0007\u0001\u0004%I!!7\t\u0013\u0005mg\u00011A\u0005\n\u0005u\u0007bBAr\r\u0001\u0006K! \u0005\n\u0003[4!\u0019!C\u0005\u0003_D\u0001\"!@\u0007A\u0003%\u0011\u0011\u001f\u0005\n\u0003\u007f4\u0001\u0019!C\u0005\u0005\u0003A\u0011Ba\u0004\u0007\u0001\u0004%IA!\u0005\t\u0011\tUa\u0001)Q\u0005\u0005\u0007A\u0011B!\u0007\u0007\u0005\u0004%IAa\u0007\t\u0011\t\rb\u0001)A\u0005\u0005;A\u0011B!\n\u0007\u0005\u0004%IAa\n\t\u0011\t=b\u0001)A\u0005\u0005SAqA!\r\u0007\t\u0013\u0011\u0019\u0004C\u0004\u0003`\u0019!IA!\u0019\t\u000f\t\u0015e\u0001\"\u0003\u0003\b\"9!q\u0012\u0004\u0005\n\tE\u0005b\u0002BQ\r\u0011\u0005!1\u0015\u0005\n\u0005\u000f4\u0011\u0013!C\u0001\u0003GB\u0011B!3\u0007#\u0003%\t!a\u0019\t\u000f\t-g\u0001\"\u0001\u0003N\"9!Q\u001b\u0004\u0005\u0002\t]\u0007b\u0002Bn\r\u0011\u0005!Q\u001c\u0005\b\u0005K4A\u0011\tBt\u0011\u001d\u0011IO\u0002C!\u0005WDqA!:\u0007\t\u0013\u00119\u0010C\u0004\u0003|\u001a!IA!@\t\u000f\r\u0015a\u0001\"\u0011\u0004\b!911\u0002\u0004\u0005B\r5\u0001bBB\u000f\r\u0011\u00053q\u0004\u0005\b\u0007K1A\u0011IB\u0014\u0011\u001d\u0019iC\u0002C\u0001\u0007_Aqaa\r\u0007\t\u0003\u0019)\u0004C\u0004\u0004<\u0019!Ia!\u0010\t\u000f\r}c\u0001\"\u0001\u0004b!91\u0011\u000e\u0004\u0005\u0002\r-\u0004bBB9\r\u0011\u000511\u000f\u0005\b\u0007w2A\u0011AB?\u0011\u001d\u00199I\u0002C\u0001\u0007\u0013Cqaa%\u0007\t\u0003\u0019)\nC\u0004\u0004\u0018\u001a!\ta!'\t\u000f\r\u001df\u0001\"\u0001\u0004*\"91\u0011\u0019\u0004\u0005\u0002\r\r\u0007bBBa\r\u0011\u00051q\u0019\u0005\b\u0007\u00174A\u0011BBg\u0011\u001d\tiJ\u0002C!\u0007;Dqaa8\u0007\t\u0003\u001a\t\u000fC\u0004\u0004d\u001a!\ta!:\t\u000f\ruh\u0001\"\u0001\u0004\u0000\"9A\u0011\u0001\u0004\u0005\u0002\u0011\r\u0001b\u0002C\u0007\r\u0011\u0005#\u0011A\u0001\u00105.lU\r^1eCR\f7)Y2iK*\u0011!iQ\u0001\t[\u0016$\u0018\rZ1uC*\u0011A)R\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0019\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002J\u00035\t\u0011IA\b[W6+G/\u00193bi\u0006\u001c\u0015m\u00195f'\t\tA\n\u0005\u0002N!6\taJC\u0001P\u0003\u0015\u00198-\u00197b\u0013\t\tfJ\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u000b1\u0006\u001e:b]N4wN]7L%\u00064GoQ8oiJ|G\u000e\\3s\rVdG.T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u000b\t-n\f\t!a\u0003\u0002\u0010A\u0019q\u000b\u00180\u000e\u0003aS!!\u0017.\u0002\tU$\u0018\u000e\u001c\u0006\u00027\u0006!!.\u0019<b\u0013\ti\u0006L\u0001\u0003MSN$\bCA0y\u001d\t\u0001WO\u0004\u0002be:\u0011!m\u001c\b\u0003G6t!\u0001\u001a6\u000f\u0005\u0015DW\"\u00014\u000b\u0005\u001d<\u0015A\u0002\u001fs_>$h(C\u0001j\u0003\ry'oZ\u0005\u0003W2\fa!\u00199bG\",'\"A5\n\u0005\u0019s'BA6m\u0013\t\u0001\u0018/\u0001\u0004d_6lwN\u001c\u0006\u0003\r:L!a\u001d;\u0002\u000f5,7o]1hK*\u0011\u0001/]\u0005\u0003m^\f\u0011$\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fR1uC*\u00111\u000f^\u0005\u0003sj\u0014\u0001$\u00169eCR,W*\u001a;bI\u0006$\u0018\rV8qS\u000e\u001cF/\u0019;f\u0015\t1x\u000fC\u0003}\u0007\u0001\u0007Q0A\bdkJ\u0014XM\u001c;NKR\fG-\u0019;b!\tIe0\u0003\u0002\u0000\u0003\n\u0001R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e\u0005\b\u0003\u0007\u0019\u0001\u0019AA\u0003\u0003Y\u0011X-];fgR\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007cA'\u0002\b%\u0019\u0011\u0011\u0002(\u0003\u0007%sG\u000f\u0003\u0004\u0002\u000e\r\u0001\rAV\u0001\u0013e\u0016\fX/Z:u)>\u0004\u0018nY*uCR,7\u000fC\u0004\u0002\u0012\r\u0001\r!a\u0005\u0002!!\fg\u000e\u001a7f\u0019><W*Z:tC\u001e,\u0007cB'\u0002\u0016\u0005e\u0011\u0011F\u0005\u0004\u0003/q%!\u0003$v]\u000e$\u0018n\u001c82!\u0011\tY\"a\t\u000f\t\u0005u\u0011q\u0004\t\u0003K:K1!!\tO\u0003\u0019\u0001&/\u001a3fM&!\u0011QEA\u0014\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0005(\u0011\u00075\u000bY#C\u0002\u0002.9\u0013A!\u00168ji\u0006)2M]3bi\u0016$U\r\\3uS>tWI\u001c;sS\u0016\u001cH#\u00030\u00024\u0005]\u00121IA0\u0011\u001d\t)\u0004\u0002a\u0001\u00033\t\u0011\u0002^8qS\u000et\u0015-\\3\t\u000f\u0005eB\u00011\u0001\u0002<\u00059Ao\u001c9jG&#\u0007\u0003BA\u001f\u0003\u007fi\u0011\u0001^\u0005\u0004\u0003\u0003\"(\u0001B+vS\u0012Dq!!\u0012\u0005\u0001\u0004\t9%\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!!\u0013\u0002T\u0005ec\u0002BA&\u0003\u001fr1!ZA'\u0013\u0005y\u0015bAA)\u001d\u00069\u0001/Y2lC\u001e,\u0017\u0002BA+\u0003/\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003#r\u0005cA0\u0002\\%\u0019\u0011Q\f>\u00039U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7\u000b^1uK\"9\u00111\u0001\u0003A\u0002\u0005\u0015\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002f)\"\u0011qMA7!\ri\u0015\u0011N\u0005\u0004\u0003Wr%a\u0002\"p_2,\u0017M\\\u0016\u0003\u0003_\u0002B!!\u001d\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0010(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002~\u0005M$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKNAa\u0001TAA\u0003\u0013\u000by\t\u0005\u0003\u0002\u0004\u0006\u0015U\"A\"\n\u0007\u0005\u001d5IA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u0004\u0013\u0006-\u0015bAAG\u0003\n9\"l\u001b$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:f\u0007\u0006\u001c\u0007.\u001a\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011QS#\u0002\u000bU$\u0018\u000e\\:\n\t\u0005e\u00151\u0013\u0002\b\u0019><w-\u001b8h\u0003!\u0011'o\\6fe&#\u0017aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GS1\u0001]AS\u0015\t!\u0015/\u0003\u0003\u0002*\u0006\r&aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002\u001d\t\u0014xn[3s\r\u0016\fG/\u001e:fgB!\u00111QAX\u0013\r\t\tl\u0011\u0002\u000f\u0005J|7.\u001a:GK\u0006$XO]3t\u0003IQ8.T5he\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0015\u0015\u0005]\u0016\u0011XA^\u0003{\u000by\f\u0005\u0002J\r!9\u00111T\u0006A\u0002\u0005\u0015\u0001bBAO\u0017\u0001\u0007\u0011q\u0014\u0005\b\u0003W[\u0001\u0019AAW\u0011%\t\u0019l\u0003I\u0001\u0002\u0004\t9'A\u000bqCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006dunY6\u0016\u0005\u0005\u0015\u0007\u0003BAd\u0003#l!!!3\u000b\t\u0005-\u0017QZ\u0001\u0006Y>\u001c7n\u001d\u0006\u0004\u0003\u001fD\u0016AC2p]\u000e,(O]3oi&!\u00111[Ae\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017A\u00069beRLG/[8o\u001b\u0016$\u0018\rZ1uC2{7m\u001b\u0011\u0002!5,G/\u00193bi\u0006\u001cf.\u00199tQ>$X#A?\u0002)5,G/\u00193bi\u0006\u001cf.\u00199tQ>$x\fJ3r)\u0011\tI#a8\t\u0011\u0005\u0005x\"!AA\u0002u\f1\u0001\u001f\u00132\u0003EiW\r^1eCR\f7K\\1qg\"|G\u000f\t\u0015\u0004!\u0005\u001d\bcA'\u0002j&\u0019\u00111\u001e(\u0003\u0011Y|G.\u0019;jY\u0016\f\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s+\t\t\t\u0010\u0005\u0003\u0002t\u0006eXBAA{\u0015\r\t90R\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002BA~\u0003k\u0014\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\u0002\u0013}3W-\u0019;ve\u0016\u001cXC\u0001B\u0002!\u0015i%Q\u0001B\u0005\u0013\r\u00119A\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0005&1B\u0005\u0005\u0005\u001b\t\u0019KA\tGS:\fG.\u001b>fI\u001a+\u0017\r^;sKN\fQb\u00184fCR,(/Z:`I\u0015\fH\u0003BA\u0015\u0005'A\u0011\"!9\u0015\u0003\u0003\u0005\rAa\u0001\u0002\u0015}3W-\u0019;ve\u0016\u001c\b\u0005K\u0002\u0016\u0003O\f1BZ3biV\u0014X\rT8dWV\u0011!Q\u0004\t\u0005\u0003\u000f\u0014y\"\u0003\u0003\u0003\"\u0005%'!\u0004*fK:$(/\u00198u\u0019>\u001c7.\u0001\u0007gK\u0006$XO]3M_\u000e\\\u0007%A\u0006gK\u0006$XO]3D_:$WC\u0001B\u0015!\u0011\t9Ma\u000b\n\t\t5\u0012\u0011\u001a\u0002\n\u0007>tG-\u001b;j_:\fABZ3biV\u0014XmQ8oI\u0002\n\u0001$\\1zE\u00164\u0015\u000e\u001c;fe\u0006c\u0017N^3SKBd\u0017nY1t))\u0011)Da\u0011\u0003H\t-#1\f\t\u0005/r\u00139\u0004\u0005\u0003\u0003:\t}RB\u0001B\u001e\u0015\r\u0011iDW\u0001\u0005Y\u0006tw-\u0003\u0003\u0003B\tm\"aB%oi\u0016<WM\u001d\u0005\u0007\u0005\u000bR\u0002\u0019A?\u0002\u0011Mt\u0017\r]:i_RDqA!\u0013\u001b\u0001\u0004\u0011)$A\u0004ce>\\WM]:\t\u000f\t5#\u00041\u0001\u0003P\u0005aA.[:uK:,'OT1nKB!!\u0011\u000bB,\u001b\t\u0011\u0019FC\u0002\u0003VQ\fqA\\3uo>\u00148.\u0003\u0003\u0003Z\tM#\u0001\u0004'jgR,g.\u001a:OC6,\u0007b\u0002B/5\u0001\u0007\u0011qM\u0001\u001bM&dG/\u001a:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo]\u0001\u0015O\u0016$\b+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u0015\u0019\t\r$Q\u000fB<\u0005w\u0012iH!!\u0011\u000b5\u0013)A!\u001a\u0011\r\u0005%\u00131\u000bB4!\u0011\u0011IGa\u001c\u000f\u0007\u0001\u0014Y'C\u0002\u0003n]\fA#T3uC\u0012\fG/\u0019*fgB|gn]3ECR\f\u0017\u0002\u0002B9\u0005g\u0012\u0011$T3uC\u0012\fG/\u0019*fgB|gn]3QCJ$\u0018\u000e^5p]*\u0019!QN<\t\r\t\u00153\u00041\u0001~\u0011\u001d\u0011Ih\u0007a\u0001\u00033\tQ\u0001^8qS\u000eDqA!\u0014\u001c\u0001\u0004\u0011y\u0005C\u0004\u0003\u0000m\u0001\r!a\u001a\u00023\u0015\u0014(o\u001c:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo\u001d\u0005\b\u0005\u0007[\u0002\u0019AA4\u0003e)'O]8s+:\fg/Y5mC\ndW\rT5ti\u0016tWM]:\u0002!!\f7/\u00117jm\u0016,e\u000e\u001a9pS:$H\u0003CA4\u0005\u0013\u0013YI!$\t\r\t\u0015C\u00041\u0001~\u0011\u001d\tY\n\ba\u0001\u0003\u000bAqA!\u0014\u001d\u0001\u0004\u0011y%\u0001\thKR\fE.\u001b<f\u000b:$\u0007o\\5oiRA!1\u0013BN\u0005;\u0013y\nE\u0003N\u0005\u000b\u0011)\n\u0005\u0003\u0002>\t]\u0015b\u0001BMi\n!aj\u001c3f\u0011\u0019\u0011)%\ba\u0001{\"9\u00111T\u000fA\u0002\u0005\u0015\u0001b\u0002B';\u0001\u0007!qJ\u0001\u0011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$\"B!*\u00038\n\u0005'1\u0019Bc!\u0019\u00119K!,\u000326\u0011!\u0011\u0016\u0006\u0004\u0005Ws\u0015AC2pY2,7\r^5p]&!!q\u0016BU\u0005\r\u0019V-\u001d\t\u0005\u0005S\u0012\u0019,\u0003\u0003\u00036\nM$!F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f)>\u0004\u0018n\u0019\u0005\b\u0005ss\u0002\u0019\u0001B^\u0003\u0019!x\u000e]5dgB1!q\u0015B_\u00033IAAa0\u0003*\n\u00191+\u001a;\t\u000f\t5c\u00041\u0001\u0003P!I!q\u0010\u0010\u0011\u0002\u0003\u0007\u0011q\r\u0005\n\u0005\u0007s\u0002\u0013!a\u0001\u0003O\n!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM\n!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ\nq\u0002^8qS\u000et\u0015-\\3t)>LEm\u001d\u000b\u0003\u0005\u001f\u0004ra\u0016Bi\u00033\tY$C\u0002\u0003Tb\u00131!T1q\u0003=!x\u000e]5d\u0013\u0012\u001cHk\u001c(b[\u0016\u001cHC\u0001Bm!\u001d9&\u0011[A\u001e\u00033\t1\u0002^8qS\u000eLE-\u00138g_R\u0011!q\u001c\t\b\u001b\n\u0005(q\u001aBm\u0013\r\u0011\u0019O\u0014\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0019\u001d,G/\u00117m)>\u0004\u0018nY:\u0015\u0005\tm\u0016AE4fiR{\u0007/[2QCJ$\u0018\u000e^5p]N$BA!<\u0003vB1!q\u0015B_\u0005_\u0004B!!\u0010\u0003r&\u0019!1\u001f;\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011QG\u0013A\u0002\u0005eA\u0003\u0002B^\u0005sDaA!\u0012'\u0001\u0004i\u0018\u0001E4fi\u0006cG\u000eU1si&$\u0018n\u001c8t)\u0011\u0011ypa\u0001\u0011\u0011\u0005m1\u0011\u0001Bx\u00033JAAa5\u0002(!1!QI\u0014A\u0002u\fa\u0002[1t\u00032Lg/\u001a\"s_.,'\u000f\u0006\u0003\u0002h\r%\u0001bBANQ\u0001\u0007\u0011QA\u0001\u0010O\u0016$\u0018\t\\5wK\n\u0013xn[3sgR\u00111q\u0002\t\u0007\u0003\u0013\n\u0019f!\u0005\u0011\t\rM1\u0011D\u0007\u0003\u0007+Q1aa\u0006r\u0003\u0015\tG-\\5o\u0013\u0011\u0019Yb!\u0006\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\u0006\u0011r-\u001a;BY&4XM\u0011:pW\u0016\u0014hj\u001c3f)\u0019\u0011\u0019j!\t\u0004$!9\u00111\u0014\u0016A\u0002\u0005\u0015\u0001b\u0002B'U\u0001\u0007!qJ\u0001\u0014O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u001d>$Wm\u001d\u000b\u0005\u0007S\u0019Y\u0003\u0005\u0004\u0002J\u0005M#Q\u0013\u0005\b\u0005\u001bZ\u0003\u0019\u0001B(\u0003)9W\r\u001e+pa&\u001c\u0017\n\u001a\u000b\u0005\u0003w\u0019\t\u0004C\u0004\u000261\u0002\r!!\u0007\u0002\u0019\u001d,G\u000fV8qS\u000et\u0015-\\3\u0015\t\r]2\u0011\b\t\u0006\u001b\n\u0015\u0011\u0011\u0004\u0005\b\u0003si\u0003\u0019AA\u001e\u0003a\tG\rZ(s+B$\u0017\r^3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u000b\u0003S\u0019yd!\u0016\u0004X\rm\u0003bBB!]\u0001\u000711I\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgBA1QIB&\u00033\u0019y%\u0004\u0002\u0004H)!1\u0011\nBU\u0003\u001diW\u000f^1cY\u0016LAa!\u0014\u0004H\tI\u0011I\\=SK\u001al\u0015\r\u001d\t\u0007\u0007\u000b\u001a\t&!\u0017\n\t\rM3q\t\u0002\b\u0019>tw-T1q\u0011\u001d\u0011IH\fa\u0001\u00033Aqa!\u0017/\u0001\u0004\t)!A\u0006qCJ$\u0018\u000e^5p]&#\u0007bBB/]\u0001\u0007\u0011\u0011L\u0001\ngR\fG/Z%oM>\f\u0001cZ3u!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\r\r\r4QMB4!\u0015i%QAA-\u0011\u001d\u0011Ih\fa\u0001\u00033Aqa!\u00170\u0001\u0004\t)!A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0007[\u001ay\u0007E\u0003N\u0005\u000b\t)\u0001C\u0004\u0003zA\u0002\r!!\u0007\u00025\u001d,G\u000fU1si&$\u0018n\u001c8MK\u0006$WM]#oIB|\u0017N\u001c;\u0015\u0011\tM5QOB<\u0007sBqA!\u001f2\u0001\u0004\tI\u0002C\u0004\u0004ZE\u0002\r!!\u0002\t\u000f\t5\u0013\u00071\u0001\u0003P\u0005ar-\u001a;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0016sG\r]8j]R\u001cHCBB@\u0007\u0003\u001b)\t\u0005\u0005\u0002\u001c\r\u0005\u0011Q\u0001BK\u0011\u001d\u0019\u0019I\ra\u0001\u0005_\f!\u0001\u001e9\t\u000f\t5#\u00071\u0001\u0003P\u0005yq-\u001a;D_:$(o\u001c7mKJLE-\u0006\u0002\u0004\fB)QJ!\u0002\u0004\u000eB!\u00111QBH\u0013\r\u0019\tj\u0011\u0002\u0013\u0007\u0006\u001c\u0007.\u001a3D_:$(o\u001c7mKJLE-\u0001\fhKR\u0014\u0016M\u001c3p[\u0006c\u0017N^3Ce>\\WM]%e+\t\u0019i'\u0001\nhKR\u001cE.^:uKJlU\r^1eCR\fGCBBN\u0007C\u001b)\u000b\u0005\u0003\u0002>\ru\u0015bABPi\n91\t\\;ti\u0016\u0014\bbBBRk\u0001\u0007\u0011\u0011D\u0001\nG2,8\u000f^3s\u0013\u0012DqA!\u00146\u0001\u0004\u0011y%\u0001\bva\u0012\fG/Z'fi\u0006$\u0017\r^1\u0015\r\r-6QVBY!\u0019\u00119K!,\u0003p\"91q\u0016\u001cA\u0002\u0005\u0015\u0011!D2peJ,G.\u0019;j_:LE\rC\u0004\u00044Z\u0002\ra!.\u0002;=\u0014\u0018nZ5oC2,\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0004Baa.\u0004>6\u00111\u0011\u0018\u0006\u0004\u0007w#\u0018\u0001\u0003:fcV,7\u000f^:\n\t\r}6\u0011\u0018\u0002\u0016+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0003!\u0019wN\u001c;bS:\u001cH\u0003BA4\u0007\u000bDqA!\u001f8\u0001\u0004\tI\u0002\u0006\u0003\u0002h\r%\u0007bBBBq\u0001\u0007!q^\u0001\u0014e\u0016lwN^3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u000b\u0003O\u001aym!5\u0004Z\u000em\u0007bBB!s\u0001\u000711\t\u0005\b\u0007'L\u0004\u0019ABk\u0003!!x\u000e]5d\u0013\u0012\u001c\b\u0003CB#\u0007/\fI\"a\u000f\n\t\tM7q\t\u0005\b\u0005sJ\u0004\u0019AA\r\u0011\u001d\u0019I&\u000fa\u0001\u0003\u000b!\"!a(\u0002\u0011\u0019,\u0017\r^;sKN$\"A!\u0003\u0002+U\u0004H-\u0019;f\r\u0016\fG/\u001e:fg>\u0013H\u000b\u001b:poR1\u0011\u0011FBt\u0007gDqa!;=\u0001\u0004\u0019Y/\u0001\bmCR,7\u000f\u001e$fCR,(/Z:\u0011\u0011\u0005m1\u0011AA\r\u0007[\u00042!TBx\u0013\r\u0019\tP\u0014\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0007kd\u0004\u0019AB|\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0011\u00075\u001bI0C\u0002\u0004|:\u0013A\u0001T8oO\u0006i1\r\\3be\u001a+\u0017\r^;sKN$\"!!\u000b\u00029]\f\u0017\u000e^+oi&dg)Z1ukJ,W\t]8dQ>\u0013H\u000b\u001b:poR1\u0011\u0011\u0006C\u0003\t\u0013Aq\u0001b\u0002?\u0001\u0004\u001990\u0001\tnS:,\u0005\u0010]3di\u0016$W\t]8dQ\"9A1\u0002 A\u0002\r]\u0018!\u0003;j[\u0016|W\u000f^'t\u0003A9W\r\u001e$fCR,(/Z(qi&|g\u000e")
public class ZkMetadataCache
implements MetadataCache,
ZkFinalizedFeatureCache,
Logging {
    private final int brokerId;
    private final MetadataVersion metadataVersion;
    private final BrokerFeatures brokerFeatures;
    private final boolean zkMigrationEnabled;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private volatile Option<FinalizedFeatures> _features;
    private final ReentrantLock featureLock;
    private final Condition featureCond;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$4() {
        return false;
    }

    public static UpdateMetadataRequestData.UpdateMetadataTopicState createDeletionEntries(String topicName, Uuid topicId, Iterable<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitions, int requestControllerEpoch) {
        return ZkMetadataCache$.MODULE$.createDeletionEntries(topicName, topicId, partitions, requestControllerEpoch);
    }

    public static java.util.List<UpdateMetadataRequestData.UpdateMetadataTopicState> transformKRaftControllerFullMetadataRequest(MetadataSnapshot currentMetadata, int requestControllerEpoch, java.util.List<UpdateMetadataRequestData.UpdateMetadataTopicState> requestTopicStates, Function1<String, BoxedUnit> handleLogMessage) {
        HashMap transformKRaftControllerFullMetadataRequest_topicIdToNewState = new HashMap();
        requestTopicStates.forEach(arg_0 -> ZkMetadataCache$.$anonfun$transformKRaftControllerFullMetadataRequest$1(transformKRaftControllerFullMetadataRequest_topicIdToNewState, arg_0));
        ArrayList<UpdateMetadataRequestData.UpdateMetadataTopicState> transformKRaftControllerFullMetadataRequest_newRequestTopicStates = new ArrayList<UpdateMetadataRequestData.UpdateMetadataTopicState>();
        currentMetadata.topicNames().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> ZkMetadataCache$.$anonfun$transformKRaftControllerFullMetadataRequest$2(transformKRaftControllerFullMetadataRequest_topicIdToNewState, currentMetadata, handleLogMessage, transformKRaftControllerFullMetadataRequest_newRequestTopicStates, requestControllerEpoch, arg_0, arg_1), arg_0, arg_1));
        if (transformKRaftControllerFullMetadataRequest_newRequestTopicStates.isEmpty()) {
            return requestTopicStates;
        }
        transformKRaftControllerFullMetadataRequest_newRequestTopicStates.addAll(requestTopicStates);
        return transformKRaftControllerFullMetadataRequest_newRequestTopicStates;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private Option<FinalizedFeatures> _features() {
        return this._features;
    }

    private void _features_$eq(Option<FinalizedFeatures> x$1) {
        this._features = x$1;
    }

    private ReentrantLock featureLock() {
        return this.featureLock;
    }

    private Condition featureCond() {
        return this.featureCond;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, java.util.List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        CollectionConverters$.MODULE$.ListHasAsScala(brokers).asScala().foreach((Function1 & Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable)partitions -> (scala.collection.mutable.Iterable)partitions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long partitionId = x0$1._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
                TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
                int leaderBrokerId = partitionState.leader();
                int leaderEpoch = partitionState.leaderEpoch();
                Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
                java.util.List replicas = partitionState.replicas();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
                java.util.List isr = partitionState.isr();
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
                java.util.List offlineReplicas = partitionState.offlineReplicas();
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!snapshot.aliveBrokers().contains((long)leaderBrokerId)) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(leaderBrokerId).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    if (filteredReplicas.size() < replicas.size()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicas).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < isr.size()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(100).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(isr).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt((Object)maybeLeader.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            }
            throw new MatchError(null);
        }));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains((Object)listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable)x$4 -> x$4.get((Object)listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)snapshot.topicIds().getOrElse(topic, (Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava(this.metadataSnapshot().topicIds()).asJava());
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava(this.metadataSnapshot().topicNames()).asJava());
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return new Tuple2(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava(snapshot.topicIds()).asJava()), Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava(snapshot.topicNames()).asJava()));
    }

    @Override
    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        return ((IterableOnceOps)((MapOps)this.metadataSnapshot().partitionStates().getOrElse((Object)topicName, (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).values().map((Function1 & Serializable)p -> new TopicPartition(topicName, p.partitionIndex()))).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                return (scala.collection.mutable.Map)((LongMap)x0$1._2()).map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        long partition = x0$2._1$mcJ$sp();
                        UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                        return new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        }, DummyImplicit$.MODULE$.dummyImplicit()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains((long)brokerId);
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), Optional.ofNullable(b.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId).flatMap((Function1 & Serializable)x$5 -> x$5.getNode(listenerName));
    }

    @Override
    public Iterable<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().flatMap((Function1 & Serializable)x$6 -> x$6.getNode(listenerName));
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)this.metadataSnapshot().topicIds().getOrElse((Object)topicName, (Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return this.metadataSnapshot().topicNames().get((Object)topicId);
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        ((LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable)() -> LongMap$.MODULE$.empty())).update((long)partitionId, (Object)stateInfo);
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$7 -> x$7.get((long)partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$9 -> x$9.get((long)partitionId)).map((Function1 & Serializable)partitionInfo -> {
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                return (Node)((Map)((Some)option).value()).getOrElse((Object)listenerName, (Function0 & Serializable)() -> Node.noNode());
            }
            if (None$.MODULE$.equals(option)) {
                return Node.noNode();
            }
            throw new MatchError((Object)option);
        });
    }

    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable)x$10 -> x$10.get((long)tp.partition())).map((Function1 & Serializable)partitionInfo -> {
            java.util.List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicaIds).asScala().map((Function1 & Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0 & Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        List aliveBrokers = this.metadataSnapshot().aliveBrokers().values().toList();
        return new Some((Object)BoxesRunTime.boxToInteger((int)((Broker)aliveBrokers.apply(ThreadLocalRandom.current().nextInt(aliveBrokers.size()))).id()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = snapshot.aliveNodes().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long id = x0$1._1$mcJ$sp();
                return ((Map)x0$1._2()).get((Object)listenerName).map((Function1 & Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), node));
            }
            throw new MatchError(null);
        });
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((IterableOps)this.getAllPartitions(snapshot).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$6(x0$2)))).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                TopicPartition tp = (TopicPartition)x0$3._1();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
                return new PartitionInfo(tp.topic(), tp.partition(), ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.replicas()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.isr()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.offlineReplicas()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)));
            }
            throw new MatchError(null);
        });
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = CollectionConverters$.MODULE$.SetHasAsJava((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$11(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)CollectionConverters$.MODULE$.BufferHasAsJava(nodes.values().toBuffer()).asJava(), (Collection)CollectionConverters$.MODULE$.BufferHasAsJava(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)this.controllerId$1(snapshot, listenerName).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest originalUpdateMetadataRequest) {
        scala.collection.immutable.Seq seq;
        ObjectRef updateMetadataRequest = ObjectRef.create((Object)originalUpdateMetadataRequest);
        Lock inWriteLock_inLock_lock = this.partitionMetadataLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            Object var16_21;
            Object var17_22;
            Object var30_11;
            Object var29_10;
            Object var25_9;
            java.util.List list;
            Function1 & Serializable intersect;
            AbstractControlRequest.Type type;
            if (((UpdateMetadataRequest)updateMetadataRequest.elem).isKRaftController()) {
                AbstractControlRequest.Type type2 = ((UpdateMetadataRequest)updateMetadataRequest.elem).updateType();
                type = AbstractControlRequest.Type.FULL;
                if (!(type2 != null ? !type2.equals(type) : type != null)) {
                    if (((UpdateMetadataRequest)updateMetadataRequest.elem).version() < 8) {
                        this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(141).append("Received UpdateMetadataRequest with Type=FULL (2), but version of ").append(((UpdateMetadataRequest)updateMetadataRequest$1.elem).version()).append(", which should not be possible. Not treating this as a full ").append("metadata update").toString());
                    } else if (!this.zkMigrationEnabled) {
                        this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable)() -> "Received UpdateMetadataRequest with Type=FULL (2), but ZK migrations are not enabled on this broker. Not treating this as a full metadata update");
                    } else {
                        ArrayList arrayList;
                        void $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_requestControllerEpoch;
                        void $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_handleLogMessage;
                        void $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_requestTopicStates;
                        intersect = (Function1 & Serializable)logMessage -> {
                            ZkMetadataCache.$anonfun$updateMetadata$4(this, logMessage);
                            return BoxedUnit.UNIT;
                        };
                        list = ((UpdateMetadataRequest)updateMetadataRequest.elem).topicStates();
                        int n = ((UpdateMetadataRequest)updateMetadataRequest.elem).controllerEpoch();
                        MetadataSnapshot $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_currentMetadata = this.metadataSnapshot();
                        HashMap $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_topicIdToNewState = new HashMap();
                        $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_requestTopicStates.forEach(arg_0 -> ZkMetadataCache$.$anonfun$transformKRaftControllerFullMetadataRequest$1($anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_topicIdToNewState, arg_0));
                        ArrayList $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_newRequestTopicStates = new ArrayList();
                        $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_currentMetadata.topicNames().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> ZkMetadataCache$.$anonfun$transformKRaftControllerFullMetadataRequest$2($anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_topicIdToNewState, $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_currentMetadata, (Function1)$anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_handleLogMessage, $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_newRequestTopicStates, (int)$anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_requestControllerEpoch, arg_0, arg_1), arg_0, arg_1));
                        if ($anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_newRequestTopicStates.isEmpty()) {
                            arrayList = $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_requestTopicStates;
                        } else {
                            $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_newRequestTopicStates.addAll($anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_requestTopicStates);
                            arrayList = $anonfun$updateMetadata$1_transformKRaftControllerFullMetadataRequest_newRequestTopicStates;
                        }
                        var25_9 = null;
                        list = null;
                        intersect = null;
                        var29_10 = null;
                        var30_11 = null;
                        ArrayList $anonfun$updateMetadata$1_newTopicStates = arrayList;
                        UpdateMetadataRequestData $anonfun$updateMetadata$1_originalRequestData = ((UpdateMetadataRequest)updateMetadataRequest.elem).data();
                        UpdateMetadataRequestData $anonfun$updateMetadata$1_newData = new UpdateMetadataRequestData().setControllerId($anonfun$updateMetadata$1_originalRequestData.controllerId()).setIsKRaftController($anonfun$updateMetadata$1_originalRequestData.isKRaftController()).setType($anonfun$updateMetadata$1_originalRequestData.type()).setControllerEpoch($anonfun$updateMetadata$1_originalRequestData.controllerEpoch()).setBrokerEpoch($anonfun$updateMetadata$1_originalRequestData.brokerEpoch()).setTopicStates($anonfun$updateMetadata$1_newTopicStates).setLiveBrokers($anonfun$updateMetadata$1_originalRequestData.liveBrokers());
                        updateMetadataRequest.elem = new UpdateMetadataRequest($anonfun$updateMetadata$1_newData, ((UpdateMetadataRequest)updateMetadataRequest.elem).version());
                    }
                }
            }
            LongMap $anonfun$updateMetadata$1_aliveBrokers = new LongMap(this.metadataSnapshot().aliveBrokers().size());
            LongMap $anonfun$updateMetadata$1_aliveNodes = new LongMap(this.metadataSnapshot().aliveNodes().size());
            int n = ((UpdateMetadataRequest)updateMetadataRequest.elem).controllerId();
            switch (n) {
                default: 
            }
            None$ $anonfun$updateMetadata$1_controllerIdOpt = n < 0 ? None$.MODULE$ : (((UpdateMetadataRequest)updateMetadataRequest.elem).isKRaftController() ? new Some((Object)new KRaftCachedControllerId(n)) : new Some((Object)new ZkCachedControllerId(n)));
            ((UpdateMetadataRequest)updateMetadataRequest.elem).liveBrokers().forEach(broker -> {
                HashMap nodes = new HashMap();
                ArrayBuffer endPoints = new ArrayBuffer();
                broker.endpoints().forEach(ep -> {
                    ListenerName listenerName = new ListenerName(ep.listener());
                    endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                    nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port(), broker.rack()));
                });
                aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack())));
                aliveNodes.update((long)broker.id(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(nodes).asScala());
            });
            $anonfun$updateMetadata$1_aliveNodes.get((long)this.brokerId).foreach((Function1 & Serializable)listenerMap -> {
                ZkMetadataCache.$anonfun$updateMetadata$9(this, aliveNodes, listenerMap);
                return BoxedUnit.UNIT;
            });
            scala.collection.mutable.Map $anonfun$updateMetadata$1_topicIds = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            $anonfun$updateMetadata$1_topicIds.$plus$plus$eq(this.metadataSnapshot().topicIds());
            Tuple2 tuple2 = ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequest)updateMetadataRequest.elem).topicStates()).asScala().map((Function1 & Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()))).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$13(x0$1)));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Buffer $anonfun$updateMetadata$1_newTopicIds = (Buffer)tuple2._1();
            Buffer $anonfun$updateMetadata$1_newZeroIds = (Buffer)tuple2._2();
            var17_22.foreach((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String zeroIdTopic = (String)x0$2._1();
                    return topicIds.remove((Object)zeroIdTopic);
                }
                throw new MatchError(null);
            });
            $anonfun$updateMetadata$1_topicIds.$plus$plus$eq((IterableOnce)var16_21.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            LinkedHashSet $anonfun$updateMetadata$1_deletedPartitions = new LinkedHashSet();
            if (!((UpdateMetadataRequest)updateMetadataRequest.elem).partitionStates().iterator().hasNext()) {
                this.metadataSnapshot_$eq(new MetadataSnapshot(this.metadataSnapshot().partitionStates(), (scala.collection.immutable.Map<String, Uuid>)$anonfun$updateMetadata$1_topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<CachedControllerId>)$anonfun$updateMetadata$1_controllerIdOpt, (LongMap<Broker>)$anonfun$updateMetadata$1_aliveBrokers, (LongMap<Map<ListenerName, Node>>)$anonfun$updateMetadata$1_aliveNodes));
            } else {
                AnyRefMap $anonfun$updateMetadata$1_partitionStates = new AnyRefMap(this.metadataSnapshot().partitionStates().size());
                this.metadataSnapshot().partitionStates().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(topic, oldPartitionStates) -> {
                    ZkMetadataCache.$anonfun$updateMetadata$15(partitionStates, topic, oldPartitionStates);
                    return BoxedUnit.UNIT;
                }, arg_0, arg_1));
                boolean $anonfun$updateMetadata$1_traceEnabled = this.stateChangeLogger().isTraceEnabled();
                int $anonfun$updateMetadata$1_controllerId = ((UpdateMetadataRequest)updateMetadataRequest.elem).controllerId();
                int $anonfun$updateMetadata$1_controllerEpoch = ((UpdateMetadataRequest)updateMetadataRequest.elem).controllerEpoch();
                Iterable $anonfun$updateMetadata$1_newStates = CollectionConverters$.MODULE$.IterableHasAsScala(((UpdateMetadataRequest)updateMetadataRequest.elem).partitionStates()).asScala();
                $anonfun$updateMetadata$1_newStates.foreach((Function1 & Serializable)state -> {
                    TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                    if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                        this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                        if (traceEnabled) {
                            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                        }
                        return BoxesRunTime.boxToBoolean((boolean)deletedPartitions.add(tp));
                    }
                    this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                    deletedPartitions.remove(tp);
                    if (traceEnabled) {
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                int $anonfun$updateMetadata$1_cachedPartitionsCount = $anonfun$updateMetadata$1_newStates.size() - $anonfun$updateMetadata$1_deletedPartitions.size();
                this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(145).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                this.metadataSnapshot_$eq(new MetadataSnapshot((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)$anonfun$updateMetadata$1_partitionStates, (scala.collection.immutable.Map<String, Uuid>)$anonfun$updateMetadata$1_topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<CachedControllerId>)$anonfun$updateMetadata$1_controllerIdOpt, (LongMap<Broker>)$anonfun$updateMetadata$1_aliveBrokers, (LongMap<Map<ListenerName, Node>>)$anonfun$updateMetadata$1_aliveNodes));
            }
            seq = CollectionConverters$.MODULE$.SetHasAsScala($anonfun$updateMetadata$1_deletedPartitions).asScala().toSeq();
            type = null;
            Object var7_12 = null;
            Object var8_13 = null;
            Object var9_14 = null;
            Object var10_15 = null;
            Object var11_16 = null;
            Object var12_18 = null;
            Object var14_19 = null;
            tuple2 = null;
            var16_21 = null;
            var17_22 = null;
            Object var18_23 = null;
            Object var19_24 = null;
            Object var23_28 = null;
            var25_9 = null;
            list = null;
            intersect = null;
            var29_10 = null;
            var30_11 = null;
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return seq;
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, topicIds, infos)));
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    @Override
    public FinalizedFeatures features() {
        Option<FinalizedFeatures> option = this._features();
        if (option instanceof Some) {
            return (FinalizedFeatures)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            return new FinalizedFeatures(this.metadataVersion, Collections.emptyMap(), -1L, false);
        }
        throw new MatchError(option);
    }

    public void updateFeaturesOrThrow(scala.collection.immutable.Map<String, Object> latestFeatures, long latestEpoch) {
        FinalizedFeatures latest = new FinalizedFeatures(this.metadataVersion, CollectionConverters$.MODULE$.MapHasAsJava((Map)latestFeatures.map((Function1 & Serializable)kv -> new Tuple2(kv._1(), (Object)((Short)kv._2())))).asJava(), latestEpoch, false);
        Option<FinalizedFeatures> existing = this._features();
        if (existing.isDefined() && ((FinalizedFeatures)existing.get()).finalizedFeaturesEpoch() > latest.finalizedFeaturesEpoch()) {
            String errorMsg = new StringBuilder(99).append("FinalizedFeatureCache update failed due to invalid epoch in new ").append(latest).append(".").append(" The existing cache contents are ").append(existing).append(".").toString();
            throw new FeatureCacheUpdateException(errorMsg);
        }
        if (this.brokerFeatures.incompatibleFeatures((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(latest.finalizedFeatures()).asScala().map((Function1 & Serializable)kv -> new Tuple2(kv._1(), (Object)BoxesRunTime.boxToShort((short)Predef$.MODULE$.Short2short((Short)kv._2())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).nonEmpty()) {
            String errorMsg = new StringBuilder(129).append("FinalizedFeatureCache update failed since feature compatibility").append(" checks failed! Supported ").append(this.brokerFeatures.supportedFeatures()).append(" has incompatibilities").append(" with the latest ").append(latest).append(".").toString();
            throw new FeatureCacheUpdateException(errorMsg);
        }
        String logMsg = new StringBuilder(40).append("Updated cache from existing ").append(existing).append(" to latest ").append(latest).append(".").toString();
        ReentrantLock inLock_lock = this.featureLock();
        inLock_lock.lock();
        try {
            ZkMetadataCache.$anonfun$updateFeaturesOrThrow$3(this, latest);
        }
        finally {
            inLock_lock.unlock();
        }
        Object var9_8 = null;
        this.info((Function0<String>)(Function0 & Serializable)() -> logMsg);
    }

    public void clearFeatures() {
        ReentrantLock inLock_lock = this.featureLock();
        inLock_lock.lock();
        try {
            ZkMetadataCache.$anonfun$clearFeatures$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public void waitUntilFeatureEpochOrThrow(long minExpectedEpoch, long timeoutMs) {
        if (minExpectedEpoch < 0L) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Expected minExpectedEpoch >= 0, but ").append(minExpectedEpoch).append(" was provided.").toString());
        }
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException(new StringBuilder(43).append("Expected timeoutMs >= 0, but ").append(timeoutMs).append(" was provided.").toString());
        }
        long waitEndTimeNanos = System.nanoTime() + timeoutMs * 1000000L;
        ReentrantLock inLock_lock = this.featureLock();
        inLock_lock.lock();
        try {
            ZkMetadataCache.$anonfun$waitUntilFeatureEpochOrThrow$1(this, minExpectedEpoch, waitEndTimeNanos, timeoutMs);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public Option<FinalizedFeatures> getFeatureOption() {
        return this._features();
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair != null) {
            return !((Node)pair._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse((long)Predef$.MODULE$.Integer2int(id), (Function0 & Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    private final Option controllerId$1(MetadataSnapshot snapshot, ListenerName listenerName$10) {
        return snapshot.controllerId().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof ZkCachedControllerId) {
                int id = ((ZkCachedControllerId)x0$1).id();
                return this.getAliveBrokerNode(id, listenerName$10);
            }
            if (x0$1 instanceof KRaftCachedControllerId) {
                return this.getRandomAliveBrokerId().flatMap((Function1 & Serializable)x$11 -> this.getAliveBrokerNode(BoxesRunTime.unboxToInt((Object)x$11), listenerName$10));
            }
            throw new MatchError(x0$1);
        });
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$6(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$11(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(ZkMetadataCache $this, String logMessage) {
        if (logMessage.startsWith("Error")) {
            $this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable)() -> logMessage);
            return;
        }
        $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable)() -> logMessage);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$10(Set listeners$1, Map x$12) {
        Set set = x$12.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$9(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$10(listeners, x$12)))) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$13(Tuple2 x0$1) {
        if (x0$1 != null) {
            Uuid uuid = (Uuid)x0$1._2();
            Uuid uuid2 = Uuid.ZERO_UUID;
            return uuid == null ? uuid2 != null : !uuid.equals(uuid2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$15(AnyRefMap partitionStates$1, String topic, LongMap oldPartitionStates) {
        LongMap copy = new LongMap(oldPartitionStates.size());
        copy.$plus$plus$eq((IterableOnce)oldPartitionStates);
        partitionStates$1.update((Object)topic, (Object)copy);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$updateMetadata$1(ZkMetadataCache $this, ObjectRef updateMetadataRequest$1, int correlationId$1) {
        void var13_19;
        void var14_20;
        if (((UpdateMetadataRequest)updateMetadataRequest$1.elem).isKRaftController()) {
            AbstractControlRequest.Type type = ((UpdateMetadataRequest)updateMetadataRequest$1.elem).updateType();
            AbstractControlRequest.Type type2 = AbstractControlRequest.Type.FULL;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                if (((UpdateMetadataRequest)updateMetadataRequest$1.elem).version() < 8) {
                    $this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(141).append("Received UpdateMetadataRequest with Type=FULL (2), but version of ").append(((UpdateMetadataRequest)updateMetadataRequest$1.elem).version()).append(", which should not be possible. Not treating this as a full ").append("metadata update").toString());
                } else if (!$this.zkMigrationEnabled) {
                    $this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable)() -> "Received UpdateMetadataRequest with Type=FULL (2), but ZK migrations are not enabled on this broker. Not treating this as a full metadata update");
                } else {
                    ArrayList arrayList;
                    void transformKRaftControllerFullMetadataRequest_requestControllerEpoch;
                    void transformKRaftControllerFullMetadataRequest_handleLogMessage;
                    void transformKRaftControllerFullMetadataRequest_requestTopicStates;
                    Function1 & Serializable intersect = (Function1 & Serializable)logMessage -> {
                        ZkMetadataCache.$anonfun$updateMetadata$4(this, logMessage);
                        return BoxedUnit.UNIT;
                    };
                    java.util.List list = ((UpdateMetadataRequest)updateMetadataRequest$1.elem).topicStates();
                    int n = ((UpdateMetadataRequest)updateMetadataRequest$1.elem).controllerEpoch();
                    MetadataSnapshot transformKRaftControllerFullMetadataRequest_currentMetadata = $this.metadataSnapshot();
                    HashMap transformKRaftControllerFullMetadataRequest_topicIdToNewState = new HashMap();
                    transformKRaftControllerFullMetadataRequest_requestTopicStates.forEach(arg_0 -> ZkMetadataCache$.$anonfun$transformKRaftControllerFullMetadataRequest$1(transformKRaftControllerFullMetadataRequest_topicIdToNewState, arg_0));
                    ArrayList transformKRaftControllerFullMetadataRequest_newRequestTopicStates = new ArrayList();
                    transformKRaftControllerFullMetadataRequest_currentMetadata.topicNames().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> ZkMetadataCache$.$anonfun$transformKRaftControllerFullMetadataRequest$2(transformKRaftControllerFullMetadataRequest_topicIdToNewState, transformKRaftControllerFullMetadataRequest_currentMetadata, (Function1)transformKRaftControllerFullMetadataRequest_handleLogMessage, transformKRaftControllerFullMetadataRequest_newRequestTopicStates, (int)transformKRaftControllerFullMetadataRequest_requestControllerEpoch, arg_0, arg_1), arg_0, arg_1));
                    if (transformKRaftControllerFullMetadataRequest_newRequestTopicStates.isEmpty()) {
                        arrayList = transformKRaftControllerFullMetadataRequest_requestTopicStates;
                    } else {
                        transformKRaftControllerFullMetadataRequest_newRequestTopicStates.addAll(transformKRaftControllerFullMetadataRequest_requestTopicStates);
                        arrayList = transformKRaftControllerFullMetadataRequest_newRequestTopicStates;
                    }
                    Object var22_7 = null;
                    list = null;
                    intersect = null;
                    Object var26_8 = null;
                    Object var27_9 = null;
                    ArrayList newTopicStates = arrayList;
                    UpdateMetadataRequestData originalRequestData = ((UpdateMetadataRequest)updateMetadataRequest$1.elem).data();
                    UpdateMetadataRequestData newData = new UpdateMetadataRequestData().setControllerId(originalRequestData.controllerId()).setIsKRaftController(originalRequestData.isKRaftController()).setType(originalRequestData.type()).setControllerEpoch(originalRequestData.controllerEpoch()).setBrokerEpoch(originalRequestData.brokerEpoch()).setTopicStates(newTopicStates).setLiveBrokers(originalRequestData.liveBrokers());
                    updateMetadataRequest$1.elem = new UpdateMetadataRequest(newData, ((UpdateMetadataRequest)updateMetadataRequest$1.elem).version());
                }
            }
        }
        LongMap aliveBrokers = new LongMap($this.metadataSnapshot().aliveBrokers().size());
        LongMap aliveNodes = new LongMap($this.metadataSnapshot().aliveNodes().size());
        int n = ((UpdateMetadataRequest)updateMetadataRequest$1.elem).controllerId();
        switch (n) {
            default: 
        }
        None$ controllerIdOpt = n < 0 ? None$.MODULE$ : (((UpdateMetadataRequest)updateMetadataRequest$1.elem).isKRaftController() ? new Some((Object)new KRaftCachedControllerId(n)) : new Some((Object)new ZkCachedControllerId(n)));
        ((UpdateMetadataRequest)updateMetadataRequest$1.elem).liveBrokers().forEach(broker -> {
            HashMap nodes = new HashMap();
            ArrayBuffer endPoints = new ArrayBuffer();
            broker.endpoints().forEach(ep -> {
                ListenerName listenerName = new ListenerName(ep.listener());
                endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port(), broker.rack()));
            });
            aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack())));
            aliveNodes.update((long)broker.id(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(nodes).asScala());
        });
        aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable)listenerMap -> {
            ZkMetadataCache.$anonfun$updateMetadata$9(this, aliveNodes, listenerMap);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map topicIds = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        topicIds.$plus$plus$eq($this.metadataSnapshot().topicIds());
        Tuple2 tuple2 = ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequest)updateMetadataRequest$1.elem).topicStates()).asScala().map((Function1 & Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()))).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$13(x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer newTopicIds = (Buffer)tuple2._1();
        Buffer newZeroIds = (Buffer)tuple2._2();
        var14_20.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String zeroIdTopic = (String)x0$2._1();
                return topicIds.remove((Object)zeroIdTopic);
            }
            throw new MatchError(null);
        });
        topicIds.$plus$plus$eq((IterableOnce)var13_19.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        LinkedHashSet deletedPartitions = new LinkedHashSet();
        if (!((UpdateMetadataRequest)updateMetadataRequest$1.elem).partitionStates().iterator().hasNext()) {
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this.metadataSnapshot().partitionStates(), (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<CachedControllerId>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        } else {
            AnyRefMap partitionStates = new AnyRefMap($this.metadataSnapshot().partitionStates().size());
            $this.metadataSnapshot().partitionStates().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(topic, oldPartitionStates) -> {
                ZkMetadataCache.$anonfun$updateMetadata$15(partitionStates, topic, oldPartitionStates);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1));
            boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
            int controllerId = ((UpdateMetadataRequest)updateMetadataRequest$1.elem).controllerId();
            int controllerEpoch = ((UpdateMetadataRequest)updateMetadataRequest$1.elem).controllerEpoch();
            Iterable newStates = CollectionConverters$.MODULE$.IterableHasAsScala(((UpdateMetadataRequest)updateMetadataRequest$1.elem).partitionStates()).asScala();
            newStates.foreach((Function1 & Serializable)state -> {
                TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                    this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                    if (traceEnabled) {
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    }
                    return BoxesRunTime.boxToBoolean((boolean)deletedPartitions.add(tp));
                }
                this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                deletedPartitions.remove(tp);
                if (traceEnabled) {
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
            $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(145).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
            $this.metadataSnapshot_$eq(new MetadataSnapshot((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<CachedControllerId>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        }
        return CollectionConverters$.MODULE$.SetHasAsScala(deletedPartitions).asScala().toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        if (infos.isEmpty()) {
            partitionStates$2.remove((Object)topic$4);
            topicIds$2.remove((Object)topic$4);
        }
        return true;
    }

    public static final /* synthetic */ void $anonfun$updateFeaturesOrThrow$3(ZkMetadataCache $this, FinalizedFeatures latest$1) {
        $this._features_$eq((Option<FinalizedFeatures>)new Some((Object)latest$1));
        $this.featureCond().signalAll();
    }

    public static final /* synthetic */ void $anonfun$clearFeatures$1(ZkMetadataCache $this) {
        $this._features_$eq((Option<FinalizedFeatures>)None$.MODULE$);
        $this.featureCond().signalAll();
    }

    public static final /* synthetic */ void $anonfun$waitUntilFeatureEpochOrThrow$1(ZkMetadataCache $this, long minExpectedEpoch$1, long waitEndTimeNanos$1, long timeoutMs$1) {
        while (!$this._features().isDefined() || ((FinalizedFeatures)$this._features().get()).finalizedFeaturesEpoch() < minExpectedEpoch$1) {
            long nowNanos = System.nanoTime();
            if (nowNanos > waitEndTimeNanos$1) {
                throw new TimeoutException(new StringBuilder(81).append("Timed out after waiting for ").append(timeoutMs$1).append("ms for required condition to be met.").append(" Current epoch: ").append($this._features().map((Function1 & Serializable)fe -> BoxesRunTime.boxToLong((long)fe.finalizedFeaturesEpoch())).getOrElse((Function0 & Serializable)() -> "<none>")).append(".").toString());
            }
            long sleepTimeMs = package$.MODULE$.max(1L, (waitEndTimeNanos$1 - nowNanos) / 1000000L);
            $this.featureCond().await(sleepTimeMs, TimeUnit.MILLISECONDS);
        }
    }

    public ZkMetadataCache(int brokerId, MetadataVersion metadataVersion, BrokerFeatures brokerFeatures, boolean zkMigrationEnabled) {
        this.brokerId = brokerId;
        this.metadataVersion = metadataVersion;
        this.brokerFeatures = brokerFeatures;
        this.zkMigrationEnabled = zkMigrationEnabled;
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), (Option<CachedControllerId>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
        this._features = Option$.MODULE$.empty();
        this.featureLock = new ReentrantLock();
        this.featureCond = this.featureLock().newCondition();
    }
}

