/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.ProducerIdsBlock;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001\u0002\f\u0018\u0001yA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011\u0015q\u0005\u0001\"\u0001P\u0011!)\u0006\u00011A\u0005\u0002]1\u0006\u0002\u00035\u0001\u0001\u0004%\taF5\t\r=\u0004\u0001\u0015)\u0003X\u0011\u001d\u0001\bA1A\u0005\nYCa!\u001d\u0001!\u0002\u00139\u0006b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007o\u0002\u0001\u000b\u0011\u0002;\t\u000fa\u0004!\u0019!C\u0005s\"1Q\u0010\u0001Q\u0001\niDQA \u0001\u0005B}Dq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u0016\u0001!I!a\u0006\t\u0011\u0005e\u0001\u0001\"\u0001\u0018\u0003/A\u0001\"a\u0007\u0001\t\u00039\u0012Q\u0004\u0005\b\u0003_\u0001A\u0011BA\f\u0011\u001d\t\t\u0004\u0001C\u0005\u0003/\u0011AC\u0015)D!J|G-^2fe&#W*\u00198bO\u0016\u0014(B\u0001\r\u001a\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005iY\u0012aC2p_J$\u0017N\\1u_JT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001q$J\u0015\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0018\u0013\tAsCA\tQe>$WoY3s\u0013\u0012l\u0015M\\1hKJ\u0004\"AK\u0017\u000e\u0003-R!\u0001L\u000e\u0002\u000bU$\u0018\u000e\\:\n\u00059Z#a\u0002'pO\u001eLgnZ\u0001\tEJ|7.\u001a:JIB\u0011\u0001%M\u0005\u0003e\u0005\u00121!\u00138u\u0003\u0011!\u0018.\\3\u0011\u0005UrT\"\u0001\u001c\u000b\u00051:$B\u0001\u001d:\u0003\u0019\u0019w.\\7p]*\u0011AD\u000f\u0006\u0003wq\na!\u00199bG\",'\"A\u001f\u0002\u0007=\u0014x-\u0003\u0002@m\t!A+[7f\u0003M\u0011'o\\6fe\u0016\u0003xn\u00195TkB\u0004H.[3s!\r\u0001#\tR\u0005\u0003\u0007\u0006\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\u0001*\u0015B\u0001$\"\u0005\u0011auN\\4\u0002#\r|g\u000e\u001e:pY2,'o\u00115b]:,G\u000e\u0005\u0002J\u00196\t!J\u0003\u0002Ls\u000511/\u001a:wKJL!!\u0014&\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003Q#J\u001bF\u000b\u0005\u0002'\u0001!)q&\u0002a\u0001a!)1'\u0002a\u0001i!)\u0001)\u0002a\u0001\u0003\")q)\u0002a\u0001\u0011\u0006\u0019b.\u001a=u!J|G-^2fe&#'\t\\8dWV\tq\u000bE\u0002YC\u000el\u0011!\u0017\u0006\u00035n\u000ba!\u0019;p[&\u001c'B\u0001/^\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003=~\u000bA!\u001e;jY*\t\u0001-\u0001\u0003kCZ\f\u0017B\u00012Z\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007C\u00013g\u001b\u0005)'B\u0001\u001dK\u0013\t9WM\u0001\tQe>$WoY3s\u0013\u0012\u001c(\t\\8dW\u00069b.\u001a=u!J|G-^2fe&#'\t\\8dW~#S-\u001d\u000b\u0003U6\u0004\"\u0001I6\n\u00051\f#\u0001B+oSRDqA\\\u0004\u0002\u0002\u0003\u0007q+A\u0002yIE\nAC\\3yiB\u0013x\u000eZ;dKJLEM\u00117pG.\u0004\u0013AF2veJ,g\u000e\u001e)s_\u0012,8-\u001a:JI\ncwnY6\u0002/\r,(O]3oiB\u0013x\u000eZ;dKJLEM\u00117pG.\u0004\u0013a\u0004:fcV,7\u000f^%o\r2Lw\r\u001b;\u0016\u0003Q\u0004\"\u0001W;\n\u0005YL&!D!u_6L7MQ8pY\u0016\fg.\u0001\tsKF,Xm\u001d;J]\u001ac\u0017n\u001a5uA\u0005\t\"-Y2l_\u001a4G)Z1eY&tW-T:\u0016\u0003i\u0004\"\u0001W>\n\u0005qL&AC!u_6L7\rT8oO\u0006\u0011\"-Y2l_\u001a4G)Z1eY&tW-T:!\u00035A\u0017m\u001d,bY&$'\t\\8dWV\u0011\u0011\u0011\u0001\t\u0004A\u0005\r\u0011bAA\u0003C\t9!i\\8mK\u0006t\u0017AE4f]\u0016\u0014\u0018\r^3Qe>$WoY3s\u0013\u0012$\"!a\u0003\u0011\u000b\u00055\u0011\u0011\u0003#\u000e\u0005\u0005=!B\u00010\"\u0013\u0011\t\u0019\"a\u0004\u0003\u0007Q\u0013\u00180A\u000bnCf\u0014WMU3rk\u0016\u001cHOT3yi\ncwnY6\u0015\u0003)\f1b]3oIJ+\u0017/^3ti\u0006\t\u0003.\u00198eY\u0016\fE\u000e\\8dCR,\u0007K]8ek\u000e,'/\u00133t%\u0016\u001c\bo\u001c8tKR\u0019!.a\b\t\u000f\u0005\u00052\u00031\u0001\u0002$\u0005q1\r\\5f]R\u0014Vm\u001d9p]N,\u0007\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%\u0012(A\u0004dY&,g\u000e^:\n\t\u00055\u0012q\u0005\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0003iA\u0017M\u001c3mKVs7/^2dKN\u001ch-\u001e7SKN\u0004xN\\:f\u00035A\u0017M\u001c3mKRKW.Z8vi\u0002")
public class RPCProducerIdManager
implements ProducerIdManager,
Logging {
    private final int brokerId;
    private final Time time;
    private final Function0<Object> brokerEpochSupplier;
    private final NodeToControllerChannelManager controllerChannel;
    private AtomicReference<ProducerIdsBlock> nextProducerIdBlock;
    private final AtomicReference<ProducerIdsBlock> currentProducerIdBlock;
    private final AtomicBoolean requestInFlight;
    private final AtomicLong backoffDeadlineMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        ProducerIdManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AtomicReference<ProducerIdsBlock> nextProducerIdBlock() {
        return this.nextProducerIdBlock;
    }

    public void nextProducerIdBlock_$eq(AtomicReference<ProducerIdsBlock> x$1) {
        this.nextProducerIdBlock = x$1;
    }

    private AtomicReference<ProducerIdsBlock> currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private AtomicBoolean requestInFlight() {
        return this.requestInFlight;
    }

    private AtomicLong backoffDeadlineMs() {
        return this.backoffDeadlineMs;
    }

    @Override
    public boolean hasValidBlock() {
        return this.nextProducerIdBlock().get() != null;
    }

    @Override
    public Try<Object> generateProducerId() {
        Failure result = null;
        int iteration = 0;
        while (result == null) {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.currentProducerIdBlock().get().claimNextId()));
            if (None$.MODULE$.equals(option)) {
                ProducerIdsBlock block = this.nextProducerIdBlock().getAndSet(null);
                if (block == null) {
                    this.maybeRequestNextBlock();
                    result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
                } else {
                    this.currentProducerIdBlock().set(block);
                    this.requestInFlight().set(false);
                    ++iteration;
                }
            } else if (option instanceof Some) {
                long prefetchTarget;
                Long nextProducerId = (Long)((Some)option).value();
                if (BoxesRunTime.equalsNumObject((Number)nextProducerId, (Object)BoxesRunTime.boxToLong((long)(prefetchTarget = this.currentProducerIdBlock().get().firstProducerId() + (long)((double)this.currentProducerIdBlock().get().size() * ProducerIdManager$.MODULE$.PidPrefetchThreshold()))))) {
                    this.maybeRequestNextBlock();
                }
                result = new Success((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(nextProducerId)));
            } else {
                throw new MatchError((Object)option);
            }
            if (iteration != ProducerIdManager$.MODULE$.IterationLimit()) continue;
            result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
        }
        return result;
    }

    private void maybeRequestNextBlock() {
        long retryTimestamp = this.backoffDeadlineMs().get();
        if (retryTimestamp == ProducerIdManager$.MODULE$.NoRetry() || this.time.milliseconds() >= retryTimestamp) {
            if (this.nextProducerIdBlock().get() == null && this.requestInFlight().compareAndSet(false, true)) {
                this.sendRequest();
                this.backoffDeadlineMs().set(ProducerIdManager$.MODULE$.NoRetry());
                return;
            }
            return;
        }
    }

    public void sendRequest() {
        AllocateProducerIdsRequestData message = new AllocateProducerIdsRequestData().setBrokerEpoch(this.brokerEpochSupplier.apply$mcJ$sp()).setBrokerId(this.brokerId);
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(message);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Requesting next Producer ID block");
        this.controllerChannel.sendRequest((AbstractRequest.Builder)request, new ControllerRequestCompletionHandler(this){
            private final /* synthetic */ RPCProducerIdManager $outer;

            public void onComplete(ClientResponse response) {
                this.$outer.handleAllocateProducerIdsResponse(response);
            }

            public void onTimeout() {
                this.$outer.kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void handleAllocateProducerIdsResponse(ClientResponse clientResponse) {
        if (clientResponse.authenticationException() != null) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to allocate producer id because of an authentication exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> clientResponse.authenticationException());
            this.handleUnsuccessfulResponse();
            return;
        }
        if (clientResponse.versionMismatch() != null) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to allocate producer id because of a version mismatch exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> clientResponse.versionMismatch());
            this.handleUnsuccessfulResponse();
            return;
        }
        if (!clientResponse.hasResponse()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to allocate producer id because of empty response from controller");
            this.handleUnsuccessfulResponse();
            return;
        }
        AllocateProducerIdsResponseData data = ((AllocateProducerIdsResponse)clientResponse.responseBody()).data();
        boolean successfulResponse = false;
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.NONE.equals(errors)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Got next producer ID block from controller ").append(data).toString());
            if (data.producerIdStart() < this.currentProducerIdBlock().get().lastProducerId()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Producer ID block is not monotonic with current block: current=").append(this.currentProducerIdBlock()).append(" response=").append(data).toString());
            } else if (data.producerIdStart() < 0L || data.producerIdLen() < 0 || data.producerIdStart() > Long.MAX_VALUE - (long)data.producerIdLen()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Producer ID block includes invalid ID range: ").append(data).toString());
            } else {
                this.nextProducerIdBlock().set(new ProducerIdsBlock(this.brokerId, data.producerIdStart(), data.producerIdLen()));
                successfulResponse = true;
            }
        } else if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Our broker currentBlockCount was stale, trying again.");
        } else if (Errors.BROKER_ID_NOT_REGISTERED.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Our broker ID is not yet known by the controller, trying again.");
        } else if (errors != null) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Received an unexpected error code from the controller: ").append(errors).toString());
        } else {
            throw new MatchError(null);
        }
        if (!successfulResponse) {
            this.handleUnsuccessfulResponse();
            return;
        }
    }

    private void handleUnsuccessfulResponse() {
        this.backoffDeadlineMs().set(this.time.milliseconds() + (long)ProducerIdManager$.MODULE$.RetryBackoffMs());
        this.requestInFlight().set(false);
    }

    public void kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout() {
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out when requesting AllocateProducerIds from the controller.");
        this.requestInFlight().set(false);
    }

    public RPCProducerIdManager(int brokerId, Time time, Function0<Object> brokerEpochSupplier, NodeToControllerChannelManager controllerChannel) {
        this.brokerId = brokerId;
        this.time = time;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.controllerChannel = controllerChannel;
        ProducerIdManager.$init$(this);
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(27).append("[RPC ProducerId Manager ").append(brokerId).append("]: ").toString());
        this.nextProducerIdBlock = new AtomicReference<Object>(null);
        this.currentProducerIdBlock = new AtomicReference<ProducerIdsBlock>(ProducerIdsBlock.EMPTY);
        this.requestInFlight = new AtomicBoolean(false);
        this.backoffDeadlineMs = new AtomicLong(ProducerIdManager$.MODULE$.NoRetry());
    }
}

