/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.TopicIdPartition;

final class Assignment {
    private final TopicIdPartition topicIdPartition;
    private final Uuid directoryId;
    private final long submissionTimeNs;
    private final Runnable successCallback;

    Assignment(TopicIdPartition topicIdPartition, Uuid directoryId, long submissionTimeNs, Runnable successCallback) {
        this.topicIdPartition = topicIdPartition;
        this.directoryId = directoryId;
        this.submissionTimeNs = submissionTimeNs;
        this.successCallback = successCallback;
    }

    TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    Uuid directoryId() {
        return this.directoryId;
    }

    long submissionTimeNs() {
        return this.submissionTimeNs;
    }

    Runnable successCallback() {
        return this.successCallback;
    }

    boolean valid(int nodeId, MetadataImage image) {
        TopicImage topicImage = image.topics().getTopic(this.topicIdPartition.topicId());
        if (topicImage == null) {
            return false;
        }
        PartitionRegistration partition = (PartitionRegistration)topicImage.partitions().get(this.topicIdPartition.partitionId());
        if (partition == null) {
            return false;
        }
        return Replicas.contains((int[])partition.replicas, (int)nodeId);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Assignment)) {
            return false;
        }
        Assignment other = (Assignment)o;
        return this.topicIdPartition.equals((Object)other.topicIdPartition) && this.directoryId.equals((Object)other.directoryId) && this.submissionTimeNs == other.submissionTimeNs && this.successCallback.equals(other.successCallback);
    }

    public int hashCode() {
        return Objects.hash(this.topicIdPartition, this.directoryId, this.submissionTimeNs, this.successCallback);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("Assignment");
        bld.append("(topicIdPartition=").append(this.topicIdPartition);
        bld.append(", directoryId=").append(this.directoryId);
        bld.append(", submissionTimeNs=").append(this.submissionTimeNs);
        bld.append(", successCallback=").append(this.successCallback);
        bld.append(")");
        return bld.toString();
    }
}

