/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class StreamTableJoinNode<K, V>
extends GraphNode {
    private final String[] storeNames;
    private final ProcessorParameters<K, V, ?, ?> processorParameters;
    private final String otherJoinSideNodeName;
    private final Duration gracePeriod;
    private final Optional<String> bufferName;

    public StreamTableJoinNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, String[] storeNames, String otherJoinSideNodeName, Duration gracePeriod, Optional<String> bufferName) {
        super(nodeName);
        this.storeNames = storeNames;
        this.processorParameters = processorParameters;
        this.otherJoinSideNodeName = otherJoinSideNodeName;
        this.gracePeriod = gracePeriod;
        this.bufferName = bufferName;
    }

    @Override
    public String toString() {
        return "StreamTableJoinNode{storeNames=" + Arrays.toString(this.storeNames) + ", processorParameters=" + this.processorParameters + ", otherJoinSideNodeName='" + this.otherJoinSideNodeName + '\'' + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        String processorName = this.processorParameters.processorName();
        ProcessorSupplier<K, V, ?, ?> processorSupplier = this.processorParameters.processorSupplier();
        topologyBuilder.addProcessor(processorName, processorSupplier, this.parentNodeNames());
        if (this.otherJoinSideNodeName != null) {
            topologyBuilder.connectProcessorAndStateStores(processorName, this.storeNames);
            this.bufferName.ifPresent(s -> topologyBuilder.connectProcessorAndStateStores(processorName, (String)s));
            if (this.gracePeriod != null) {
                for (String storeName : this.storeNames) {
                    if (!topologyBuilder.isStoreVersioned(storeName)) {
                        throw new IllegalArgumentException("KTable must be versioned to use a grace period in a stream table join.");
                    }
                    if (this.gracePeriod.toMillis() <= topologyBuilder.getHistoryRetention(storeName)) continue;
                    throw new IllegalArgumentException("History retention must be at least grace period.");
                }
            }
        }
    }
}

