/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Random;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.workload.ThroughputGenerator;

public class GaussianThroughputGenerator
implements ThroughputGenerator {
    private final int messagesPerWindowAverage;
    private final double messagesPerWindowDeviation;
    private final int windowsUntilRateChange;
    private final long windowSizeMs;
    private final Random random = new Random();
    private long nextWindowStarts = 0L;
    private int messageTracker = 0;
    private int windowTracker = 0;
    private int throttleMessages = 0;

    @JsonCreator
    public GaussianThroughputGenerator(@JsonProperty(value="messagesPerWindowAverage") int messagesPerWindowAverage, @JsonProperty(value="messagesPerWindowDeviation") double messagesPerWindowDeviation, @JsonProperty(value="windowsUntilRateChange") int windowsUntilRateChange, @JsonProperty(value="windowSizeMs") long windowSizeMs) {
        if (windowSizeMs <= 0L) {
            windowSizeMs = 100L;
        }
        this.windowSizeMs = windowSizeMs;
        this.messagesPerWindowAverage = messagesPerWindowAverage;
        this.messagesPerWindowDeviation = messagesPerWindowDeviation;
        this.windowsUntilRateChange = windowsUntilRateChange;
        this.calculateNextWindow(true);
    }

    @JsonProperty
    public int messagesPerWindowAverage() {
        return this.messagesPerWindowAverage;
    }

    @JsonProperty
    public double messagesPerWindowDeviation() {
        return this.messagesPerWindowDeviation;
    }

    @JsonProperty
    public long windowsUntilRateChange() {
        return this.windowsUntilRateChange;
    }

    @JsonProperty
    public long windowSizeMs() {
        return this.windowSizeMs;
    }

    private synchronized void calculateNextWindow(boolean force) {
        this.messageTracker = 0;
        long now = Time.SYSTEM.milliseconds();
        if (this.nextWindowStarts > 0L) {
            while (this.nextWindowStarts < now) {
                this.nextWindowStarts += this.windowSizeMs;
            }
        } else {
            this.nextWindowStarts = now + this.windowSizeMs;
        }
        if (this.windowTracker > this.windowsUntilRateChange || force) {
            this.windowTracker = 0;
            this.throttleMessages = Math.max((int)(this.random.nextGaussian() * this.messagesPerWindowDeviation) + this.messagesPerWindowAverage, 1);
        }
        ++this.windowTracker;
    }

    @Override
    public synchronized void throttle() throws InterruptedException {
        if (Time.SYSTEM.milliseconds() >= this.nextWindowStarts) {
            this.calculateNextWindow(false);
        }
        ++this.messageTracker;
        if (this.messageTracker >= this.throttleMessages) {
            while (this.nextWindowStarts > Time.SYSTEM.milliseconds()) {
                this.wait(this.nextWindowStarts - Time.SYSTEM.milliseconds());
            }
        }
    }
}

