/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.message.AddRaftVoterRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.UpdateRaftVoterRequestData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;

public final class Endpoints {
    private final Map<ListenerName, InetSocketAddress> endpoints;
    private static final Endpoints EMPTY = new Endpoints(Collections.emptyMap());

    private Endpoints(Map<ListenerName, InetSocketAddress> endpoints) {
        this.endpoints = endpoints;
    }

    public Optional<InetSocketAddress> address(ListenerName listener) {
        return Optional.ofNullable(this.endpoints.get(listener));
    }

    public Iterator<VotersRecord.Endpoint> votersRecordEndpoints() {
        return this.endpoints.entrySet().stream().map(entry -> new VotersRecord.Endpoint().setName(((ListenerName)entry.getKey()).value()).setHost(((InetSocketAddress)entry.getValue()).getHostString()).setPort(((InetSocketAddress)entry.getValue()).getPort())).iterator();
    }

    public int size() {
        return this.endpoints.size();
    }

    public boolean isEmpty() {
        return this.endpoints.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoints that = (Endpoints)o;
        return this.endpoints.equals(that.endpoints);
    }

    public int hashCode() {
        return Objects.hash(this.endpoints);
    }

    public String toString() {
        return String.format("Endpoints(endpoints=%s)", this.endpoints);
    }

    public BeginQuorumEpochRequestData.LeaderEndpointCollection toBeginQuorumEpochRequest() {
        BeginQuorumEpochRequestData.LeaderEndpointCollection leaderEndpoints = new BeginQuorumEpochRequestData.LeaderEndpointCollection(this.endpoints.size());
        for (Map.Entry<ListenerName, InetSocketAddress> entry : this.endpoints.entrySet()) {
            leaderEndpoints.add((ImplicitLinkedHashCollection.Element)new BeginQuorumEpochRequestData.LeaderEndpoint().setName(entry.getKey().value()).setHost(entry.getValue().getHostString()).setPort(entry.getValue().getPort()));
        }
        return leaderEndpoints;
    }

    public AddRaftVoterRequestData.ListenerCollection toAddVoterRequest() {
        AddRaftVoterRequestData.ListenerCollection listeners = new AddRaftVoterRequestData.ListenerCollection(this.endpoints.size());
        for (Map.Entry<ListenerName, InetSocketAddress> entry : this.endpoints.entrySet()) {
            listeners.add((ImplicitLinkedHashCollection.Element)new AddRaftVoterRequestData.Listener().setName(entry.getKey().value()).setHost(entry.getValue().getHostString()).setPort(entry.getValue().getPort()));
        }
        return listeners;
    }

    public DescribeQuorumResponseData.ListenerCollection toDescribeQuorumResponseListeners() {
        DescribeQuorumResponseData.ListenerCollection listeners = new DescribeQuorumResponseData.ListenerCollection(this.endpoints.size());
        for (Map.Entry<ListenerName, InetSocketAddress> entry : this.endpoints.entrySet()) {
            listeners.add((ImplicitLinkedHashCollection.Element)new DescribeQuorumResponseData.Listener().setName(entry.getKey().value()).setHost(entry.getValue().getHostString()).setPort(entry.getValue().getPort()));
        }
        return listeners;
    }

    public UpdateRaftVoterRequestData.ListenerCollection toUpdateVoterRequest() {
        UpdateRaftVoterRequestData.ListenerCollection listeners = new UpdateRaftVoterRequestData.ListenerCollection(this.endpoints.size());
        for (Map.Entry<ListenerName, InetSocketAddress> entry : this.endpoints.entrySet()) {
            listeners.add((ImplicitLinkedHashCollection.Element)new UpdateRaftVoterRequestData.Listener().setName(entry.getKey().value()).setHost(entry.getValue().getHostString()).setPort(entry.getValue().getPort()));
        }
        return listeners;
    }

    public static Endpoints empty() {
        return EMPTY;
    }

    public static Endpoints fromInetSocketAddresses(Map<ListenerName, InetSocketAddress> endpoints) {
        return new Endpoints(endpoints);
    }

    public static Endpoints fromVotersRecordEndpoints(Collection<VotersRecord.Endpoint> endpoints) {
        HashMap<ListenerName, InetSocketAddress> listeners = new HashMap<ListenerName, InetSocketAddress>(endpoints.size());
        for (VotersRecord.Endpoint endpoint : endpoints) {
            listeners.put(ListenerName.normalised((String)endpoint.name()), InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()));
        }
        return new Endpoints(listeners);
    }

    public static Endpoints fromBeginQuorumEpochRequest(BeginQuorumEpochRequestData.LeaderEndpointCollection endpoints) {
        HashMap<ListenerName, InetSocketAddress> listeners = new HashMap<ListenerName, InetSocketAddress>(endpoints.size());
        for (BeginQuorumEpochRequestData.LeaderEndpoint endpoint : endpoints) {
            listeners.put(ListenerName.normalised((String)endpoint.name()), InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()));
        }
        return new Endpoints(listeners);
    }

    public static Endpoints fromBeginQuorumEpochResponse(ListenerName listenerName, int leaderId, BeginQuorumEpochResponseData.NodeEndpointCollection endpoints) {
        return Optional.ofNullable(endpoints.find(leaderId)).map(endpoint -> new Endpoints(Collections.singletonMap(listenerName, InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port())))).orElse(Endpoints.empty());
    }

    public static Endpoints fromEndQuorumEpochRequest(EndQuorumEpochRequestData.LeaderEndpointCollection endpoints) {
        HashMap<ListenerName, InetSocketAddress> listeners = new HashMap<ListenerName, InetSocketAddress>(endpoints.size());
        for (EndQuorumEpochRequestData.LeaderEndpoint endpoint : endpoints) {
            listeners.put(ListenerName.normalised((String)endpoint.name()), InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()));
        }
        return new Endpoints(listeners);
    }

    public static Endpoints fromEndQuorumEpochResponse(ListenerName listenerName, int leaderId, EndQuorumEpochResponseData.NodeEndpointCollection endpoints) {
        return Optional.ofNullable(endpoints.find(leaderId)).map(endpoint -> new Endpoints(Collections.singletonMap(listenerName, InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port())))).orElse(Endpoints.empty());
    }

    public static Endpoints fromVoteResponse(ListenerName listenerName, int leaderId, VoteResponseData.NodeEndpointCollection endpoints) {
        return Optional.ofNullable(endpoints.find(leaderId)).map(endpoint -> new Endpoints(Collections.singletonMap(listenerName, InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port())))).orElse(Endpoints.empty());
    }

    public static Endpoints fromFetchResponse(ListenerName listenerName, int leaderId, FetchResponseData.NodeEndpointCollection endpoints) {
        return Optional.ofNullable(endpoints.find(leaderId)).map(endpoint -> new Endpoints(Collections.singletonMap(listenerName, InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port())))).orElse(Endpoints.empty());
    }

    public static Endpoints fromFetchSnapshotResponse(ListenerName listenerName, int leaderId, FetchSnapshotResponseData.NodeEndpointCollection endpoints) {
        return Optional.ofNullable(endpoints.find(leaderId)).map(endpoint -> new Endpoints(Collections.singletonMap(listenerName, InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port())))).orElse(Endpoints.empty());
    }

    public static Endpoints fromAddVoterRequest(AddRaftVoterRequestData.ListenerCollection endpoints) {
        HashMap<ListenerName, InetSocketAddress> listeners = new HashMap<ListenerName, InetSocketAddress>(endpoints.size());
        for (AddRaftVoterRequestData.Listener endpoint : endpoints) {
            listeners.put(ListenerName.normalised((String)endpoint.name()), InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()));
        }
        return new Endpoints(listeners);
    }

    public static Endpoints fromUpdateVoterRequest(UpdateRaftVoterRequestData.ListenerCollection endpoints) {
        HashMap<ListenerName, InetSocketAddress> listeners = new HashMap<ListenerName, InetSocketAddress>(endpoints.size());
        for (UpdateRaftVoterRequestData.Listener endpoint : endpoints) {
            listeners.put(ListenerName.normalised((String)endpoint.name()), InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()));
        }
        return new Endpoints(listeners);
    }
}

