/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKeyJsonConverter;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValue;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValueJsonConverter;
import org.apache.kafka.tools.consumer.ApiMessageFormatter;

public class TransactionLogMessageFormatter
extends ApiMessageFormatter {
    @Override
    protected JsonNode readToKeyJson(ByteBuffer byteBuffer, short version) {
        return this.readToTransactionLogKey(byteBuffer).map(logKey -> TransactionLogKeyJsonConverter.write((TransactionLogKey)logKey, (short)version)).orElseGet(() -> new TextNode("unknown"));
    }

    @Override
    protected JsonNode readToValueJson(ByteBuffer byteBuffer, short version) {
        return this.readToTransactionLogValue(byteBuffer).map(logValue -> TransactionLogValueJsonConverter.write((TransactionLogValue)logValue, (short)version)).orElseGet(() -> new TextNode("unknown"));
    }

    private Optional<TransactionLogKey> readToTransactionLogKey(ByteBuffer byteBuffer) {
        short version = byteBuffer.getShort();
        if (version >= 0 && version <= 0) {
            return Optional.of(new TransactionLogKey((Readable)new ByteBufferAccessor(byteBuffer), version));
        }
        return Optional.empty();
    }

    private Optional<TransactionLogValue> readToTransactionLogValue(ByteBuffer byteBuffer) {
        short version = byteBuffer.getShort();
        if (version >= 0 && version <= 1) {
            return Optional.of(new TransactionLogValue((Readable)new ByteBufferAccessor(byteBuffer), version));
        }
        return Optional.empty();
    }
}

