/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.net.URI;
import java.util.Set;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class ExternalDocumentation
extends SwaggerElement {
    private String description;
    private URI url;

    public ExternalDocumentation() {
    }

    public ExternalDocumentation(ExternalDocumentation copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        this.url = copyFrom.url;
    }

    public ExternalDocumentation copy() {
        return new ExternalDocumentation(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "url" -> ConverterUtils.toType(this.getUrl(), type);
            default -> super.get(property, type);
        };
    }

    public String getDescription() {
        return this.description;
    }

    public URI getUrl() {
        return this.url;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.description), "description").addIf(Utils.nn(this.url), "url").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public ExternalDocumentation set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "description" -> this.setDescription(Utils.s(value));
            case "url" -> this.setUrl(StringUtils.toUri(value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public ExternalDocumentation setDescription(String value) {
        this.description = value;
        return this;
    }

    public ExternalDocumentation setUrl(URI value) {
        this.url = value;
        return this;
    }

    @Override
    public ExternalDocumentation strict() {
        super.strict();
        return this;
    }

    @Override
    public ExternalDocumentation strict(Object value) {
        super.strict(value);
        return this;
    }
}

