/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.ExecutableInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;

public class BeanCreateMethodFinder<T> {
    private Class<T> beanType;
    private final Class<?> resourceClass;
    private final Object resource;
    private final BeanStore beanStore;
    private MethodInfo method;
    private Object[] args;
    private Supplier<T> def = () -> null;

    BeanCreateMethodFinder(Class<T> beanType, Class<?> resourceClass, BeanStore beanStore) {
        this.beanType = AssertionUtils.assertArgNotNull("beanType", beanType);
        this.resource = null;
        this.resourceClass = AssertionUtils.assertArgNotNull("resourceClass", resourceClass);
        this.beanStore = BeanStore.of(beanStore);
    }

    BeanCreateMethodFinder(Class<T> beanType, Object resource, BeanStore beanStore) {
        this.beanType = AssertionUtils.assertArgNotNull("beanType", beanType);
        this.resource = AssertionUtils.assertArgNotNull("resource", resource);
        this.resourceClass = resource.getClass();
        this.beanStore = BeanStore.of(beanStore, resource);
    }

    public <T2> BeanCreateMethodFinder<T> addBean(Class<T2> c, T2 t) {
        this.beanStore.addBean(c, t);
        return this;
    }

    public BeanCreateMethodFinder<T> find(Predicate<MethodInfo> filter) {
        if (this.method == null) {
            ReflectionUtils.info(this.resourceClass).getPublicMethod(x -> x.isNotDeprecated() && x.hasReturnType(this.beanType) && !x.hasAnnotation(BeanIgnore.class) && filter.test((MethodInfo)x) && this.beanStore.hasAllParams((ExecutableInfo)x) && (x.isStatic() || Utils.nn(this.resource))).ifPresent(m -> {
                this.method = m;
                this.args = this.beanStore.getParams((ExecutableInfo)m);
            });
        }
        return this;
    }

    public BeanCreateMethodFinder<T> find(String methodName) {
        return this.find((MethodInfo x) -> x.hasName(methodName));
    }

    public T run() throws ExecutableException {
        if (Utils.nn(this.method)) {
            return this.method.invoke(this.resource, this.args);
        }
        return this.def.get();
    }

    public T run(Consumer<? super T> consumer) throws ExecutableException {
        T t = this.run();
        if (Utils.nn(t)) {
            consumer.accept(t);
        }
        return t;
    }

    public BeanCreateMethodFinder<T> thenFind(Predicate<MethodInfo> filter) {
        return this.find(filter);
    }

    public BeanCreateMethodFinder<T> thenFind(String methodName) {
        return this.find(methodName);
    }

    public BeanCreateMethodFinder<T> withDefault(Supplier<T> def) {
        AssertionUtils.assertArgNotNull("def", def);
        this.def = def;
        return this;
    }

    public BeanCreateMethodFinder<T> withDefault(T def) {
        return this.withDefault((T)((Supplier<Object>)() -> def));
    }
}

