/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.FormattedIllegalArgumentException;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.Visibility;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.ConfigBuilder;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConfigAnnotationFilter;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.BasicRestLogger;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.MessageBundleLocation;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestChild;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestContextProperties;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.StaticFileMapping;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.reshandlers.DefaultHandler;
import org.apache.juneau.rest.reshandlers.InputStreamHandler;
import org.apache.juneau.rest.reshandlers.ReaderHandler;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.ClasspathResourceFinder;
import org.apache.juneau.utils.ClasspathResourceManager;

public class RestContextBuilder
extends BeanContextBuilder
implements ServletConfig {
    final ServletConfig inner;
    Class<?> resourceClass;
    Object resource;
    ServletContext servletContext;
    RestContext parentContext;
    RestContextProperties properties;
    Config config;
    VarResolverBuilder varResolverBuilder;

    RestContextBuilder(ServletConfig servletConfig, Class<?> resourceClass, RestContext parentContext) throws ServletException {
        this.inner = servletConfig;
        this.resourceClass = resourceClass;
        this.parentContext = parentContext;
        this.properties = new RestContextProperties();
        ClassInfo rci = ClassInfo.of(resourceClass);
        this.logger(BasicRestLogger.class);
        this.partSerializer(OpenApiSerializer.class);
        this.partParser(OpenApiParser.class);
        this.staticFileResponseHeader("Cache-Control", "max-age=86400, public");
        this.encoders(IdentityEncoder.INSTANCE);
        this.responseHandlers(ReaderHandler.class, InputStreamHandler.class, DefaultHandler.class);
        try {
            Annotation r;
            this.varResolverBuilder = new VarResolverBuilder().defaultVars().vars(ConfigVar.class).vars(FileVar.class).contextObject("crm", new ClasspathResourceManager(resourceClass));
            VarResolver vr = this.varResolverBuilder.build();
            List<AnnotationInfo<RestResource>> restResourceAnnotationsParentFirst = rci.getAnnotationInfosParentFirst(RestResource.class);
            List<AnnotationInfo<Rest>> restAnnotationsParentFirst = rci.getAnnotationInfosParentFirst(Rest.class);
            String configPath = "";
            for (AnnotationInfo<RestResource> annotationInfo : restResourceAnnotationsParentFirst) {
                if (annotationInfo.getAnnotation().config().isEmpty()) continue;
                configPath = annotationInfo.getAnnotation().config();
            }
            for (AnnotationInfo<Annotation> annotationInfo : restAnnotationsParentFirst) {
                if (((Rest)annotationInfo.getAnnotation()).config().isEmpty()) continue;
                configPath = ((Rest)annotationInfo.getAnnotation()).config();
            }
            String cf = vr.resolve(configPath);
            if ("SYSTEM_DEFAULT".equals(cf)) {
                this.config = Config.getSystemDefault();
            }
            if (this.config == null) {
                ConfigBuilder configBuilder = Config.create().varResolver(vr);
                if (!cf.isEmpty()) {
                    configBuilder.name(cf);
                }
                this.config = configBuilder.build();
            }
            this.varResolverBuilder.contextObject("config", this.config);
            vr = this.varResolverBuilder.build();
            if (servletConfig != null) {
                Enumeration enumeration = servletConfig.getInitParameterNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String initParam = servletConfig.getInitParameter(string);
                    this.set(vr.resolve(string), vr.resolve(initParam));
                }
            }
            this.applyAnnotations(rci.getAnnotationListParentFirst(ConfigAnnotationFilter.INSTANCE), vr.createSession());
            for (AnnotationInfo<RestResource> annotationInfo : restResourceAnnotationsParentFirst) {
                r = annotationInfo.getAnnotation();
                for (Property property : r.properties()) {
                    this.set(vr.resolve(property.name()), vr.resolve(property.value()));
                }
                for (String string : r.flags()) {
                    this.set(string, true);
                }
            }
            for (AnnotationInfo<Rest> annotationInfo : restAnnotationsParentFirst) {
                r = annotationInfo.getAnnotation();
                for (Property property : r.properties()) {
                    this.set(vr.resolve(property.name()), vr.resolve(property.value()));
                }
                for (String string : r.flags()) {
                    this.set(string, true);
                }
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public RestContext build() {
        try {
            return new RestContext(this);
        }
        catch (Exception e) {
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
    }

    RestContextBuilder init(Object resource) throws ServletException {
        this.resource = resource;
        ClassInfo rci = ClassInfo.of(this.resourceClass);
        LinkedHashMap<String, MethodInfo> map = new LinkedHashMap<String, MethodInfo>();
        for (MethodInfo m : rci.getAllMethodsParentFirst()) {
            if (!m.hasAnnotation(RestHook.class) || m.getAnnotation(RestHook.class).value() != HookEvent.INIT) continue;
            m.setAccessible();
            String sig = m.getSignature();
            if (map.containsKey(sig)) continue;
            map.put(sig, m);
        }
        for (MethodInfo m : map.values()) {
            RestContextBuilder.assertArgsOnlyOfType(m, RestContextBuilder.class, ServletConfig.class);
            Class<?>[] pt = m.getRawParamTypes();
            Object[] args = new Object[pt.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = pt[i] == RestContextBuilder.class ? this : this.inner;
            }
            try {
                m.invoke(resource, args);
            }
            catch (Exception e) {
                throw new RestServletException("Exception thrown from @RestHook(INIT) method {0}.", m).initCause(e);
            }
        }
        return this;
    }

    private static void assertArgsOnlyOfType(MethodInfo m, Class<?> ... args) {
        if (!m.argsOnlyOfType(args)) {
            throw new FormattedIllegalArgumentException("Invalid arguments passed to method {0}.  Only arguments of type {1} are allowed.", m, args);
        }
    }

    RestContextBuilder servletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        return this;
    }

    public RestContextBuilder vars(Class<?> ... vars) {
        this.varResolverBuilder.vars(vars);
        return this;
    }

    public RestContextBuilder varContextObject(String name, Object object) {
        this.varResolverBuilder.contextObject(name, object);
        return this;
    }

    public RestContextBuilder config(Config config) {
        this.config = config;
        return this;
    }

    protected PropertyStoreBuilder createPropertyStore() {
        return PropertyStore.create().add(this.properties);
    }

    public Config getConfig() {
        return this.config;
    }

    public RestContextProperties getProperties() {
        return this.properties;
    }

    public VarResolverBuilder getVarResolverBuilder() {
        return this.varResolverBuilder;
    }

    public String getPath() {
        Object p = this.peek("RestContext.path.s");
        return p == null ? "_" : p.toString();
    }

    public RestContextBuilder allowBodyParam(boolean value) {
        return this.set("RestContext.allowBodyParam.b", value);
    }

    public RestContextBuilder allowedHeaderParams(String value) {
        return this.set("RestContext.allowedHeaderParams.s", value);
    }

    public RestContextBuilder allowedMethodHeaders(String value) {
        return this.set("RestContext.allowedMethodHeaders.s", value);
    }

    public RestContextBuilder allowedMethodParams(String value) {
        return this.set("RestContext.allowedMethodParams.s", value);
    }

    @Deprecated
    public RestContextBuilder allowHeaderParams(boolean value) {
        return this.set("RestContext.allowedHeaderParams.s", value ? "*" : null);
    }

    public RestContextBuilder callHandler(Class<? extends RestCallHandler> value) {
        return this.set("RestContext.callHandler.o", value);
    }

    public RestContextBuilder callHandler(RestCallHandler value) {
        return this.set("RestContext.callHandler.o", value);
    }

    public RestContextBuilder callLogger(Class<? extends RestCallLogger> value) {
        return this.set("RestContext.callLogger.o", value);
    }

    public RestContextBuilder callLogger(RestCallLogger value) {
        return this.set("RestContext.callLogger.o", value);
    }

    public RestContextBuilder callLoggerConfig(RestCallLoggerConfig value) {
        return this.set("RestContext.callLoggerConfig.o", value);
    }

    public RestContextBuilder children(Class<?> ... values) {
        return this.addTo("RestContext.children.lo", values);
    }

    public RestContextBuilder children(Object ... values) {
        return this.addTo("RestContext.children.lo", values);
    }

    public RestContextBuilder child(String path, Object child) {
        return this.addTo("RestContext.children.lo", new RestChild(path, child));
    }

    public RestContextBuilder classpathResourceFinder(Class<? extends ClasspathResourceFinder> value) {
        return this.set("RestContext.classpathResourceFinder.o", value);
    }

    public RestContextBuilder classpathResourceFinder(ClasspathResourceFinder value) {
        return this.set("RestContext.classpathResourceFinder.o", value);
    }

    public RestContextBuilder clientVersionHeader(String value) {
        return this.set("RestContext.clientVersionHeader.s", value);
    }

    public RestContextBuilder converters(Class<?> ... values) {
        return this.addTo("RestContext.converters.lo", values);
    }

    public RestContextBuilder converters(RestConverter ... values) {
        return this.addTo("RestContext.converters.lo", values);
    }

    @Override
    public RestContextBuilder debug(boolean value) {
        super.debug(value);
        return this.debug(Enablement.TRUE);
    }

    public RestContextBuilder debug(Enablement value) {
        return this.set("RestContext.debug.s", (Object)value);
    }

    public RestContextBuilder defaultCharset(String value) {
        return this.set("RestContext.defaultCharset.s", value);
    }

    public RestContextBuilder defaultCharset(Charset value) {
        return this.set("RestContext.defaultCharset.s", value);
    }

    @Deprecated
    public RestContextBuilder attrs(String ... values) throws RestServletException {
        return this.reqAttrs(values);
    }

    @Deprecated
    public RestContextBuilder defaultRequestHeaders(String ... headers) throws RestServletException {
        return this.reqHeaders(headers);
    }

    public RestContextBuilder defaultAccept(String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.reqHeader("Accept", value);
        }
        return this;
    }

    public RestContextBuilder defaultContentType(String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.reqHeader("Content-Type", value);
        }
        return this;
    }

    @Deprecated
    public RestContextBuilder attr(String name, Object value) {
        return this.reqAttr(name, value);
    }

    @Deprecated
    public RestContextBuilder defaultRequestHeader(String name, Object value) {
        return this.reqHeader(name, value);
    }

    @Deprecated
    public RestContextBuilder defaultResponseHeaders(String ... headers) throws RestServletException {
        return this.resHeaders(headers);
    }

    @Deprecated
    public RestContextBuilder defaultResponseHeader(String name, Object value) {
        return this.resHeader(name, value);
    }

    public RestContextBuilder encoders(Class<?> ... values) {
        return this.addTo("RestContext.encoders.lo", values);
    }

    public RestContextBuilder encoders(Encoder ... values) {
        return this.addTo("RestContext.encoders.lo", values);
    }

    public RestContextBuilder guards(Class<?> ... values) {
        return this.addTo("RestContext.guards.lo", values);
    }

    public RestContextBuilder guards(RestGuard ... values) {
        return this.addTo("RestContext.guards.lo", values);
    }

    public RestContextBuilder infoProvider(Class<? extends RestInfoProvider> value) {
        return this.set("RestContext.infoProvider.o", value);
    }

    public RestContextBuilder infoProvider(RestInfoProvider value) {
        return this.set("RestContext.infoProvider.o", value);
    }

    @Deprecated
    public RestContextBuilder logger(Class<? extends RestLogger> value) {
        return this.set("RestContext.logger.o", value);
    }

    @Deprecated
    public RestContextBuilder logger(RestLogger value) {
        return this.set("RestContext.logger.o", value);
    }

    public RestContextBuilder maxInput(String value) {
        return this.set("RestContext.maxInput.s", value);
    }

    public RestContextBuilder messages(MessageBundleLocation ... values) {
        return this.addTo("RestContext.messages.lo", values);
    }

    public RestContextBuilder messages(Class<?> baseClass, String bundlePath) {
        return this.addTo("RestContext.messages.lo", new MessageBundleLocation(baseClass, bundlePath));
    }

    public RestContextBuilder messages(String bundlePath) {
        return this.addTo("RestContext.messages.lo", new MessageBundleLocation(null, bundlePath));
    }

    public RestContextBuilder mimeTypes(String ... values) {
        return this.addTo("RestContext.mimeTypes.ss", values);
    }

    public RestContextBuilder paramResolvers(Class<? extends RestMethodParam> ... values) {
        return this.addTo("RestContext.paramResolvers.lo", values);
    }

    public RestContextBuilder paramResolvers(RestMethodParam ... values) {
        return this.addTo("RestContext.paramResolvers.lo", values);
    }

    public RestContextBuilder parserListener(Class<? extends ParserListener> value) {
        if (value != ParserListener.Null.class) {
            this.set("Parser.listener.c", value);
        }
        return this;
    }

    public RestContextBuilder parsers(Class<?> ... values) {
        return this.addTo("RestContext.parsers.lo", values);
    }

    public RestContextBuilder parsers(Object ... values) {
        return this.addTo("RestContext.parsers.lo", values);
    }

    public RestContextBuilder parsersReplace(Object ... values) {
        return this.set("RestContext.parsers.lo", values);
    }

    public RestContextBuilder partParser(Class<? extends HttpPartParser> value) {
        if (value != HttpPartParser.Null.class) {
            this.set("RestContext.partParser.o", value);
        }
        return this;
    }

    public RestContextBuilder partParser(HttpPartParser value) {
        return this.set("RestContext.partParser.o", value);
    }

    public RestContextBuilder partSerializer(Class<? extends HttpPartSerializer> value) {
        if (value != HttpPartSerializer.Null.class) {
            this.set("RestContext.partSerializer.o", value);
        }
        return this;
    }

    public RestContextBuilder partSerializer(HttpPartSerializer value) {
        return this.set("RestContext.partSerializer.o", value);
    }

    public RestContextBuilder path(String value) {
        if (StringUtils.startsWith(value, '/')) {
            value = value.substring(1);
        }
        this.set("RestContext.path.s", value);
        return this;
    }

    public RestContextBuilder renderResponseStackTraces(boolean value) {
        return this.set("RestContext.renderResponseStackTraces.b", value);
    }

    public RestContextBuilder renderResponseStackTraces() {
        return this.set("RestContext.renderResponseStackTraces.b", true);
    }

    public RestContextBuilder reqAttr(String name, Object value) {
        return this.addTo("RestContext.reqAttrs.smo", name, value);
    }

    public RestContextBuilder reqAttrs(String ... values) throws RestServletException {
        for (String v : values) {
            String[] p = RestUtils.parseKeyValuePair(v);
            if (p == null) {
                throw new RestServletException("Invalid default request attribute specified: ''{0}''.  Must be in the format: ''Name: value''", v);
            }
            this.reqHeader(p[0], p[1]);
        }
        return this;
    }

    public RestContextBuilder reqHeader(String name, Object value) {
        return this.addTo("RestContext.reqHeaders.smo", name, value);
    }

    public RestContextBuilder reqHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid default request header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.reqHeader(h[0], h[1]);
        }
        return this;
    }

    public RestContextBuilder resHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid default response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.resHeader(h[0], h[1]);
        }
        return this;
    }

    public RestContextBuilder resHeader(String name, Object value) {
        return this.addTo("RestContext.resHeaders.omo", name, value);
    }

    public RestContextBuilder resourceResolver(Class<? extends RestResourceResolver> value) {
        return this.set("RestContext.resourceResolver.o", value);
    }

    public RestContextBuilder resourceResolver(RestResourceResolver value) {
        return this.set("RestContext.resourceResolver.o", value);
    }

    public RestContextBuilder responseHandlers(Class<?> ... values) {
        return this.addTo("RestContext.responseHandlers.lo", values);
    }

    public RestContextBuilder responseHandlers(ResponseHandler ... values) {
        return this.addTo("RestContext.responseHandlers.lo", values);
    }

    public RestContextBuilder rolesDeclared(String ... values) {
        return this.addTo("RestContext.rolesDeclared.ss", values);
    }

    public RestContextBuilder roleGuard(String value) {
        return this.addTo("RestContext.roleGuard.ss", value);
    }

    public RestContextBuilder serializerListener(Class<? extends SerializerListener> value) {
        if (value != SerializerListener.Null.class) {
            this.set("Serializer.listener.c", value);
        }
        return this;
    }

    public RestContextBuilder serializers(Class<?> ... values) {
        return this.addTo("RestContext.serializers.lo", values);
    }

    public RestContextBuilder serializersReplace(Class<?> ... values) {
        return this.set("RestContext.serializers.lo", values);
    }

    public RestContextBuilder serializers(Object ... values) {
        return this.addTo("RestContext.serializers.lo", values);
    }

    public RestContextBuilder serializersReplace(Object ... values) {
        return this.set("RestContext.serializers.lo", values);
    }

    public RestContextBuilder staticFileResponseHeaders(Map<String, String> headers) {
        return this.addTo("RestContext.staticFileResponseHeaders.omo", headers);
    }

    public RestContextBuilder staticFileResponseHeadersReplace(Map<String, String> headers) {
        return this.set("RestContext.staticFileResponseHeaders.omo", headers);
    }

    public RestContextBuilder staticFileResponseHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid static file response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.staticFileResponseHeader(h[0], h[1]);
        }
        return this;
    }

    public RestContextBuilder staticFileResponseHeader(String name, String value) {
        return this.addTo("RestContext.staticFileResponseHeaders.omo", name, value);
    }

    public RestContextBuilder staticFiles(StaticFileMapping ... values) {
        return this.addTo("RestContext.staticFiles.lo", values);
    }

    public RestContextBuilder staticFiles(String mappingString) throws ParseException {
        for (StaticFileMapping sfm : CollectionUtils.reverseIterable(StaticFileMapping.parse(this.resourceClass, mappingString))) {
            this.staticFiles(sfm);
        }
        return this;
    }

    public RestContextBuilder staticFiles(Class<?> baseClass, String mappingString) throws ParseException {
        for (StaticFileMapping sfm : CollectionUtils.reverseIterable(StaticFileMapping.parse(baseClass, mappingString))) {
            this.staticFiles(sfm);
        }
        return this;
    }

    public RestContextBuilder staticFiles(String path, String location) {
        return this.staticFiles(new StaticFileMapping(this.resourceClass, path, location, null));
    }

    public RestContextBuilder staticFiles(Class<?> baseClass, String path, String location) {
        return this.staticFiles(new StaticFileMapping(baseClass, path, location, null));
    }

    public RestContextBuilder produces(String ... values) {
        return this.addTo("RestContext.produces.ls", values);
    }

    public RestContextBuilder producesReplace(String ... values) {
        return this.set("RestContext.produces.ls", values);
    }

    public RestContextBuilder produces(MediaType ... values) {
        return this.addTo("RestContext.produces.ls", values);
    }

    public RestContextBuilder producesReplace(MediaType ... values) {
        return this.set("RestContext.produces.ls", values);
    }

    public RestContextBuilder consumes(String ... values) {
        return this.addTo("RestContext.consumes.ls", values);
    }

    public RestContextBuilder consumesReplace(String ... values) {
        return this.set("RestContext.consumes.ls", values);
    }

    public RestContextBuilder consumes(MediaType ... values) {
        return this.addTo("RestContext.consumes.ls", values);
    }

    public RestContextBuilder consumesReplace(MediaType ... values) {
        return this.set("RestContext.consumes.ls", values);
    }

    public RestContextBuilder properties(Map<String, Object> values) {
        return this.addTo("RestContext.properties.sms", values);
    }

    public RestContextBuilder property(String name, Object value) {
        return this.addTo("RestContext.properties.sms", name, value);
    }

    public RestContextBuilder uriAuthority(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriAuthority.s", value);
        }
        return this;
    }

    public RestContextBuilder uriContext(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriContext.s", value);
        }
        return this;
    }

    public RestContextBuilder uriRelativity(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriRelativity.s", value);
        }
        return this;
    }

    public RestContextBuilder uriResolution(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriResolution.s", value);
        }
        return this;
    }

    public RestContextBuilder useClasspathResourceCaching(boolean value) {
        return this.set("RestContext.useClasspathResourceCaching.b", value);
    }

    @Deprecated
    public RestContextBuilder useStackTraceHashes(boolean value) {
        return this.set("RestContext.useStackTraceHashes.b", value);
    }

    @Deprecated
    public RestContextBuilder widgets(Class<? extends Widget> ... values) {
        return this.addTo("RestContext.widgets.lo", values);
    }

    @Deprecated
    public RestContextBuilder widgetsReplace(Class<? extends Widget> ... values) {
        return this.set("RestContext.widgets.lo", values);
    }

    @Deprecated
    public RestContextBuilder widgets(Widget ... values) {
        return this.addTo("RestContext.widgets.lo", values);
    }

    @Deprecated
    public RestContextBuilder widgetsReplace(Widget ... values) {
        return this.set("RestContext.widgets.lo", values);
    }

    @Override
    public RestContextBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    @Override
    @Deprecated
    public RestContextBuilder beanDictionary(Class<?> ... values) {
        super.beanDictionary(values);
        return this;
    }

    @Override
    @Deprecated
    public RestContextBuilder beanDictionary(Object ... values) {
        super.beanDictionary(values);
        return this;
    }

    @Override
    @Deprecated
    public RestContextBuilder beanDictionaryReplace(Class<?> ... values) {
        super.beanDictionaryReplace(values);
        return this;
    }

    @Override
    @Deprecated
    public RestContextBuilder beanDictionaryReplace(Object ... values) {
        super.beanDictionaryReplace(values);
        return this;
    }

    @Override
    @Deprecated
    public RestContextBuilder beanDictionaryRemove(Class<?> ... values) {
        super.beanDictionaryRemove(values);
        return this;
    }

    @Override
    @Deprecated
    public RestContextBuilder beanDictionaryRemove(Object ... values) {
        super.beanDictionaryRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beanFilters(Class<?> ... values) {
        super.beanFilters(values);
        return this;
    }

    @Override
    public RestContextBuilder beanFilters(Object ... values) {
        super.beanFilters(values);
        return this;
    }

    @Override
    public RestContextBuilder beanFiltersReplace(Class<?> ... values) {
        super.beanFiltersReplace(values);
        return this;
    }

    @Override
    public RestContextBuilder beanFiltersReplace(Object ... values) {
        super.beanFiltersReplace(values);
        return this;
    }

    @Override
    public RestContextBuilder beanFiltersRemove(Class<?> ... values) {
        super.beanFiltersRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder beanFiltersRemove(Object ... values) {
        super.beanFiltersRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder beanMapPutReturnsOldValue(boolean value) {
        super.beanMapPutReturnsOldValue(value);
        return this;
    }

    @Override
    public RestContextBuilder beanMapPutReturnsOldValue() {
        super.beanMapPutReturnsOldValue();
        return this;
    }

    @Override
    public RestContextBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beansRequireDefaultConstructor(boolean value) {
        super.beansRequireDefaultConstructor(value);
        return this;
    }

    @Override
    public RestContextBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSerializable(boolean value) {
        super.beansRequireSerializable(value);
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSettersForGetters(boolean value) {
        super.beansRequireSettersForGetters(value);
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSomeProperties(boolean value) {
        super.beansRequireSomeProperties(value);
        return this;
    }

    @Override
    public RestContextBuilder beanTypePropertyName(String value) {
        super.beanTypePropertyName(value);
        return this;
    }

    @Override
    public RestContextBuilder bpi(Class<?> beanClass, String value) {
        super.bpi(beanClass, value);
        return this;
    }

    @Override
    public RestContextBuilder bpi(Map<String, String> values) {
        super.bpi(values);
        return this;
    }

    @Override
    public RestContextBuilder bpi(String beanClassName, String value) {
        super.bpi(beanClassName, value);
        return this;
    }

    @Override
    public RestContextBuilder bpx(Class<?> beanClass, String properties) {
        super.bpx(beanClass, properties);
        return this;
    }

    @Override
    public RestContextBuilder bpx(Map<String, String> values) {
        super.bpx(values);
        return this;
    }

    @Override
    public RestContextBuilder bpx(String beanClassName, String value) {
        super.bpx(beanClassName, value);
        return this;
    }

    @Override
    public RestContextBuilder bpro(Class<?> beanClass, String value) {
        super.bpro(beanClass, value);
        return this;
    }

    @Override
    public RestContextBuilder bpro(Map<String, String> values) {
        super.bpro(values);
        return this;
    }

    @Override
    public RestContextBuilder bpro(String beanClassName, String value) {
        super.bpro(beanClassName, value);
        return this;
    }

    @Override
    public RestContextBuilder bpwo(Class<?> beanClass, String properties) {
        super.bpwo(beanClass, properties);
        return this;
    }

    @Override
    public RestContextBuilder bpwo(Map<String, String> values) {
        super.bpwo(values);
        return this;
    }

    @Override
    public RestContextBuilder bpwo(String beanClassName, String value) {
        super.bpwo(beanClassName, value);
        return this;
    }

    @Override
    public RestContextBuilder debug() {
        this.debug(Enablement.TRUE);
        super.debug();
        return this;
    }

    @Override
    public RestContextBuilder dictionary(Class<?> ... values) {
        super.dictionary(values);
        return this;
    }

    @Override
    public RestContextBuilder dictionary(Object ... values) {
        super.dictionary(values);
        return this;
    }

    @Override
    public RestContextBuilder dictionaryReplace(Class<?> ... values) {
        super.dictionaryReplace(values);
        return this;
    }

    @Override
    public RestContextBuilder dictionaryReplace(Object ... values) {
        super.dictionaryReplace(values);
        return this;
    }

    @Override
    public RestContextBuilder dictionaryRemove(Class<?> ... values) {
        super.dictionaryRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder dictionaryRemove(Object ... values) {
        super.dictionaryRemove(values);
        return this;
    }

    @Override
    public <T> RestContextBuilder example(Class<T> c, T o) {
        super.example(c, o);
        return this;
    }

    @Override
    public <T> RestContextBuilder exampleJson(Class<T> c, String value) {
        super.exampleJson(c, value);
        return this;
    }

    @Override
    public RestContextBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        super.ignoreInvocationExceptionsOnGetters(value);
        return this;
    }

    @Override
    public RestContextBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    @Override
    public RestContextBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        super.ignoreInvocationExceptionsOnSetters(value);
        return this;
    }

    @Override
    public RestContextBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    @Override
    public RestContextBuilder ignorePropertiesWithoutSetters(boolean value) {
        super.ignorePropertiesWithoutSetters(value);
        return this;
    }

    @Override
    public RestContextBuilder ignoreUnknownBeanProperties(boolean value) {
        super.ignoreUnknownBeanProperties(value);
        return this;
    }

    @Override
    public RestContextBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    @Override
    public RestContextBuilder ignoreUnknownNullBeanProperties(boolean value) {
        super.ignoreUnknownNullBeanProperties(value);
        return this;
    }

    @Override
    public RestContextBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    @Override
    public RestContextBuilder implClasses(Map<String, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    @Override
    public RestContextBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    @Override
    public RestContextBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClasses(Class<?> ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClassesReplace(Class<?> ... values) {
        super.notBeanClassesReplace(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClassesReplace(Object ... values) {
        super.notBeanClassesReplace(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClassesRemove(Class<?> ... values) {
        super.notBeanClassesRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClassesRemove(Object ... values) {
        super.notBeanClassesRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackages(String ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackagesReplace(String ... values) {
        super.notBeanPackagesReplace(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackagesReplace(Object ... values) {
        super.notBeanPackagesReplace(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackagesRemove(String ... values) {
        super.notBeanPackagesRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackagesRemove(Object ... values) {
        super.notBeanPackagesRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder pojoSwaps(Class<?> ... values) {
        super.pojoSwaps(values);
        return this;
    }

    @Override
    public RestContextBuilder pojoSwaps(Object ... values) {
        super.pojoSwaps(values);
        return this;
    }

    @Override
    public RestContextBuilder pojoSwapsReplace(Class<?> ... values) {
        super.pojoSwapsReplace(values);
        return this;
    }

    @Override
    public RestContextBuilder pojoSwapsReplace(Object ... values) {
        super.pojoSwapsReplace(values);
        return this;
    }

    @Override
    public RestContextBuilder pojoSwapsRemove(Class<?> ... values) {
        super.pojoSwapsRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder pojoSwapsRemove(Object ... values) {
        super.pojoSwapsRemove(values);
        return this;
    }

    @Override
    public RestContextBuilder sortProperties(boolean value) {
        super.sortProperties(value);
        return this;
    }

    @Override
    public RestContextBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    @Override
    public RestContextBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    @Override
    public RestContextBuilder useEnumNames(boolean value) {
        super.useEnumNames(value);
        return this;
    }

    @Override
    public RestContextBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    @Override
    public RestContextBuilder useInterfaceProxies(boolean value) {
        super.useInterfaceProxies(value);
        return this;
    }

    @Override
    public RestContextBuilder useJavaBeanIntrospector(boolean value) {
        super.useJavaBeanIntrospector(value);
        return this;
    }

    @Override
    public RestContextBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }

    @Override
    public RestContextBuilder annotations(Annotation ... values) {
        super.annotations(values);
        return this;
    }

    @Override
    public RestContextBuilder set(String name, Object value) {
        super.set(name, value);
        this.properties.put(name, value);
        this.addTo("RestContext.properties.sms", name, value);
        return this;
    }

    @Override
    public RestContextBuilder set(Map<String, Object> properties) {
        super.set((Map)properties);
        this.properties.clear();
        this.properties.putAll(properties);
        this.addTo("RestContext.properties.sms", properties);
        return this;
    }

    @Override
    public RestContextBuilder add(Map<String, Object> properties) {
        super.add((Map)properties);
        return this;
    }

    @Override
    public RestContextBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public RestContextBuilder addTo(String name, String key, Object value) {
        super.addTo(name, key, value);
        return this;
    }

    @Override
    public RestContextBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public RestContextBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    @Override
    public RestContextBuilder applyAnnotations(AnnotationList al, VarResolverSession vrs) {
        super.applyAnnotations(al, vrs);
        return this;
    }

    @Override
    public RestContextBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations((Class[])fromClasses);
        return this;
    }

    @Override
    public RestContextBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }

    public String getInitParameter(String name) {
        return this.inner.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.inner.getInitParameterNames();
    }

    public ServletContext getServletContext() {
        return this.inner.getServletContext();
    }

    public String getServletName() {
        return this.inner.getServletName();
    }
}

