/*
 * Decompiled with CFR 0.152.
 */
package tdb.tools;

import arq.cmdline.CmdARQ;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.tdb1.base.file.FileFactory;
import org.apache.jena.tdb1.base.file.FileSet;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.base.objectfile.ObjectFile;
import org.apache.jena.tdb1.lib.NodeLib;
import org.apache.jena.tdb1.setup.StoreParams;
import org.apache.jena.tdb1.store.NodeId;
import tdb.cmdline.ModLocation;

public class dumpnodes
extends CmdARQ {
    ModLocation modLocation = new ModLocation();

    public static void main(String ... argv) {
        LogCtl.setLogging();
        new dumpnodes(argv).mainRun();
    }

    @Override
    protected void exec() {
        Location loc = this.modLocation.getLocation();
        ObjectFile objFile = this.determineNodeTable(loc);
        dumpnodes.dump(System.out, objFile);
    }

    private ObjectFile determineNodeTable(Location loc) {
        StoreParams storeParams = StoreParams.getDftStoreParams();
        FileSet fsId2Node = new FileSet(loc, storeParams.getIndexId2Node());
        String file = fsId2Node.filename("dat");
        ObjectFile objFile = FileFactory.createObjectFileDisk(file);
        return objFile;
    }

    protected dumpnodes(String[] argv) {
        super(argv);
        super.addModule(this.modLocation);
    }

    private static Iterator<Pair<NodeId, Node>> all(ObjectFile objFile) {
        Iterator<Pair<Long, ByteBuffer>> objs = objFile.all();
        Function<Pair, Pair> transform = item -> {
            NodeId id = NodeId.create((Long)item.car());
            ByteBuffer bb = (ByteBuffer)item.cdr();
            Node n = NodeLib.decode(bb);
            return new Pair<NodeId, Node>(id, n);
        };
        return Iter.map(objs, transform);
    }

    public static void dump(OutputStream w, ObjectFile objFile) {
        Iterator<Pair<NodeId, Node>> iter = dumpnodes.all(objFile);
        long count = 0L;
        try (IndentedWriter iw = new IndentedWriter(w);){
            if (!iter.hasNext()) {
                iw.println("No nodes in the .dat file");
                return;
            }
            while (iter.hasNext()) {
                Pair<NodeId, Node> pair = iter.next();
                iw.print(pair.car().toString());
                iw.print(" : ");
                Node n = pair.cdr();
                String $ = dumpnodes.stringForNode(n);
                iw.print($);
                iw.println();
                ++count;
            }
            iw.println();
            iw.printf("Total: " + count, new Object[0]);
            iw.println();
            iw.flush();
        }
    }

    private static String stringForNode(Node n) {
        if (n == null) {
            return "<<null>>";
        }
        if (n.isBlank()) {
            return "_:" + n.getBlankNodeLabel();
        }
        if (n.isLiteral()) {
            return dumpnodes.stringForLiteral((Node_Literal)n);
        }
        if (n.isURI()) {
            String uri = n.getURI();
            return dumpnodes.stringForURI(uri);
        }
        if (n.isVariable()) {
            return "?" + n.getName();
        }
        if (n.equals(Node.ANY)) {
            return "ANY";
        }
        Log.warn(FmtUtils.class, "Failed to turn a node into a string: " + String.valueOf(n));
        return n.toString();
    }

    public static String stringForURI(String uri) {
        return "<" + uri + ">";
    }

    public static String stringForLiteral(Node_Literal literal) {
        String datatype = literal.getLiteralDatatypeURI();
        String lang = literal.getLiteralLanguage();
        String s = literal.getLiteralLexicalForm();
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("\"");
        FmtUtils.stringEsc(sbuff, s, true);
        sbuff.append("\"");
        if (lang != null && lang.length() > 0) {
            sbuff.append("@");
            sbuff.append(lang);
        }
        if (datatype != null) {
            sbuff.append("^^");
            sbuff.append(dumpnodes.stringForURI(datatype));
        }
        return sbuff.toString();
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.modVersion.getVersionFlag()) {
            this.modVersion.printVersionAndExit();
        }
        if (this.modLocation.getLocation() == null) {
            this.cmdError("Location required");
        }
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --loc=DIR IndexName";
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }
}

