/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.sys;

import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.main.sys.FusekiAutoModule;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.slf4j.Logger;

public class FusekiAutoModules {
    private static final Logger LOG = Fuseki.serverLog;
    private static final Object lock = new Object();
    private static FusekiModules currentLoadedModules = null;
    private static ServiceLoader<FusekiAutoModule> serviceLoader = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FusekiModules get() {
        if (currentLoadedModules != null) {
            return currentLoadedModules;
        }
        Object object = lock;
        synchronized (object) {
            if (currentLoadedModules == null) {
                FusekiAutoModules.load();
            }
            return currentLoadedModules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FusekiModules load() {
        Object object = lock;
        synchronized (object) {
            if (serviceLoader == null) {
                serviceLoader = FusekiAutoModules.createServiceLoader();
            }
            currentLoadedModules = FusekiAutoModules.loadAutoModules(serviceLoader);
        }
        return currentLoadedModules;
    }

    static void reset() {
        currentLoadedModules = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceLoader<FusekiAutoModule> createServiceLoader() {
        Class<FusekiAutoModule> moduleClass = FusekiAutoModule.class;
        ServiceLoader<FusekiAutoModule> newServiceLoader = null;
        Object object = lock;
        synchronized (object) {
            try {
                newServiceLoader = ServiceLoader.load(moduleClass, FusekiAutoModules.class.getClassLoader());
            }
            catch (ServiceConfigurationError ex) {
                FmtLog.error(LOG, (Throwable)ex, "Problem with service loading for %s", moduleClass.getName());
                throw ex;
            }
            if (LOG.isDebugEnabled()) {
                newServiceLoader.stream().forEach(provider -> FmtLog.info(LOG, "Fuseki Module: %s", provider.type().getSimpleName()));
            }
        }
        return newServiceLoader;
    }

    private static FusekiModules loadAutoModules(ServiceLoader<FusekiAutoModule> serviceLoader) {
        if (serviceLoader == null) {
            FmtLog.error(LOG, "Discovery step has not happened or it failed. Call FusekiSystemModules.discovery before FusekiSystemModules.load()", new Object[0]);
            throw new FusekiConfigException("Discovery not performed");
        }
        Function<ServiceLoader.Provider, FusekiAutoModule> mapper = provider -> {
            try {
                FusekiAutoModule afmod = (FusekiAutoModule)provider.get();
                return afmod;
            }
            catch (ServiceConfigurationError ex) {
                FmtLog.error(LOG, (Throwable)ex, "Error instantiating class %s for %s", provider.type().getName(), FusekiModule.class.getName());
                return null;
            }
        };
        List<FusekiAutoModule> autoMods = serviceLoader.stream().map(mapper).filter(Objects::nonNull).sorted((x, y) -> Integer.compare(x.level(), y.level())).toList();
        List<FusekiModule> fmods = autoMods.stream().map(afmod -> {
            afmod.start();
            return afmod;
        }).toList();
        return FusekiModules.create(fmods);
    }

    private static /* synthetic */ void lambda$loadAutoModules$4(FusekiModule m) {
        String name = m.name();
        if (name == null) {
            name = m.getClass().getSimpleName();
        }
        FmtLog.debug(LOG, "Module: %s", name);
    }
}

