/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public class DNSPublicKeyRecordRetriever
implements PublicKeyRecordRetriever {
    protected final Resolver resolver;

    public DNSPublicKeyRecordRetriever() {
        this(Lookup.getDefaultResolver());
    }

    public DNSPublicKeyRecordRetriever(Resolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public List<String> getRecords(CharSequence methodAndOptions, CharSequence selector, CharSequence token) throws TempFailException, PermFailException {
        Lookup query;
        if (!"dns/txt".equals(methodAndOptions)) {
            throw new PermFailException("Only dns/txt is supported: " + methodAndOptions + " options unsupported.");
        }
        try {
            query = new Lookup(selector + "._domainkey." + token, 16);
        }
        catch (TextParseException e) {
            throw new PermFailException("Invalid dns record", (Exception)((Object)e));
        }
        query.setResolver(this.resolver);
        Record[] rr = query.run();
        if (query.getResult() == 2) {
            throw new TempFailException(query.getErrorString());
        }
        if (rr == null || rr.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(rr).filter(r -> r.getType() == 16).map(r -> String.join((CharSequence)"", ((TXTRecord)r).getStrings())).collect(Collectors.toList());
    }
}

