/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.lock;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.lock.LockEntry;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.lock.StampedWriterPreferredLock;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;

public class LockManager {
    private final LockPool lockPool = new LockPool();
    private final StampedWriterPreferredLock readWriteLock = new StampedWriterPreferredLock();

    public long stampedReadLock(ICachedMNode node) {
        AtomicLong stamp = new AtomicLong();
        this.takeMNodeLock(node, lock -> stamp.set(lock.stampedReadLock()));
        return stamp.get();
    }

    public void stampedReadUnlock(ICachedMNode node, long stamp) {
        this.checkAndReleaseMNodeLock(node, lock -> lock.stampedReadUnlock(stamp));
    }

    public void threadReadLock(ICachedMNode node) {
        this.takeMNodeLock(node, StampedWriterPreferredLock::threadReadLock);
    }

    public void threadReadLock(ICachedMNode node, boolean prior) {
        this.takeMNodeLock(node, lock -> lock.threadReadLock(prior));
    }

    public void threadReadUnlock(ICachedMNode node) {
        this.checkAndReleaseMNodeLock(node, StampedWriterPreferredLock::threadReadUnlock);
    }

    public void writeLock(ICachedMNode node) {
        this.takeMNodeLock(node, StampedWriterPreferredLock::writeLock);
    }

    public void writeUnlock(ICachedMNode node) {
        this.checkAndReleaseMNodeLock(node, StampedWriterPreferredLock::writeUnlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeMNodeLock(ICachedMNode node, Consumer<StampedWriterPreferredLock> lockOperation) {
        LockEntry lockEntry;
        LockManager lockManager = this;
        synchronized (lockManager) {
            lockEntry = node.getLockEntry();
            if (lockEntry == null) {
                lockEntry = this.lockPool.borrowLock();
                node.setLockEntry(lockEntry);
            }
            lockEntry.pin();
        }
        lockOperation.accept(lockEntry.getLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndReleaseMNodeLock(ICachedMNode node, Consumer<StampedWriterPreferredLock> unLockOperation) {
        LockManager lockManager = this;
        synchronized (lockManager) {
            LockEntry lockEntry = node.getLockEntry();
            StampedWriterPreferredLock lock = lockEntry.getLock();
            unLockOperation.accept(lock);
            lockEntry.unpin();
            if (lock.isFree() && !lockEntry.isPinned()) {
                node.setLockEntry(null);
                this.lockPool.returnLock(lockEntry);
            }
        }
    }

    public long globalStampedReadLock() {
        return this.readWriteLock.stampedReadLock();
    }

    public void globalStampedReadUnlock(long stamp) {
        this.readWriteLock.stampedReadUnlock(stamp);
    }

    public void globalReadLock() {
        this.readWriteLock.threadReadLock();
    }

    public void globalReadLock(boolean prior) {
        this.readWriteLock.threadReadLock(prior);
    }

    public void globalReadUnlock() {
        this.readWriteLock.threadReadUnlock();
    }

    public void globalWriteLock() {
        this.readWriteLock.writeLock();
    }

    public void globalWriteUnlock() {
        this.readWriteLock.writeUnlock();
    }

    private static class LockPool {
        private static final int LOCK_POOL_CAPACITY = 400;
        private final List<LockEntry> lockList = new LinkedList<LockEntry>();

        private LockPool() {
            for (int i = 0; i < 400; ++i) {
                this.lockList.add(new LockEntry());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LockEntry borrowLock() {
            List<LockEntry> list = this.lockList;
            synchronized (list) {
                if (this.lockList.isEmpty()) {
                    return new LockEntry();
                }
                return this.lockList.remove(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void returnLock(LockEntry lockEntry) {
            List<LockEntry> list = this.lockList;
            synchronized (list) {
                if (this.lockList.size() == 400) {
                    return;
                }
                this.lockList.add(0, lockEntry);
            }
        }
    }
}

